/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class ActionContext
implements Cloneable {
    private final ConfigurationSection parameters;
    private final SpellAction action;

    public ActionContext(SpellAction action, ConfigurationSection actionParameters) {
        this.action = action;
        this.parameters = actionParameters;
    }

    public void initialize(Spell spell, ConfigurationSection baseParameters) {
        this.action.initialize(spell, this.getEffectiveParameters(baseParameters));
    }

    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.action.prepare(context, this.getEffectiveParameters(parameters));
    }

    public SpellResult perform(CastContext context) {
        boolean hasEntityTarget;
        boolean hasTarget = context.getTargetLocation() != null;
        boolean bl = hasEntityTarget = context.getTargetEntity() != null;
        if (this.action.requiresTarget() && !hasTarget) {
            return SpellResult.NO_TARGET;
        }
        if (this.action.requiresTargetEntity() && !hasEntityTarget) {
            return SpellResult.NO_TARGET;
        }
        SpellResult result = this.action.perform(context);
        return this.action.ignoreResult() && !result.isStop() ? SpellResult.NO_ACTION : result;
    }

    public ConfigurationSection getActionParameters() {
        return this.parameters;
    }

    public ConfigurationSection getEffectiveParameters(ConfigurationSection baseParameters) {
        ConfigurationSection effectiveParameters = baseParameters;
        if (this.parameters != null || baseParameters == null || baseParameters.contains("actions")) {
            ConfigurationSection overrideParameters;
            effectiveParameters = new MemoryConfiguration();
            ConfigurationUtils.addConfigurations(effectiveParameters, baseParameters);
            effectiveParameters.set("actions", null);
            String parametersKey = this.parameters == null ? null : this.parameters.getString("parameters");
            ConfigurationSection configurationSection = overrideParameters = parametersKey == null || baseParameters == null ? null : ConfigurationUtils.getConfigurationSection(baseParameters, parametersKey);
            if (overrideParameters != null) {
                ConfigurationUtils.addConfigurations(effectiveParameters, overrideParameters);
            }
            ConfigurationUtils.addConfigurations(effectiveParameters, this.parameters);
        }
        return effectiveParameters;
    }

    public SpellAction getAction() {
        return this.action;
    }

    public void finish(CastContext context) {
        this.action.finish(context);
    }

    public Object clone() {
        return new ActionContext((SpellAction)this.action.clone(), this.parameters);
    }
}

