/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.protection;

import com.elmakers.mine.bukkit.protection.TownyManager;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownyAPI {
    private final Towny towny;
    private final TownyManager controller;
    private Method getPlayerByNameMethod;
    private Method getPlayerByUUIDMethod;

    public TownyAPI(TownyManager manager, Plugin plugin) throws IllegalArgumentException, NoSuchMethodException {
        this.controller = manager;
        if (!(plugin instanceof Towny)) {
            throw new IllegalArgumentException("Towny plugin not an instance of Towny class");
        }
        this.towny = (Towny)plugin;
        try {
            this.getPlayerByNameMethod = TownyDataSource.class.getMethod("getResident", String.class);
        }
        catch (Exception ex) {
            this.getPlayerByUUIDMethod = TownyDataSource.class.getMethod("getResident", UUID.class);
        }
    }

    public boolean isPVPAllowed(Location location) {
        Coord coord;
        if (this.towny == null || location == null) {
            return true;
        }
        if (this.controller.wildernessBypass && TownyUniverse.isWilderness((Block)location.getBlock())) {
            return true;
        }
        TownBlock townBlock = TownyUniverse.getTownBlock((Location)location);
        if (townBlock == null) {
            return true;
        }
        TownyWorld world = townBlock.getWorld();
        if (world.isWarZone(coord = Coord.parseCoord((Location)location))) {
            return true;
        }
        if (townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            return true;
        }
        if (townBlock.getWorld().isForcePVP()) {
            return true;
        }
        Town town = null;
        try {
            if (townBlock.hasTown()) {
                town = townBlock.getTown();
            }
        }
        catch (NotRegisteredException ex) {
            // empty catch block
        }
        if (town == null) {
            return true;
        }
        return !town.isAdminDisabledPVP() && town.isPVP();
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (block != null && this.towny != null && player != null) {
            if (this.controller.wildernessBypass && TownyUniverse.isWilderness((Block)block)) {
                return true;
            }
            return PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Integer)block.getTypeId(), (byte)block.getData(), (TownyPermission.ActionType)TownyPermission.ActionType.BUILD);
        }
        return true;
    }

    public boolean hasBreakPermission(Player player, Block block) {
        if (block != null && this.towny != null && player != null) {
            if (this.controller.wildernessBypass && TownyUniverse.isWilderness((Block)block)) {
                return true;
            }
            return PlayerCacheUtil.getCachePermission((Player)player, (Location)block.getLocation(), (Integer)block.getTypeId(), (byte)block.getData(), (TownyPermission.ActionType)TownyPermission.ActionType.DESTROY);
        }
        return true;
    }

    public boolean canTarget(Entity entity, Entity target) {
        if (this.towny != null && target != null && entity != null) {
            return !CombatUtil.preventDamageCall((Towny)this.towny, (Entity)entity, (Entity)target);
        }
        return true;
    }

    protected Resident getResident(Player player) {
        block4: {
            try {
                if (this.getPlayerByNameMethod != null) {
                    return (Resident)this.getPlayerByNameMethod.invoke((Object)TownyUniverse.getDataSource(), player.getName());
                }
                if (this.getPlayerByUUIDMethod != null) {
                    return (Resident)this.getPlayerByUUIDMethod.invoke((Object)TownyUniverse.getDataSource(), player.getUniqueId());
                }
            }
            catch (Exception ex) {
                if (ex instanceof TownyException) break block4;
                Bukkit.getLogger().log(Level.WARNING, "Error getting Towny Resident", ex);
            }
        }
        return null;
    }

    public Location getTownLocation(Player player) {
        if (this.towny == null || player == null) {
            return null;
        }
        Resident resident = this.getResident(player);
        if (resident == null) {
            return null;
        }
        Town town = null;
        try {
            town = resident.getTown();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (town == null) {
            return null;
        }
        Location location = null;
        try {
            location = town.getSpawn();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return location;
    }

    public boolean createPlot(Location center, Double price) {
        WorldCoord worldCoord = new WorldCoord(center.getWorld().getName(), Coord.parseCoord((Location)center));
        try {
            TownBlock townBlock = worldCoord.getTownBlock();
            if (price == null) {
                price = worldCoord.getTownBlock().getTown().getPlotTypePrice(worldCoord.getTownBlock().getType());
            }
            townBlock.setPlotPrice(price.doubleValue());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

