/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.citizens.CitizensTrait;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Set;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.util.DataKey;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MagicCitizensTrait
extends CitizensTrait {
    private String spellKey;
    private boolean npcCaster = false;
    private YamlConfiguration parameters = null;

    public MagicCitizensTrait() {
        super("magic");
    }

    @Override
    public void load(DataKey data) {
        super.load(data);
        this.spellKey = data.getString("spell", null);
        this.npcCaster = data.getBoolean("caster", false);
        String parameterString = data.getString("parameters", null);
        this.parameters = new YamlConfiguration();
        if (parameterString != null && !parameterString.isEmpty()) {
            if (!parameterString.contains(":")) {
                String[] simple = StringUtils.split((String)parameterString, (String)" ");
                if (simple.length > 0) {
                    ConfigurationUtils.addParameters(simple, (ConfigurationSection)this.parameters);
                }
            } else {
                try {
                    this.parameters.loadFromString(parameterString);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void save(DataKey data) {
        super.save(data);
        data.setString("spell", this.spellKey);
        data.setBoolean("caster", this.npcCaster);
        String parameterString = this.parameters == null ? null : this.parameters.saveToString();
        data.setString("parameters", parameterString);
    }

    @Override
    public boolean perform(NPCRightClickEvent event) {
        if (this.spellKey == null || this.spellKey.isEmpty()) {
            return false;
        }
        Player sender = event.getClicker();
        Player entity = event.getClicker();
        YamlConfiguration config = this.parameters;
        if (this.npcCaster && event.getNPC().isSpawned()) {
            entity = event.getNPC().getEntity();
            sender = null;
            config = new MemoryConfiguration();
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)this.parameters);
            config.set("player", (Object)event.getClicker().getName());
        }
        return this.api.cast(this.spellKey, (ConfigurationSection)config, (CommandSender)sender, (Entity)entity);
    }

    @Override
    public void describe(CommandSender sender) {
        super.describe(sender);
        String spellDescription = this.spellKey == null ? ChatColor.RED + "(None)" : ChatColor.LIGHT_PURPLE + this.spellKey;
        sender.sendMessage(ChatColor.DARK_PURPLE + "Spell: " + spellDescription);
        String casterDescription = this.npcCaster ? ChatColor.GRAY + "NPC" : ChatColor.LIGHT_PURPLE + "Player";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Caster: " + casterDescription);
        sender.sendMessage(ChatColor.DARK_PURPLE + "Parameters: ");
        this.describeParameters(sender);
    }

    protected void describeParameters(CommandSender sender) {
        Set keys = this.parameters.getKeys(false);
        if (keys.size() == 0) {
            sender.sendMessage(ChatColor.GRAY + " (None)");
        }
        for (String key : keys) {
            String value = null;
            if (this.parameters.isConfigurationSection(key)) {
                ConfigurationSection child = this.parameters.getConfigurationSection(key);
                value = "(" + child.getKeys(false).size() + " values)";
            } else {
                value = this.parameters.getString(key);
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + " " + key + ": " + value);
        }
    }

    @Override
    public void configure(CommandSender sender, String key, String value) {
        if (key == null) {
            return;
        }
        if (key.equalsIgnoreCase("spell") || key.equalsIgnoreCase("cast")) {
            this.spellKey = value;
            if (value == null) {
                sender.sendMessage(ChatColor.RED + "Cleared spell");
            } else {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set spell to: " + ChatColor.LIGHT_PURPLE + this.spellKey);
            }
        } else if (key.equalsIgnoreCase("parameters")) {
            if (value == null) {
                sender.sendMessage(ChatColor.RED + "Cleared parameters");
                this.parameters = new YamlConfiguration();
            } else {
                String[] params = StringUtils.split((String)value, (String)" ");
                this.parameters = new YamlConfiguration();
                ConfigurationUtils.addParameters(params, (ConfigurationSection)this.parameters);
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set parameters to: ");
                this.describeParameters(sender);
            }
        } else if (key.equalsIgnoreCase("caster")) {
            if (value == null || !value.equalsIgnoreCase("true")) {
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as player");
                this.npcCaster = false;
            } else {
                this.npcCaster = true;
                sender.sendMessage(ChatColor.DARK_PURPLE + "Set caster as NPC");
            }
        } else if (value == null || value.isEmpty()) {
            this.spellKey = key;
            sender.sendMessage(ChatColor.DARK_PURPLE + "Set spell to: " + ChatColor.LIGHT_PURPLE + this.spellKey);
        } else {
            super.configure(sender, key, value);
        }
    }
}

