/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpellShopAction
extends BaseShopAction {
    private boolean showRequired = false;
    private boolean showFree = false;
    private boolean showUpgrades = false;
    private boolean allowLocked = false;
    private Map<String, Double> spells = new HashMap<String, Double>();

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        block2: {
            block3: {
                super.initialize(spell, parameters);
                this.spells.clear();
                if (!parameters.contains("spells")) break block2;
                if (!parameters.isConfigurationSection("spells")) break block3;
                ConfigurationSection spellSection = ConfigurationUtils.getConfigurationSection(parameters, "spells");
                Set spellKeys = spellSection.getKeys(false);
                for (String spellKey : spellKeys) {
                    this.spells.put(spellKey, spellSection.getDouble(spellKey));
                }
                break block2;
            }
            List<String> spellList = ConfigurationUtils.getStringList(parameters, "spells");
            if (spellList == null) break block2;
            for (String spellKey : spellList) {
                this.spells.put(spellKey, null);
            }
        }
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.showRequired = parameters.getBoolean("show_required", false);
        this.showFree = parameters.getBoolean("show_free", false);
        this.showUpgrades = parameters.getBoolean("show_upgrades", false);
        this.allowLocked = parameters.getBoolean("allow_locked", false);
        if (!this.castsSpells) {
            this.requireWand = true;
            this.applyToWand = true;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath currentPath;
        Mage mage = context.getMage();
        MageController controller = context.getController();
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        Wand wand = context.getWand();
        com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = currentPath = wand == null ? null : wand.getPath();
        if (!this.castsSpells && !this.allowLocked && wand.isLocked()) {
            context.showMessage(context.getMessage("no_path", "You may not learn with that $wand.").replace("$wand", wand.getName()));
            return SpellResult.FAIL;
        }
        HashMap<String, Double> spellPrices = new HashMap<String, Double>();
        if (this.spells.size() > 0) {
            spellPrices.putAll(this.spells);
        } else {
            if (currentPath == null) {
                context.showMessage(context.getMessage("no_path", "You may not learn with that $wand.").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            Collection<String> pathSpells = currentPath.getSpells();
            for (String string : pathSpells) {
                spellPrices.put(string, null);
            }
            if (this.showRequired) {
                Collection<String> requiredSpells = currentPath.getRequiredSpells();
                for (String requiredSpell : requiredSpells) {
                    spellPrices.put(requiredSpell, null);
                }
            }
            if (this.showUpgrades) {
                Collection<String> spells = wand.getSpells();
                for (String spellKey : spells) {
                    MageSpell spell = mage.getSpell(spellKey);
                    SpellTemplate upgradeSpell = spell.getUpgrade();
                    if (upgradeSpell == null) continue;
                    spellPrices.put(upgradeSpell.getKey(), null);
                }
            }
        }
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        for (Map.Entry entry : spellPrices.entrySet()) {
            String requiredPathKey;
            String key = (String)entry.getKey();
            key = context.parameterize(key);
            String spellKey = key.split(" ", 2)[0];
            if (!this.castsSpells && wand.hasSpell(spellKey)) continue;
            SpellTemplate spell = controller.getSpellTemplate(spellKey);
            Double worth = (Double)entry.getValue();
            if (worth == null) {
                worth = spell.getWorth();
            }
            if (worth <= 0.0 && !this.showFree || !spell.hasCastPermission(mage.getCommandSender())) continue;
            ItemStack spellItem = controller.createSpellItem(key, this.castsSpells);
            if (!this.castsSpells && (requiredPathKey = spell.getRequiredUpgradePath()) != null && spell.getSpellKey().getLevel() > 1 && !currentPath.hasPath(requiredPathKey)) {
                String upgradeDescription;
                WandUpgradePath upgradePath = WandUpgradePath.getPath(requiredPathKey = currentPath.translatePath(requiredPathKey));
                if (upgradePath == null) continue;
                ItemMeta meta = spellItem.getItemMeta();
                List itemLore = meta.getLore();
                ArrayList<String> lore = new ArrayList<String>();
                if (itemLore.size() > 0) {
                    lore.add((String)itemLore.get(0));
                }
                if ((upgradeDescription = spell.getUpgradeDescription()) != null && !upgradeDescription.isEmpty()) {
                    InventoryUtils.wrapText(upgradeDescription, BaseSpell.MAX_LORE_LENGTH, lore);
                }
                String message = context.getMessage("level_requirement", "&r&cRequires: &6$path").replace("$path", upgradePath.getName());
                lore.add(message);
                for (int i = 1; i < itemLore.size(); ++i) {
                    lore.add((String)itemLore.get(i));
                }
                meta.setLore(lore);
                spellItem.setItemMeta(meta);
                InventoryUtils.setMeta(spellItem, "unpurchasable", message);
            }
            shopItems.add(new BaseShopAction.ShopItem(spellItem, worth));
        }
        Collections.sort(shopItems);
        return this.showItems(context, shopItems);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("show_free");
        parameters.add("show_required");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("show_free") || parameterKey.equals("show_required")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

