/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.EntityProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.slikey.effectlib.math.VectorTransform;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandProjectileAction
extends EntityProjectileAction {
    private boolean smallArmorStand = false;
    private boolean armorStandMarker = false;
    private boolean armorStandInvisible = false;
    private boolean armorStandGravity = false;
    private boolean adjustArmPitch = false;
    private boolean adjustHeadPitch = false;
    private boolean showArmorStandArms = true;
    private ItemStack rightArmItem = null;
    private ItemStack helmetItem = null;
    private ItemStack chestplateItem = null;
    private ItemStack leggingsItem = null;
    private ItemStack bootsItem = null;
    private VectorTransform leftArmTransform;
    private VectorTransform rightArmTransform;
    private VectorTransform leftLegTransform;
    private VectorTransform rightLegTransform;
    private VectorTransform bodyTransform;
    private VectorTransform headTransform;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.isConfigurationSection("left_arm_transform")) {
            this.leftArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_arm_transform")) {
            this.rightArmTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_arm_transform"));
        }
        if (parameters.isConfigurationSection("right_leg_transform")) {
            this.rightLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "right_leg_transform"));
        }
        if (parameters.isConfigurationSection("left_leg_transform")) {
            this.leftLegTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "left_leg_transform"));
        }
        if (parameters.isConfigurationSection("head_transform")) {
            this.headTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "head_transform"));
        }
        if (parameters.isConfigurationSection("body_transform")) {
            this.bodyTransform = new VectorTransform(ConfigurationUtils.getConfigurationSection(parameters, "body_transform"));
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", true);
        this.armorStandInvisible = parameters.getBoolean("armor_stand_invisible", true);
        this.armorStandGravity = parameters.getBoolean("armor_stand_gravity", true);
        this.showArmorStandArms = parameters.getBoolean("armor_stand_arms", true);
        this.smallArmorStand = parameters.getBoolean("armor_stand_small", false);
        this.adjustHeadPitch = parameters.getBoolean("orient_head", false);
        this.adjustArmPitch = parameters.getBoolean("orient_right_arm", false);
        MaterialAndData itemType = ConfigurationUtils.getMaterialAndData(parameters, "right_arm_item");
        if (itemType != null) {
            this.rightArmItem = itemType.getItemStack(1);
        }
        if ((itemType = ConfigurationUtils.getMaterialAndData(parameters, "helmet_item")) != null) {
            this.helmetItem = itemType.getItemStack(1);
        }
        if ((itemType = ConfigurationUtils.getMaterialAndData(parameters, "chestplate_item")) != null) {
            this.chestplateItem = itemType.getItemStack(1);
        }
        if ((itemType = ConfigurationUtils.getMaterialAndData(parameters, "leggings_item")) != null) {
            this.leggingsItem = itemType.getItemStack(1);
        }
        if ((itemType = ConfigurationUtils.getMaterialAndData(parameters, "boots_item")) != null) {
            this.bootsItem = itemType.getItemStack(1);
        }
    }

    @Override
    public SpellResult start(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Location location = context.getEyeLocation();
        ArmorStand armorStand = (ArmorStand)this.setEntity(controller, (Entity)CompatibilityUtils.spawnArmorStand(location));
        CompatibilityUtils.setYawPitch((Entity)armorStand, location.getYaw(), location.getPitch());
        armorStand.setItemInHand(this.rightArmItem);
        armorStand.setHelmet(this.helmetItem);
        armorStand.setChestplate(this.chestplateItem);
        armorStand.setLeggings(this.leggingsItem);
        armorStand.setBoots(this.bootsItem);
        armorStand.setMarker(this.armorStandMarker);
        armorStand.setVisible(!this.armorStandInvisible);
        armorStand.setGravity(this.armorStandGravity);
        armorStand.setSmall(this.smallArmorStand);
        armorStand.setArms(this.showArmorStandArms);
        CompatibilityUtils.setDisabledSlots(armorStand, 0x1F1F00);
        CompatibilityUtils.addToWorld(location.getWorld(), (Entity)armorStand, this.spawnReason);
        return super.start(context);
    }

    @Override
    public SpellResult step(CastContext context) {
        double pitchOffset;
        Vector direction;
        SpellResult result = super.step(context);
        ArmorStand armorStand = (ArmorStand)this.entity;
        double t = (double)this.flightTime / 1000.0;
        Location currentLocation = this.entity.getLocation();
        if (this.leftArmTransform != null) {
            direction = this.leftArmTransform.get(this.launchLocation, t);
            armorStand.setLeftArmPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightArmTransform != null) {
            direction = this.rightArmTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustArmPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setRightArmPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustArmPitch) {
            EulerAngle armPose = armorStand.getRightArmPose();
            armPose.setY(Math.toRadians(-currentLocation.getPitch()));
            armorStand.setRightArmPose(armPose);
        }
        if (this.leftLegTransform != null) {
            direction = this.leftLegTransform.get(this.launchLocation, t);
            armorStand.setLeftLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.rightLegTransform != null) {
            direction = this.rightLegTransform.get(this.launchLocation, t);
            armorStand.setRightLegPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.bodyTransform != null) {
            direction = this.bodyTransform.get(this.launchLocation, t);
            armorStand.setBodyPose(new EulerAngle(direction.getX(), direction.getY(), direction.getZ()));
        }
        if (this.headTransform != null) {
            direction = this.headTransform.get(this.launchLocation, t);
            pitchOffset = this.adjustHeadPitch ? Math.toRadians(currentLocation.getPitch()) : 0.0;
            armorStand.setHeadPose(new EulerAngle(direction.getX(), direction.getY() + pitchOffset, direction.getZ()));
        } else if (this.adjustHeadPitch) {
            EulerAngle headPose = armorStand.getHeadPose();
            headPose.setY(Math.toRadians(-currentLocation.getPitch()));
            armorStand.setRightArmPose(headPose);
        }
        return result;
    }
}

