/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnchantWandAction
extends BaseSpellAction {
    private int levels;
    private boolean useXp;
    private ItemStack requireItem = null;
    private String requiredPath = null;
    private String exactPath = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.levels = parameters.getInt("levels", 30);
        this.useXp = parameters.getBoolean("use_xp", false);
        this.requiredPath = parameters.getString("path", null);
        this.exactPath = parameters.getString("path_exact", null);
        String costKey = parameters.getString("requires");
        if (costKey != null && !costKey.isEmpty()) {
            MageController controller = context.getController();
            this.requireItem = controller.createItem(costKey);
            if (this.requireItem == null) {
                context.getLogger().warning("Invalid required item: " + costKey);
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        int levelsUsed;
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.levels <= 0) {
            return SpellResult.FAIL;
        }
        if (wand == null) {
            context.showMessage("no_wand", "You must be holding a wand!");
            return SpellResult.FAIL;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
            if (path == null) {
                context.showMessage(context.getMessage("no_upgrade", "You may not learn with that $wand.").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath) || this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath requiresPath = WandUpgradePath.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_path", "You may not learn with that $wand.").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in EnchantWand action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
        }
        if (this.requireItem != null) {
            MageController controller = context.getController();
            boolean foundItem = false;
            ItemStack[] contents = player.getInventory().getContents();
            for (int i = 0; i < contents.length; ++i) {
                ItemStack item = contents[i];
                if (!controller.itemsAreEqual(item, this.requireItem)) continue;
                player.getInventory().setItem(i, null);
                foundItem = true;
                break;
            }
            if (!foundItem) {
                context.showMessage("insufficient_resources", "You must have a $requires");
                return SpellResult.INSUFFICIENT_RESOURCES;
            }
        }
        int xpLevels = this.levels;
        if (this.useXp) {
            xpLevels = mage.getLevel();
        }
        if ((levelsUsed = wand.enchant(xpLevels, mage)) == 0) {
            return SpellResult.FAIL;
        }
        if (this.useXp) {
            mage.setLevel(Math.max(0, mage.getLevel() - levelsUsed));
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("levels");
        parameters.add("use_xp");
        parameters.add("path");
        parameters.add("path_exact");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("levels")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("use_xp")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("path") || parameterKey.equals("path_exact")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public String transformMessage(String message) {
        MagicAPI api = MagicPlugin.getAPI();
        if (this.requireItem != null) {
            message = message.replace("$requires", api.describeItem(this.requireItem));
        }
        return message;
    }
}

