/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.wand.WandUpgradePath;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AddSpellAction
extends BaseSpellAction {
    private String spellKey;
    private String requiredPath = null;
    private String requiresCompletedPath = null;
    private String exactPath = null;
    private String permissionNode = null;
    protected boolean autoUpgrade = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.permissionNode = parameters.getString("permission", null);
        this.spellKey = parameters.getString("spell");
        this.requiredPath = parameters.getString("path", null);
        this.requiresCompletedPath = parameters.getString("path_end", null);
        this.exactPath = parameters.getString("path_exact", null);
        this.autoUpgrade = parameters.getBoolean("auto_upgrade", true);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        if (this.permissionNode != null && !player.hasPermission(this.permissionNode)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (wand == null || this.spellKey == null || this.spellKey.isEmpty()) {
            context.showMessage("no_wand", "You must be holding a wand!");
            return SpellResult.FAIL;
        }
        if (wand.hasSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        if (this.requiredPath != null || this.exactPath != null) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
            if (path == null) {
                context.showMessage(context.getMessage("no_upgrade", "You may not learn with that $wand.").replace("$wand", wand.getName()));
                return SpellResult.FAIL;
            }
            MageController controller = context.getController();
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath requiresPath = controller.getPath(this.requiredPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_required_path", "You must be at least $path!").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.requiredPath);
                }
                return SpellResult.FAIL;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath requiresPath = controller.getPath(this.exactPath);
                if (requiresPath != null) {
                    context.showMessage(context.getMessage("no_path_exact", "You must be at $path!").replace("$path", requiresPath.getName()));
                } else {
                    context.getLogger().warning("Invalid path specified in AddSpell action: " + this.exactPath);
                }
                return SpellResult.FAIL;
            }
            if (this.requiresCompletedPath != null) {
                com.elmakers.mine.bukkit.api.wand.WandUpgradePath pathUpgrade = path.getUpgrade();
                if (pathUpgrade == null) {
                    context.showMessage(context.getMessage("no_upgrade", "There is nothing more for you here.").replace("$wand", wand.getName()));
                    return SpellResult.FAIL;
                }
                if (path.canEnchant(wand)) {
                    context.showMessage(context.getMessage("no_path_end", "You must be ready to advance to $path!").replace("$path", pathUpgrade.getName()));
                    return SpellResult.FAIL;
                }
            }
        }
        SpellTemplate currentSpell = wand.getBaseSpell(this.spellKey);
        if (!wand.addSpell(this.spellKey)) {
            return SpellResult.NO_TARGET;
        }
        wand.setActiveSpell(this.spellKey);
        Messages messages = context.getController().getMessages();
        SpellTemplate spell = context.getController().getSpellTemplate(this.spellKey);
        if (spell != null) {
            if (currentSpell != null) {
                String levelDescription = spell.getLevelDescription();
                if (levelDescription == null || levelDescription.isEmpty()) {
                    levelDescription = spell.getName();
                }
                context.showMessage(messages.get("wand.spell_upgraded").replace("$name", currentSpell.getName()).replace("$wand", wand.getName()).replace("$level", levelDescription));
                context.showMessage(spell.getUpgradeDescription().replace("$name", currentSpell.getName()));
            } else {
                context.showMessage(messages.get("wand.spell_added").replace("$name", spell.getName()).replace("$wand", wand.getName()));
            }
        }
        if (this.autoUpgrade) {
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath nextPath;
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath path = wand.getPath();
            com.elmakers.mine.bukkit.api.wand.WandUpgradePath wandUpgradePath = nextPath = path != null ? path.getUpgrade() : null;
            if (nextPath != null && path.checkUpgradeRequirements(wand, null) && !path.canEnchant(wand)) {
                path.upgrade(wand, mage);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("spell");
        parameters.add("path");
        parameters.add("path_end");
        parameters.add("path_exact");
        parameters.add("permission");
        parameters.add("auto_upgrade");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("spell")) {
            Collection<SpellTemplate> spellList = MagicPlugin.getAPI().getSpellTemplates();
            for (SpellTemplate spellTemplate : spellList) {
                examples.add(spellTemplate.getKey());
            }
        } else if (parameterKey.equals("path") || parameterKey.equals("path_exact") || parameterKey.equals("path_end")) {
            examples.addAll(WandUpgradePath.getPathKeys());
        } else if (parameterKey.equals("auto_upgrade")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

