/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.CraftWandEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicRecipe;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.Plugin;

public class CraftingController
implements Listener {
    private final MagicController controller;
    private boolean craftingEnabled = false;
    private Map<Material, List<MagicRecipe>> recipes = new HashMap<Material, List<MagicRecipe>>();
    int recipeCount = 0;

    public CraftingController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        this.recipes.clear();
        if (!this.craftingEnabled) {
            return;
        }
        Set recipeKeys = configuration.getKeys(false);
        for (String key : recipeKeys) {
            ConfigurationSection parameters = configuration.getConfigurationSection(key);
            if (!parameters.getBoolean("enabled", true)) continue;
            MagicRecipe recipe = new MagicRecipe(key, this.controller);
            if (!recipe.load(parameters)) {
                this.controller.getLogger().warning("Failed to create crafting recipe: " + key);
                continue;
            }
            Material outputType = recipe.getOutputType();
            List<MagicRecipe> similar = this.recipes.get(outputType);
            if (similar == null) {
                similar = new ArrayList<MagicRecipe>();
                this.recipes.put(outputType, similar);
            }
            similar.add(recipe);
            ++this.recipeCount;
        }
    }

    public boolean hasCraftPermission(Player player, MagicRecipe recipe) {
        if (player == null) {
            return false;
        }
        if (player.hasPermission("Magic.bypass")) {
            return true;
        }
        if (!this.controller.hasPermission(player, "Magic.wand.craft")) {
            return false;
        }
        return this.controller.hasPermission(player, "Magic.craft." + recipe.getKey(), true);
    }

    public void register(Plugin plugin) {
        if (!this.craftingEnabled) {
            return;
        }
        for (List<MagicRecipe> list : this.recipes.values()) {
            for (MagicRecipe recipe : list) {
                recipe.register(plugin);
            }
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        ItemStack[] contents = inventory.getMatrix();
        for (int i = 0; i < 9 && i < contents.length; ++i) {
            ItemStack item = contents[i];
            if (!Wand.isUpgrade(item) && !Wand.isWand(item) && !Wand.isBrush(item) && !Wand.isSpell(item)) continue;
            inventory.setResult(new ItemStack(Material.AIR));
            return;
        }
        if (!this.craftingEnabled) {
            return;
        }
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        ItemStack result = recipe.getResult();
        if (result == null) {
            return;
        }
        Material resultType = result.getType();
        List<MagicRecipe> candidates = this.recipes.get(resultType);
        if (candidates == null || candidates.size() == 0) {
            return;
        }
        for (MagicRecipe candidate : candidates) {
            boolean ingredientsMatch = candidate.isMatch(contents);
            Material substitute = candidate.getSubstitute();
            if (ingredientsMatch) {
                for (HumanEntity human : event.getViewers()) {
                    if (!(human instanceof Player) || this.hasCraftPermission((Player)human, candidate)) continue;
                    inventory.setResult(new ItemStack(Material.AIR));
                    return;
                }
                ItemStack crafted = candidate.craft();
                inventory.setResult(crafted);
                break;
            }
            if (substitute == null) continue;
            inventory.setResult(new ItemStack(substitute, 1));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        InventoryType inventoryType = event.getInventory().getType();
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType == InventoryType.SlotType.CRAFTING && (inventoryType == InventoryType.CRAFTING || inventoryType == InventoryType.WORKBENCH) && (Wand.isWand(cursor = event.getCursor()) || Wand.isBrush(cursor) || Wand.isSpell(cursor) || Wand.isUpgrade(cursor))) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage mage = this.controller.getMage(player);
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        if (Wand.isWand(currentItem) && player != null) {
            CraftWandEvent castEvent = new CraftWandEvent(mage, this.controller.getWand(currentItem));
            Bukkit.getPluginManager().callEvent((Event)castEvent);
        }
    }

    public boolean isEnabled() {
        return this.craftingEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.craftingEnabled = enabled;
    }

    public int getCount() {
        return this.recipeCount;
    }
}

