/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.block.UndoQueue;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.Collection;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BlockController
implements Listener {
    private final MagicController controller;
    private boolean undoOnWorldSave = false;
    private int creativeBreakFrequency = 0;

    public BlockController(MagicController controller) {
        this.controller = controller;
    }

    public void setUndoOnWorldSave(boolean undo) {
        this.undoOnWorldSave = undo;
    }

    public void setCreativeBreakFrequency(int frequency) {
        this.creativeBreakFrequency = frequency;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        BlockData modifiedBlock;
        String lockKey;
        Mage mage;
        com.elmakers.mine.bukkit.api.magic.Mage apiMage;
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (this.creativeBreakFrequency > 0 && player.getGameMode() == GameMode.CREATIVE && (apiMage = this.controller.getMage(event.getPlayer())) instanceof Mage && (mage = (Mage)apiMage).checkLastClick(this.creativeBreakFrequency)) {
            event.setCancelled(true);
            return;
        }
        if (this.controller.areLocksProtected() && this.controller.isContainer(block) && !event.getPlayer().hasPermission("Magic.bypass") && (lockKey = CompatibilityUtils.getLock(block)) != null && !lockKey.isEmpty()) {
            PlayerInventory inventory = player.getInventory();
            com.elmakers.mine.bukkit.api.magic.Mage mage2 = this.controller.getRegisteredMage((Entity)event.getPlayer());
            if (mage2 != null) {
                inventory = mage2.getInventory();
            }
            if (!InventoryUtils.hasItem((Inventory)inventory, lockKey)) {
                String message = this.controller.getMessages().get("general.locked_chest");
                if (mage2 != null) {
                    mage2.sendMessage(message);
                } else {
                    player.sendMessage(message);
                }
                event.setCancelled(true);
                return;
            }
        }
        if ((modifiedBlock = com.elmakers.mine.bukkit.block.UndoList.getBlockData(block.getLocation())) != null) {
            event.setCancelled(true);
            block.setType(Material.AIR);
            com.elmakers.mine.bukkit.block.UndoList.commit(modifiedBlock);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block;
        BlockData modifiedBlock;
        Player player = event.getPlayer();
        ItemStack itemStack = event.getItemInHand();
        if (NMSUtils.isTemporary(itemStack)) {
            event.setCancelled(true);
            player.setItemInHand(null);
            return;
        }
        if (NMSUtils.isUnplaceable(itemStack) || Wand.isWand(itemStack) || Wand.isSpell(itemStack) || Wand.isBrush(itemStack)) {
            event.setCancelled(true);
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (mage.hasStoredInventory() || mage.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
        if (Wand.isWand(itemStack) || Wand.isBrush(itemStack) || Wand.isSpell(itemStack) || Wand.isUpgrade(itemStack)) {
            event.setCancelled(true);
        }
        if (!event.isCancelled() && (modifiedBlock = com.elmakers.mine.bukkit.block.UndoList.getBlockData((block = event.getBlock()).getLocation())) != null) {
            com.elmakers.mine.bukkit.block.UndoList.commit(modifiedBlock);
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Block targetBlock = event.getToBlock();
        Block sourceBlock = event.getBlock();
        UndoList undoList = this.controller.getPendingUndo(sourceBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        } else {
            undoList = this.controller.getPendingUndo(targetBlock.getLocation());
            if (undoList != null) {
                undoList.add(targetBlock);
            }
        }
        if (undoList != null && undoList.isScheduled()) {
            Set<Material> doubles = com.elmakers.mine.bukkit.block.UndoList.attachablesDouble;
            if (doubles != null && doubles.contains(targetBlock.getType())) {
                Block upBlock = targetBlock.getRelative(BlockFace.UP);
                while (doubles.contains(upBlock.getType())) {
                    undoList.add(upBlock);
                    upBlock.setTypeIdAndData(Material.AIR.ordinal(), (byte)0, false);
                    upBlock = upBlock.getRelative(BlockFace.UP);
                }
                Block downBlock = targetBlock.getRelative(BlockFace.DOWN);
                while (doubles.contains(downBlock.getType())) {
                    undoList.add(downBlock);
                    downBlock.setTypeIdAndData(Material.AIR.ordinal(), (byte)0, false);
                    downBlock = downBlock.getRelative(BlockFace.DOWN);
                }
            }
            targetBlock.setTypeIdAndData(Material.AIR.ordinal(), (byte)0, false);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        Block targetBlock = event.getBlock();
        UndoList undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        UndoList undoList;
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL || cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        UndoList entityList = this.controller.getEntityUndo(entity);
        if (entityList != null) {
            entityList.add(event.getBlock());
            return;
        }
        Block ignitingBlock = event.getIgnitingBlock();
        Block targetBlock = event.getBlock();
        if (ignitingBlock != null && (undoList = this.controller.getPendingUndo(ignitingBlock.getLocation())) != null) {
            undoList.add(event.getBlock());
            return;
        }
        undoList = this.controller.getPendingUndo(targetBlock.getLocation());
        if (undoList != null) {
            undoList.add(targetBlock);
        }
    }

    @EventHandler
    public void onBlockDamage(BlockDamageEvent event) {
        com.elmakers.mine.bukkit.api.wand.Wand activeWand;
        Player damager = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage damagerMage = this.controller.getRegisteredMage((Entity)damager);
        if (damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
            activeWand.playEffects("hit_block");
        }
    }

    @EventHandler
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof FallingBlock) {
            UndoList blockList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(entity);
            if (blockList != null) {
                CastContext context = blockList.getContext();
                if (context != null && !context.hasBuildPermission(entity.getLocation().getBlock())) {
                    event.setCancelled(true);
                } else {
                    blockList.convert(entity, event.getBlock());
                }
            } else {
                this.controller.registerFallingBlock(entity, event.getBlock());
            }
        }
    }

    @EventHandler
    public void onWorldSaveEvent(WorldSaveEvent event) {
        World world = event.getWorld();
        Collection players = this.controller.getPlugin().getServer().getOnlinePlayers();
        for (Player player : players) {
            int undone;
            UndoQueue queue;
            if (!world.equals(player.getWorld()) || !this.controller.isMage((Entity)player)) continue;
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
            this.controller.saveMage(mage, true);
            if (!this.undoOnWorldSave || (queue = mage.getUndoQueue()) == null || (undone = queue.undoScheduled()) <= 0) continue;
            this.controller.info("Undid " + undone + " spells for " + player.getName() + "prior to save of world " + world.getName());
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        this.controller.triggerBlockToggle(e.getChunk());
    }
}

