/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class LineAction
extends CompoundAction {
    private static final int DEFAULT_SIZE = 16;
    private boolean incrementData;
    private int size;
    private int startDistance;
    private boolean reverse;
    private boolean startAtTarget;
    private boolean requireBlock;
    private boolean reorient;
    private int destination;
    private int current;
    private Vector direction;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.incrementData = parameters.getBoolean("increment_data", false);
        this.size = parameters.getInt("size", 16);
        this.startDistance = parameters.getInt("start", 2);
        this.startAtTarget = parameters.getBoolean("start_at_target", false);
        this.reverse = parameters.getBoolean("reverse", false);
        this.requireBlock = parameters.getBoolean("require_block", false);
        this.reorient = parameters.getBoolean("reorient", false);
        Mage mage = context.getMage();
        this.size = (int)(mage.getConstructionMultiplier() * (float)this.size);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.current = 0;
        this.destination = 0;
        Location startLocation = context.getEyeLocation();
        Location targetLocation = context.getTargetLocation();
        if (startLocation == null) {
            return;
        }
        Vector playerLoc = startLocation.toVector();
        Vector targetLoc = null;
        if (targetLocation == null) {
            targetLocation = startLocation.clone();
            this.direction = startLocation.getDirection();
        } else {
            targetLoc = new Vector(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
            this.direction = targetLoc.clone();
            this.direction.subtract(playerLoc);
            this.direction.normalize();
        }
        this.destination = this.size;
        if (!this.startAtTarget || this.reverse) {
            if (this.startDistance > 0) {
                playerLoc.add(this.direction.clone().multiply(this.startDistance));
            }
            if (targetLoc != null) {
                this.destination = (int)playerLoc.distance(targetLoc);
            }
            if (this.destination <= 0) {
                return;
            }
            this.destination = Math.min(this.destination, this.size);
            if (this.reverse) {
                this.direction = this.direction.multiply(-1);
            } else {
                targetLocation.setX(playerLoc.getX());
                targetLocation.setY(playerLoc.getY());
                targetLocation.setZ(playerLoc.getZ());
            }
        }
        this.actionContext.setTargetLocation(targetLocation);
    }

    @Override
    public SpellResult step(CastContext context) {
        Block lowerBlock;
        MaterialBrush brush = context.getBrush();
        Block currentTarget = this.actionContext.getTargetBlock();
        if (this.incrementData) {
            short data = this.current > 15 ? (short)15 : (short)this.current;
            brush.setData(data);
        }
        if (this.requireBlock && ((lowerBlock = currentTarget.getRelative(BlockFace.DOWN)).getType() == Material.AIR || lowerBlock.getType() == brush.getMaterial())) {
            this.next(context);
            this.skippedActions(context);
            return SpellResult.NO_TARGET;
        }
        context.playEffects("iterate");
        return this.startActions();
    }

    @Override
    public boolean next(CastContext context) {
        ++this.current;
        Location target = this.actionContext.getTargetLocation();
        if (this.reorient) {
            this.direction = context.getDirection();
        }
        target.add(this.direction);
        this.actionContext.setTargetLocation(target);
        return this.current <= this.destination;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("size");
        parameters.add("increment_data");
        parameters.add("require_block");
        parameters.add("reverse");
        parameters.add("start");
        parameters.add("reorient");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("increment_data") || parameterKey.equals("reverse") || parameterKey.equals("require_block") || parameterKey.equals("reorient")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("size") || parameterKey.equals("start")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public int getActionCount() {
        return this.destination * super.getActionCount();
    }
}

