/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseShopAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ItemShopAction
extends BaseShopAction {
    private List<ShopItemConfiguration> items = new ArrayList<ShopItemConfiguration>();

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        block5: {
            super.initialize(spell, parameters);
            this.items.clear();
            if (!parameters.contains("items")) break block5;
            if (parameters.isConfigurationSection("items")) {
                ConfigurationSection itemSection = parameters.getConfigurationSection("items");
                Set itemKeys = itemSection.getKeys(false);
                for (String itemKey : itemKeys) {
                    this.items.add(new ShopItemConfiguration(itemKey, itemSection.getDouble(itemKey)));
                }
            } else {
                Collection<ConfigurationSection> itemList = ConfigurationUtils.getNodeList(parameters, "items");
                for (ConfigurationSection itemConfig : itemList) {
                    if (itemConfig != null) {
                        this.items.add(new ShopItemConfiguration(itemConfig.getString("item"), itemConfig.getDouble("cost")));
                        continue;
                    }
                    this.items.add(null);
                }
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult contextResult = this.checkContext(context);
        if (!contextResult.isSuccess()) {
            return contextResult;
        }
        ArrayList<BaseShopAction.ShopItem> shopItems = new ArrayList<BaseShopAction.ShopItem>();
        MageController controller = context.getController();
        for (ShopItemConfiguration itemConfig : this.items) {
            if (itemConfig == null) {
                shopItems.add(null);
                continue;
            }
            String itemKey = itemConfig.itemKey;
            if (itemKey == null || itemKey.isEmpty() || itemKey.equalsIgnoreCase("none")) {
                shopItems.add(null);
                continue;
            }
            double worth = itemConfig.cost;
            if (this.costScale > 0.0) {
                worth /= this.costScale;
            }
            String[] pieces = StringUtils.split((String)itemKey, (char)'@');
            int amount = 1;
            if (pieces.length > 1) {
                itemKey = pieces[0];
                try {
                    amount = Integer.parseInt(pieces[1]);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid item amount in shop: " + pieces[1] + " for item " + itemKey + " shop " + context.getSpell().getKey());
                }
            }
            ItemStack item = controller.createItem(itemKey);
            item.setAmount(amount);
            if (item == null) continue;
            shopItems.add(new BaseShopAction.ShopItem(this, item, worth));
        }
        return this.showItems(context, shopItems);
    }

    private class ShopItemConfiguration {
        public String itemKey;
        public double cost;

        ShopItemConfiguration(String key, double cost) {
            this.cost = cost;
            this.itemKey = key;
        }
    }
}

