/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class ChangeContextAction
extends CompoundAction {
    private Vector sourceOffset;
    private Vector targetOffset;
    private boolean targetSelf;
    private boolean targetEntityLocation;
    private boolean sourceAtTarget;
    private Vector randomSourceOffset;
    private Vector randomTargetOffset;
    private Double targetDirectionSpeed;
    private Double sourceDirectionSpeed;
    private Vector sourceDirection;
    private Vector targetDirection;
    private Vector sourceDirectionOffset;
    private Vector targetDirectionOffset;
    private boolean persistTarget;
    private boolean attachBlock;
    private int snapTargetToSize;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetEntityLocation = parameters.getBoolean("target_entity", false);
        this.targetSelf = parameters.getBoolean("target_caster", false);
        this.sourceAtTarget = parameters.getBoolean("source_at_target", false);
        this.targetOffset = ConfigurationUtils.getVector(parameters, "target_offset");
        this.sourceOffset = ConfigurationUtils.getVector(parameters, "source_offset");
        this.randomTargetOffset = ConfigurationUtils.getVector(parameters, "random_target_offset");
        this.randomSourceOffset = ConfigurationUtils.getVector(parameters, "random_source_offset");
        this.sourceDirection = ConfigurationUtils.getVector(parameters, "source_direction");
        this.targetDirection = ConfigurationUtils.getVector(parameters, "target_direction");
        this.sourceDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.targetDirectionOffset = ConfigurationUtils.getVector(parameters, "source_direction_offset");
        this.persistTarget = parameters.getBoolean("persist_target", false);
        this.attachBlock = parameters.getBoolean("target_attachment", false);
        this.snapTargetToSize = parameters.getInt("target_snap", 0);
        this.targetDirectionSpeed = parameters.contains("target_direction_speed") ? Double.valueOf(parameters.getDouble("target_direction_speed")) : null;
        this.sourceDirectionSpeed = parameters.contains("source_direction_speed") ? Double.valueOf(parameters.getDouble("source_direction_speed")) : null;
    }

    @Override
    public SpellResult step(CastContext context) {
        Block previousBlock;
        Entity sourceEntity = context.getEntity();
        Location sourceLocation = context.getEyeLocation().clone();
        Entity targetEntity = context.getTargetEntity();
        Location targetLocation = context.getTargetLocation();
        if (targetLocation != null) {
            targetLocation = targetLocation.clone();
        }
        Vector direction = context.getDirection().normalize();
        if (sourceLocation == null) {
            return SpellResult.LOCATION_REQUIRED;
        }
        if (this.targetSelf) {
            targetEntity = sourceEntity;
            targetLocation = sourceLocation;
        } else if (this.targetEntityLocation && targetEntity != null) {
            targetLocation = targetEntity.getLocation();
        }
        if (this.attachBlock && (previousBlock = context.getPreviousBlock()) != null) {
            Location current = targetLocation;
            targetLocation = previousBlock.getLocation();
            context.getBrush().setTarget(current, targetLocation);
        }
        if (this.sourceOffset != null) {
            sourceLocation = sourceLocation.add(this.sourceOffset);
        }
        if (this.snapTargetToSize > 0 && targetLocation != null) {
            int x = targetLocation.getBlockX();
            int z = targetLocation.getBlockZ();
            int xresult = x / this.snapTargetToSize;
            int zresult = z / this.snapTargetToSize;
            boolean xneedfix = x % this.snapTargetToSize != 0;
            boolean zneedfix = z % this.snapTargetToSize != 0;
            targetLocation.setX((double)(this.snapTargetToSize * (xresult - (x < 0 && xneedfix ? 1 : 0))));
            targetLocation.setZ((double)(this.snapTargetToSize * (zresult - (z < 0 && zneedfix ? 1 : 0))));
        }
        if (this.targetOffset != null && targetLocation != null) {
            targetLocation = targetLocation.add(this.targetOffset);
        }
        if (this.randomSourceOffset != null) {
            sourceLocation = RandomUtils.randomizeLocation(sourceLocation, this.randomSourceOffset);
        }
        if (this.randomTargetOffset != null && targetLocation != null) {
            targetLocation = RandomUtils.randomizeLocation(targetLocation, this.randomTargetOffset);
        }
        if (this.targetDirection != null && targetLocation != null) {
            targetLocation.setDirection(this.targetDirection);
        }
        if (this.sourceDirection != null) {
            sourceLocation.setDirection(this.sourceDirection);
            direction = this.sourceDirection.clone();
        }
        if (this.targetDirectionOffset != null && targetLocation != null) {
            targetLocation.setDirection(targetLocation.getDirection().add(this.targetDirectionOffset));
        }
        if (this.sourceDirectionOffset != null) {
            sourceLocation.setDirection(direction.add(this.sourceDirectionOffset));
        }
        if (this.sourceDirectionSpeed != null) {
            sourceLocation = sourceLocation.add(direction.clone().multiply(this.sourceDirectionSpeed.doubleValue()));
        }
        if (this.targetDirectionSpeed != null && targetLocation != null) {
            targetLocation = targetLocation.add(direction.clone().multiply(this.targetDirectionSpeed.doubleValue()));
        }
        if (this.sourceAtTarget && targetLocation != null) {
            sourceLocation.setX(targetLocation.getX());
            sourceLocation.setY(targetLocation.getY());
            sourceLocation.setZ(targetLocation.getZ());
            sourceLocation.setWorld(targetLocation.getWorld());
        }
        if (this.persistTarget) {
            context.setTargetLocation(targetLocation);
        }
        if (sourceLocation != null) {
            context.getMage().sendDebugMessage(ChatColor.GREEN + " Set new source location to " + ChatColor.GRAY + sourceLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + sourceLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        }
        if (targetLocation != null) {
            context.getMage().sendDebugMessage(ChatColor.DARK_GREEN + " Set new target location to " + ChatColor.GRAY + targetLocation.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + targetLocation.getBlockZ() + ChatColor.DARK_GRAY, 6);
        }
        this.createActionContext(context, sourceEntity, sourceLocation, targetEntity, targetLocation);
        return this.startActions();
    }
}

