/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class AbsorbAction
extends BaseSpellAction {
    @Override
    public SpellResult perform(CastContext context) {
        Block target = context.getTargetBlock();
        Mage mage = context.getMage();
        Wand wand = mage.getActiveWand();
        if (wand == null) {
            return SpellResult.FAIL;
        }
        MageController controller = context.getController();
        Material material = target.getType();
        byte data = target.getData();
        Set<Material> buildingMaterials = controller.getBuildingMaterials();
        Set<Material> restrictedMaterials = mage.getRestrictedMaterials();
        if (material == null || material == Material.AIR) {
            return SpellResult.NO_TARGET;
        }
        if (!(mage.getCommandSender().hasPermission("Magic.bypass_restricted") || buildingMaterials.contains(material) && !restrictedMaterials.contains(material))) {
            return SpellResult.NO_TARGET;
        }
        MaterialAndData mat = new MaterialAndData(material, data);
        wand.addBrush(mat.getKey());
        wand.setActiveBrush(mat.getKey());
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

