/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class TeleportTask
implements Runnable {
    protected static final int TELEPORT_RETRY_COUNT = 8;
    protected static final int TELEPORT_RETRY_INTERVAL = 10;
    private final CastContext context;
    private final Entity entity;
    private final Location location;
    private final int verticalSearchDistance;
    private final MageController controller;
    private final boolean safe;
    private int retryCount;

    public TeleportTask(MageController controller, Entity entity, Location location, int verticalSearchDistance, boolean safe, CastContext context) {
        this.context = context;
        this.entity = entity;
        this.location = location;
        this.verticalSearchDistance = verticalSearchDistance;
        this.controller = controller;
        this.retryCount = 8;
        this.safe = safe;
    }

    @Override
    public void run() {
        Chunk chunk = this.location.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount > 0) {
                --this.retryCount;
                Plugin plugin = this.controller.getPlugin();
                Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)this, 10L);
            }
            return;
        }
        Location targetLocation = this.location;
        if (this.context != null) {
            this.context.registerMoved(this.entity);
            targetLocation = this.context.findPlaceToStand(this.location, this.verticalSearchDistance);
        }
        if (targetLocation == null && !this.safe) {
            targetLocation = this.location;
        }
        if (targetLocation != null) {
            boolean isWorldChange = !targetLocation.getWorld().equals(this.entity.getWorld());
            this.entity.teleport(targetLocation);
            if (isWorldChange) {
                this.entity.teleport(targetLocation);
            }
            if (this.context != null) {
                this.context.setTargetedLocation(targetLocation);
                this.context.sendMessageKey("teleport");
                this.context.playEffects("teleport");
            }
        } else if (this.context != null) {
            this.context.sendMessageKey("teleport_failed");
            this.context.playEffects("teleport_failed");
        }
    }
}

