/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class Targeting {
    private TargetingResult result = TargetingResult.NONE;
    private Location source = null;
    private Target target = null;
    private List<Target> targets = null;
    private TargetType targetType = TargetType.NONE;
    private BlockIterator blockIterator = null;
    private Block currentBlock = null;
    private Block previousBlock = null;
    private Block previousPreviousBlock = null;
    private Vector targetLocationOffset;
    private Vector targetDirectionOverride;
    private String targetLocationWorldName;
    protected float distanceWeight = 1.0f;
    protected float fovWeight = 4.0f;
    protected int npcWeight = -1;
    protected int mageWeight = 5;
    protected int playerWeight = 4;
    protected int livingEntityWeight = 3;
    private boolean ignoreBlocks = false;
    private double hitboxPadding = 0.0;
    private double rangeQueryPadding = 1.0;
    private boolean useHitbox = true;
    private double fov = 0.3;
    private double closeRange = 0.0;
    private double closeFOV = 0.0;
    private double yOffset = 0.0;
    private boolean targetSpaceRequired = false;
    private int targetMinOffset = 0;

    public void reset() {
        this.result = TargetingResult.NONE;
        this.source = null;
        this.target = null;
        this.targets = null;
        this.blockIterator = null;
        this.currentBlock = null;
        this.previousBlock = null;
        this.previousPreviousBlock = null;
        this.targetSpaceRequired = false;
        this.targetMinOffset = 0;
        this.yOffset = 0.0;
    }

    protected boolean initializeBlockIterator(Location location, double range) {
        if (this.blockIterator != null) {
            return true;
        }
        if (location.getBlockY() < 0) {
            location = location.clone();
            location.setY(0.0);
        }
        int maxHeight = CompatibilityUtils.getMaxHeight(location.getWorld());
        if (location.getBlockY() > maxHeight) {
            location = location.clone();
            location.setY((double)maxHeight);
        }
        try {
            this.blockIterator = new BlockIterator(location, this.yOffset, (int)Math.ceil(range));
        }
        catch (Exception ex) {
            if (Target.DEBUG_TARGETING) {
                Bukkit.getLogger().warning("Exception creating BlockIterator");
                ex.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public Target getOrCreateTarget(Location defaultLocation) {
        if (this.target == null) {
            this.target = new Target(defaultLocation);
        }
        return this.target;
    }

    public Target getTarget() {
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public void setTargetSpaceRequired(boolean required) {
        this.targetSpaceRequired = required;
    }

    public void setTargetMinOffset(int offset) {
        this.targetMinOffset = offset;
    }

    public void targetBlock(Location source, Block block) {
        this.target = new Target(source, block, this.useHitbox, this.hitboxPadding);
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }

    protected Block getNextBlock() {
        this.previousPreviousBlock = this.previousBlock;
        this.previousBlock = this.currentBlock;
        this.currentBlock = this.blockIterator == null || !this.blockIterator.hasNext() ? null : this.blockIterator.next();
        return this.currentBlock;
    }

    public Block getCurBlock() {
        return this.currentBlock;
    }

    public Block getPreviousBlock() {
        return this.previousBlock;
    }

    public void setFOV(double fov) {
        this.fov = fov;
    }

    public void setCloseRange(double closeRange) {
        this.closeRange = closeRange;
    }

    public void setCloseFOV(double closeFOV) {
        this.closeFOV = closeFOV;
    }

    public void setUseHitbox(boolean useHitbox) {
        this.useHitbox = useHitbox;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetType type) {
        this.targetType = type;
    }

    public void start(Location source) {
        this.reset();
        this.source = source.clone();
    }

    public Target target(CastContext context, double range) {
        Location location;
        this.target = this.findTarget(context, range);
        if (this.targetLocationOffset != null) {
            this.target.add(this.targetLocationOffset);
        }
        if (this.targetDirectionOverride != null) {
            this.target.setDirection(this.targetDirectionOverride);
        }
        if (this.targetLocationWorldName != null && this.targetLocationWorldName.length() > 0 && (location = this.target.getLocation()) != null) {
            World targetWorld = location.getWorld();
            this.target.setWorld(ConfigurationUtils.overrideWorld(this.targetLocationWorldName, targetWorld, context.getController().canCreateWorlds()));
        }
        return this.target;
    }

    public Target findTarget(CastContext context, double range) {
        Target targetBlock;
        if (this.targetType == TargetType.NONE) {
            return new Target(this.source);
        }
        boolean isBlock = this.targetType == TargetType.BLOCK || this.targetType == TargetType.SELECT;
        Mage mage = context.getMage();
        Entity mageEntity = mage.getEntity();
        if (this.targetType == TargetType.SELF && mageEntity != null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity);
        }
        CommandSender sender = mage.getCommandSender();
        if (this.targetType == TargetType.SELF && mageEntity == null && sender != null && sender instanceof BlockCommandSender) {
            BlockCommandSender commandBlock = (BlockCommandSender)mage.getCommandSender();
            return new Target(commandBlock.getBlock().getLocation(), commandBlock.getBlock());
        }
        if (this.targetType == TargetType.SELF && this.source != null) {
            return new Target(this.source, this.source.getBlock());
        }
        if (this.targetType == TargetType.SELF) {
            return new Target(this.source);
        }
        Block block = null;
        if (!this.ignoreBlocks) {
            this.findTargetBlock(context, range);
            block = this.currentBlock;
        }
        if (isBlock) {
            return new Target(this.source, block, this.useHitbox, this.hitboxPadding);
        }
        Target target = targetBlock = block == null ? null : new Target(this.source, block, this.useHitbox, this.hitboxPadding);
        if (targetBlock != null && this.source != null && this.source.getWorld().equals(block.getWorld())) {
            range = Math.min(range, this.source.distance(targetBlock.getLocation()));
        }
        Target entityTarget = null;
        List<Target> scored = this.getAllTargetEntities(context, range);
        if (scored.size() > 0) {
            entityTarget = scored.get(0);
        }
        if (entityTarget != null && !context.canCast(entityTarget.getLocation())) {
            entityTarget = null;
        }
        if (targetBlock != null && !context.canCast(targetBlock.getLocation())) {
            targetBlock = null;
        }
        if (this.targetType == TargetType.OTHER_ENTITY && entityTarget == null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source);
        }
        if (this.targetType == TargetType.ANY_ENTITY && entityTarget == null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity);
        }
        if (entityTarget == null && this.targetType == TargetType.ANY && mageEntity != null) {
            this.result = TargetingResult.ENTITY;
            return new Target(this.source, mageEntity, targetBlock == null ? null : targetBlock.getBlock());
        }
        if (targetBlock != null && entityTarget != null) {
            if (targetBlock.getDistanceSquared() < entityTarget.getDistanceSquared()) {
                entityTarget = null;
            } else {
                targetBlock = null;
            }
        }
        if (entityTarget != null) {
            this.result = TargetingResult.ENTITY;
            return entityTarget;
        }
        if (targetBlock != null) {
            return targetBlock;
        }
        return new Target(this.source);
    }

    protected void findTargetBlock(CastContext context, double range) {
        if (this.source == null) {
            this.source = context.getEyeLocation();
        }
        if (this.source == null) {
            return;
        }
        Location targetLocation = this.source.clone().add(this.source.getDirection().multiply(range));
        if (targetLocation.getBlockX() == this.source.getBlockX() && targetLocation.getBlockY() == this.source.getBlockY() && targetLocation.getBlockZ() == this.source.getBlockZ()) {
            this.currentBlock = this.source.getBlock();
            this.result = context.isTargetable(this.currentBlock) ? TargetingResult.BLOCK : TargetingResult.MISS;
            return;
        }
        if (!this.initializeBlockIterator(this.source, range)) {
            return;
        }
        Block block = this.getNextBlock();
        this.result = TargetingResult.BLOCK;
        while (block != null) {
            if (this.targetMinOffset <= 0) {
                if (this.targetSpaceRequired ? !context.allowPassThrough(block.getType()) || context.isOkToStandIn(block.getType()) && context.isOkToStandIn(block.getRelative(BlockFace.UP).getType()) : context.isTargetable(block)) {
                    break;
                }
            } else {
                --this.targetMinOffset;
            }
            block = this.getNextBlock();
        }
        if (block == null) {
            this.result = TargetingResult.MISS;
            this.currentBlock = this.previousBlock;
            this.previousBlock = this.previousPreviousBlock;
        }
    }

    public List<Target> getAllTargetEntities(CastContext context, double range) {
        Entity sourceEntity = context.getEntity();
        Mage mage = context.getMage();
        if (this.targets != null) {
            return this.targets;
        }
        this.targets = new ArrayList<Target>();
        double rangeSquaredPadded = (range + 1.0) * (range + 1.0);
        List<Entity> entities = null;
        range = Math.min(range + this.hitboxPadding + this.rangeQueryPadding, 72.0);
        if (this.source == null && sourceEntity != null) {
            entities = sourceEntity.getNearbyEntities(range, range, range);
            this.source = sourceEntity instanceof LivingEntity ? ((LivingEntity)sourceEntity).getEyeLocation() : sourceEntity.getLocation();
        } else if (this.source != null) {
            entities = CompatibilityUtils.getNearbyEntities(this.source, range, range, range);
        }
        if (mage != null && mage.getDebugLevel() > 8) {
            mage.sendDebugMessage(ChatColor.GREEN + "Targeting from " + ChatColor.GRAY + this.source.getBlockX() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockY() + ChatColor.DARK_GRAY + "," + ChatColor.GRAY + this.source.getBlockZ() + ChatColor.DARK_GREEN + " with range of " + ChatColor.GREEN + range);
        }
        if (entities == null) {
            return this.targets;
        }
        for (Entity entity : entities) {
            Location entityLocation;
            if (sourceEntity != null && entity.equals(sourceEntity) && !context.getTargetsCaster() || !(entityLocation = entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation()).getWorld().equals(this.source.getWorld()) || entityLocation.distanceSquared(this.source) > rangeSquaredPadded || !context.canTarget(entity)) continue;
            Target newScore = null;
            newScore = this.useHitbox ? new Target(this.source, entity, (int)Math.ceil(range), this.useHitbox, this.hitboxPadding) : new Target(this.source, entity, (int)Math.ceil(range), this.fov, this.closeRange, this.closeFOV, this.distanceWeight, this.fovWeight, this.mageWeight, this.npcWeight, this.playerWeight, this.livingEntityWeight);
            if (newScore.getScore() <= 0) continue;
            if (mage != null && mage.getDebugLevel() > 5) {
                mage.sendDebugMessage(ChatColor.DARK_GREEN + "Target " + ChatColor.GREEN + entity.getType() + ChatColor.DARK_GREEN + ": " + ChatColor.YELLOW + newScore.getScore());
            }
            this.targets.add(newScore);
        }
        Collections.sort(this.targets);
        return this.targets;
    }

    public void parseTargetType(String targetTypeName) {
        this.targetType = TargetType.NONE;
        if (targetTypeName != null) {
            try {
                this.targetType = TargetType.valueOf(targetTypeName.toUpperCase());
            }
            catch (Exception ex) {
                this.targetType = TargetType.NONE;
            }
        }
    }

    public void processParameters(ConfigurationSection parameters) {
        this.parseTargetType(parameters.getString("target"));
        this.useHitbox = parameters.getBoolean("hitbox", !parameters.contains("fov"));
        this.hitboxPadding = parameters.getDouble("hitbox_size", 0.0);
        this.rangeQueryPadding = parameters.getDouble("range_padding", 1.0);
        this.fov = parameters.getDouble("fov", 0.3);
        this.closeRange = parameters.getDouble("close_range", 1.0);
        this.closeFOV = parameters.getDouble("close_fov", 0.5);
        this.distanceWeight = (float)parameters.getDouble("distance_weight", 1.0);
        this.fovWeight = (float)parameters.getDouble("fov_weight", 4.0);
        this.npcWeight = parameters.getInt("npc_weight", -1);
        this.playerWeight = parameters.getInt("player_weight", 4);
        this.livingEntityWeight = parameters.getInt("entity_weight", 3);
        this.targetMinOffset = parameters.getInt("target_min_offset", 0);
        this.targetMinOffset = parameters.getInt("tmo", this.targetMinOffset);
        this.ignoreBlocks = parameters.getBoolean("ignore_blocks", false);
        this.targetLocationOffset = null;
        this.targetDirectionOverride = null;
        Double otxValue = ConfigurationUtils.getDouble(parameters, "otx", null);
        Double otyValue = ConfigurationUtils.getDouble(parameters, "oty", null);
        Double otzValue = ConfigurationUtils.getDouble(parameters, "otz", null);
        if (otxValue != null || otzValue != null || otyValue != null) {
            this.targetLocationOffset = new Vector(otxValue == null ? 0.0 : otxValue, otyValue == null ? 0.0 : otyValue, otzValue == null ? 0.0 : otzValue);
        }
        this.targetLocationWorldName = parameters.getString("otworld");
        Double tdxValue = ConfigurationUtils.getDouble(parameters, "otdx", null);
        Double tdyValue = ConfigurationUtils.getDouble(parameters, "otdy", null);
        Double tdzValue = ConfigurationUtils.getDouble(parameters, "otdz", null);
        if (tdxValue != null || tdzValue != null || tdyValue != null) {
            this.targetDirectionOverride = new Vector(tdxValue == null ? 0.0 : tdxValue, tdyValue == null ? 0.0 : tdyValue, tdzValue == null ? 0.0 : tdzValue);
        }
    }

    public TargetingResult getResult() {
        return this.result;
    }

    public void getTargetEntities(CastContext context, double range, int targetCount, Collection<WeakReference<Entity>> entities) {
        List<Target> candidates = this.getAllTargetEntities(context, range);
        if (targetCount < 0) {
            targetCount = entities.size();
        }
        for (int i = 0; i < targetCount && i < candidates.size(); ++i) {
            Target target = candidates.get(i);
            entities.add(new WeakReference<Entity>(target.getEntity()));
        }
    }

    public int breakBlock(CastContext context, Block block, double amount) {
        if (amount <= 0.0) {
            return 0;
        }
        Double breakableAmount = context.getBreakable(block);
        if (breakableAmount == null) {
            return 0;
        }
        double breakable = (int)(amount > 1.0 ? amount : (double)(context.getRandom().nextDouble() < amount ? 1 : 0));
        if (breakable <= 0.0) {
            return 0;
        }
        breakable = (int)Math.ceil(breakableAmount + breakable - 1.0);
        Location blockLocation = block.getLocation();
        Location effectLocation = blockLocation.add(0.5, 0.5, 0.5);
        context.playEffects("break", 1.0f, context.getLocation(), null, effectLocation, null);
        UndoList undoList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(blockLocation);
        if (undoList != null) {
            undoList.add(block);
        }
        context.clearBreakable(block);
        context.clearReflective(block);
        block.setType(Material.AIR);
        int broken = 1;
        if (breakable > (double)broken) {
            broken += this.breakBlock(context, block.getRelative(BlockFace.UP), breakable - (double)broken);
            broken += this.breakBlock(context, block.getRelative(BlockFace.DOWN), breakable - (double)broken);
            broken += this.breakBlock(context, block.getRelative(BlockFace.EAST), breakable - (double)broken);
            broken += this.breakBlock(context, block.getRelative(BlockFace.WEST), breakable - (double)broken);
            broken += this.breakBlock(context, block.getRelative(BlockFace.NORTH), breakable - (double)broken);
            broken += this.breakBlock(context, block.getRelative(BlockFace.SOUTH), breakable - (double)broken);
        }
        return broken;
    }

    public static enum TargetingResult {
        NONE,
        BLOCK,
        ENTITY,
        MISS;

    }
}

