/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PlayerController
implements Listener {
    private final MagicController controller;
    private int clickCooldown = 150;
    private boolean enableCreativeModeEjecting = true;

    public PlayerController(MagicController controller) {
        this.controller = controller;
    }

    public void setClickCooldown(int cooldown) {
        this.clickCooldown = cooldown;
    }

    public void setCreativeModeEjecting(boolean eject) {
        this.enableCreativeModeEjecting = eject;
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        boolean isQuickCast;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        if (Wand.isSelfDestructWand(next)) {
            mage.sendMessageKey("wand.self_destruct");
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        if (NMSUtils.isTemporary(next)) {
            inventory.setItem(event.getNewSlot(), null);
            mage.checkWand();
            return;
        }
        Wand activeWand = mage.getActiveWand();
        boolean isSkill = Wand.isSkill(next);
        boolean bl = isQuickCast = activeWand != null && activeWand.isQuickCast() && activeWand.isInventoryOpen();
        if (isSkill || isQuickCast) {
            MageSpell spell = mage.getSpell(Wand.getSpell(next));
            if (spell != null) {
                if (activeWand != null) {
                    activeWand.cast(spell);
                } else {
                    spell.cast();
                }
            }
            event.setCancelled(true);
            return;
        }
        if (activeWand != null && activeWand.isInventoryOpen()) {
            if (!Wand.isWand(next)) {
                this.controller.onPlayerActivateIcon(mage, activeWand, next);
                int previousSlot = event.getPreviousSlot();
                ItemStack previous = inventory.getItem(previousSlot);
                String previousId = Wand.getWandId(previous);
                if (previousId != null && previousId.equals(activeWand.getId())) {
                    player.getInventory().setItem(previousSlot, activeWand.getItem());
                }
            }
            event.setCancelled(true);
        } else {
            mage.checkWand(next);
        }
        activeWand = mage.getActiveWand();
        if (activeWand == null && next != null && next.getType() == Material.MAP) {
            mage.setLastHeldMapId(next.getDurability());
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        boolean droppedWand;
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        final Mage mage = (Mage)apiMage;
        if (mage.getActiveGUI() != null) {
            event.setCancelled(true);
            return;
        }
        final Wand activeWand = mage.getActiveWand();
        ItemStack droppedItem = event.getItemDrop().getItemStack();
        boolean cancelEvent = false;
        String droppedId = Wand.getWandId(droppedItem);
        boolean bl = droppedWand = droppedId != null && activeWand != null && activeWand.getId().equals(droppedId);
        if (droppedWand && activeWand.isUndroppable()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    if (activeWand.isDropToggle()) {
                        PlayerController.this.controller.onToggleInventory(mage, activeWand);
                    } else if (activeWand.getHotbarCount() > 1) {
                        activeWand.cycleHotbar(1);
                    } else if (activeWand.isInventoryOpen()) {
                        activeWand.closeInventory();
                    }
                }
            });
            cancelEvent = true;
        } else if (activeWand != null) {
            if (droppedWand) {
                String activeId;
                activeWand.deactivate();
                if (Wand.hasActiveWand(player) && (activeId = Wand.getWandId(player.getItemInHand())) != null && activeWand.getId().equals(activeId)) {
                    player.setItemInHand(new ItemStack(Material.AIR, 1));
                }
            } else if (activeWand.isInventoryOpen()) {
                if (!this.controller.isSpellDroppingEnabled()) {
                    cancelEvent = true;
                } else {
                    this.controller.removeItemFromWand(activeWand, droppedItem);
                }
            }
        }
        if (cancelEvent) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)event.getPlayer());
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.restoreRespawnInventories();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        boolean isPlaceable;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage == null || !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.checkWand();
        Entity clickedEntity = event.getRightClicked();
        boolean bl = isPlaceable = clickedEntity instanceof ItemFrame || clickedEntity instanceof ArmorStand;
        if (wand != null && isPlaceable) {
            if (wand.isUndroppable()) {
                event.setCancelled(true);
                return;
            }
            wand.deactivate();
        }
        if (this.controller.isNPC(event.getRightClicked())) {
            if (wand != null) {
                wand.closeInventory();
            }
            mage.checkLastClick(0L);
        } else {
            ItemStack itemInHand = player.getItemInHand();
            if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        boolean isSwing;
        ItemStack item;
        if (!this.controller.isLoaded()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getItemInHand();
        if (Wand.isSpell(itemInHand) || Wand.isBrush(itemInHand) || Wand.isUpgrade(itemInHand)) {
            event.setCancelled(true);
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.checkWand();
        if (wand != null && wand.isIndestructible() && (item = wand.getItem()).getType().getMaxDurability() > 0) {
            wand.getItem().setDurability((short)0);
        }
        Action action = event.getAction();
        if (itemInHand != null && (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && this.controller.isWearable(itemInHand)) {
            if (wand != null) {
                wand.deactivate();
            }
            this.controller.onArmorUpdated(mage);
            return;
        }
        if (wand == null) {
            return;
        }
        Messages messages = this.controller.getMessages();
        if (!this.controller.hasWandPermission(player)) {
            if (this.controller.hasPermission(player, "Magic.wand.destruct", false)) {
                wand.deactivate();
                PlayerInventory inventory = player.getInventory();
                ItemStack[] items = inventory.getContents();
                for (int i = 0; i < items.length; ++i) {
                    ItemStack item2 = items[i];
                    if (!Wand.isWand(item2) && !Wand.isSpell(item2) && !Wand.isBrush(item2) && !Wand.isUpgrade(item2)) continue;
                    items[i] = null;
                }
                inventory.setContents(items);
                mage.sendMessage(messages.get("wand.self_destruct"));
            }
            return;
        }
        if (!mage.checkLastClick(this.clickCooldown)) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isSwing = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        if (isSwing) {
            wand.playEffects("swing");
        }
        if (isSwing && !wand.isUpgrade() && !wand.isQuickCast()) {
            if (!this.controller.hasWandPermission(player, wand)) {
                mage.sendMessage(messages.get("wand.no_permission").replace("$wand", wand.getName()));
                return;
            }
            wand.cast();
            event.setCancelled(true);
            return;
        }
        boolean bl2 = toggleInventory = action == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && action == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl3 = toggleInventory = !this.controller.isInteractable(event.getClickedBlock());
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                wand.closeInventory();
            }
        }
        if (toggleInventory && !wand.isDropToggle()) {
            this.controller.onToggleInventory(mage, wand);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.controller.getMage(event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerQuitEvent((PlayerEvent)event);
    }

    protected void handlePlayerQuitEvent(PlayerEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            if (mage instanceof Mage) {
                ((Mage)mage).onPlayerQuit(event);
            }
            this.controller.playerQuit(mage);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
        mage.checkWand();
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.getNewGameMode() == GameMode.CREATIVE) {
            Player player = event.getPlayer();
            com.elmakers.mine.bukkit.api.magic.Mage mage = this.controller.getMage(player);
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = mage.getActiveWand();
            if (activeWand != null) {
                activeWand.closeInventory();
            }
            if (this.enableCreativeModeEjecting) {
                boolean ejected = false;
                if (activeWand != null) {
                    activeWand.deactivate();
                }
                PlayerInventory inventory = player.getInventory();
                ItemStack[] contents = inventory.getContents();
                for (int i = 0; i < contents.length; ++i) {
                    ItemStack item = contents[i];
                    if (!Wand.isWand(item)) continue;
                    ejected = true;
                    inventory.setItem(i, null);
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                }
                if (ejected) {
                    mage.sendMessage("Ejecting wands, creative mode will destroy them!");
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Wand activeWand;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getMage(player);
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Item item = event.getItem();
        ItemStack pickup = item.getItemStack();
        if (NMSUtils.isTemporary(pickup) || item.hasMetadata("temporary")) {
            item.remove();
            event.setCancelled(true);
            return;
        }
        boolean isWand = Wand.isWand(pickup);
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE && isWand && this.enableCreativeModeEjecting) {
            event.setCancelled(true);
            return;
        }
        Messages messages = this.controller.getMessages();
        if (isWand) {
            Wand wand = new Wand(this.controller, pickup);
            if (!wand.canUse(player)) {
                mage.sendMessage(messages.get("wand.bound").replace("$name", wand.getOwner()));
                event.setCancelled(true);
                Item droppedItem = event.getItem();
                Vector velocity = droppedItem.getVelocity();
                velocity.setY(velocity.getY() * 2.0 + 1.0);
                droppedItem.setVelocity(velocity);
                return;
            }
            if (this.controller.removeLostWand(wand.getId())) {
                this.controller.info("Player " + mage.getName() + " picked up wand " + wand.getName() + ", id " + wand.getId());
            }
        }
        if ((activeWand = mage.getActiveWand()) != null && activeWand.isModifiable() && (Wand.isSpell(pickup) || Wand.isBrush(pickup) || Wand.isUpgrade(pickup)) && activeWand.addItem(pickup)) {
            event.getItem().remove();
            event.setCancelled(true);
            return;
        }
        if (mage.hasStoredInventory()) {
            event.setCancelled(true);
            if (mage.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (isWand && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this.controller, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(mage);
            }
        }
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (event.getAmount() <= 0) {
            return;
        }
        Player player = event.getPlayer();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage((Entity)player);
        if (apiMage != null && !(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.onPlayerExpChange(event);
        }
    }
}

