/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.ItemStack;

public abstract class ConfigurationMageDataStore
implements MageDataStore {
    protected Logger logger;
    protected MageController controller;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        this.controller = controller;
        this.logger = controller.getPlugin().getLogger();
    }

    public void save(MageData mage, ConfigurationSection saveFile) {
        ConfigurationSection extraData;
        com.elmakers.mine.bukkit.api.wand.Wand soulWand;
        List<ItemStack> storedInventory;
        Map<Integer, ItemStack> respawnInventory;
        Map<Integer, ItemStack> respawnArmor;
        UndoData undoData;
        saveFile.set("id", (Object)mage.getId());
        saveFile.set("name", (Object)mage.getName());
        saveFile.set("last_cast", (Object)mage.getLastCast());
        saveFile.set("cooldown_expiration", (Object)mage.getCooldownExpiration());
        saveFile.set("last_death_location", (Object)ConfigurationUtils.fromLocation(mage.getLastDeathLocation()));
        Location location = mage.getLocation();
        if (location != null) {
            saveFile.set("location", (Object)ConfigurationUtils.fromLocation(location));
        }
        saveFile.set("destination_warp", (Object)mage.getDestinationWarp());
        saveFile.set("fall_protection_count", (Object)mage.getFallProtectionCount());
        saveFile.set("fall_protection", (Object)mage.getFallProtectionDuration());
        BrushData brush = mage.getBrushData();
        if (brush != null) {
            ConfigurationSection brushNode = saveFile.createSection("brush");
            try {
                Location materialTarget;
                Location cloneTarget;
                Location cloneSource = brush.getCloneLocation();
                if (cloneSource != null) {
                    brushNode.set("clone_location", (Object)ConfigurationUtils.fromLocation(cloneSource));
                }
                if ((cloneTarget = brush.getCloneTarget()) != null) {
                    brushNode.set("clone_target", (Object)ConfigurationUtils.fromLocation(cloneTarget));
                }
                if ((materialTarget = brush.getMaterialTarget()) != null) {
                    brushNode.set("material_target", (Object)ConfigurationUtils.fromLocation(materialTarget));
                }
                brushNode.set("map_id", (Object)brush.getMapId());
                brushNode.set("material", (Object)ConfigurationUtils.fromMaterial(brush.getMaterial()));
                brushNode.set("data", (Object)brush.getMaterialData());
                brushNode.set("schematic", (Object)brush.getSchematicName());
                brushNode.set("scale", (Object)brush.getScale());
                brushNode.set("erase", (Object)brush.isFillWithAir());
            }
            catch (Exception ex) {
                this.logger.warning("Failed to save brush data: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if ((undoData = mage.getUndoData()) != null) {
            ArrayList<Map> nodeList = new ArrayList<Map>();
            List<UndoList> undoList = undoData.getBlockList();
            for (UndoList list : undoList) {
                MemoryConfiguration listNode = new MemoryConfiguration();
                list.save((ConfigurationSection)listNode);
                nodeList.add(listNode.getValues(true));
            }
            saveFile.set("undo", nodeList);
        }
        ConfigurationSection spellNode = saveFile.createSection("spells");
        for (SpellData spell : mage.getSpellData()) {
            ConfigurationSection node = spellNode.createSection(spell.getKey());
            node.set("cast_count", (Object)spell.getCastCount());
            node.set("last_cast", (Object)spell.getLastCast());
            node.set("cooldown_expiration", (Object)spell.getCooldownExpiration());
            node.set("active", (Object)(spell.isActive() ? Boolean.valueOf(true) : null));
            ConfigurationSection extra = spell.getExtraData();
            if (extra == null) continue;
            ConfigurationUtils.addConfigurations(node, extra);
        }
        Map<String, ItemStack> boundWands = mage.getBoundWands();
        if (boundWands != null && boundWands.size() > 0) {
            ConfigurationSection wandSection = saveFile.createSection("wands");
            for (Map.Entry<String, ItemStack> wandEntry : boundWands.entrySet()) {
                String key = wandEntry.getKey();
                if (key == null || key.isEmpty()) continue;
                this.controller.serialize(wandSection, key, wandEntry.getValue());
            }
        }
        if ((respawnArmor = mage.getRespawnArmor()) != null) {
            ConfigurationSection armorSection = saveFile.createSection("respawn_armor");
            for (Map.Entry<Integer, ItemStack> entry : respawnArmor.entrySet()) {
                this.controller.serialize(armorSection, Integer.toString(entry.getKey()), entry.getValue());
            }
        }
        if ((respawnInventory = mage.getRespawnInventory()) != null) {
            ConfigurationSection inventorySection = saveFile.createSection("respawn_inventory");
            for (Map.Entry<Integer, ItemStack> entry : respawnInventory.entrySet()) {
                this.controller.serialize(inventorySection, Integer.toString(entry.getKey()), entry.getValue());
            }
        }
        if ((storedInventory = mage.getStoredInventory()) != null) {
            saveFile.set("inventory", storedInventory);
        }
        if ((soulWand = mage.getSoulWand()) != null && soulWand instanceof Wand) {
            Wand wand = (Wand)soulWand;
            ConfigurationSection soulNode = saveFile.createSection("soul");
            wand.saveProperties(soulNode);
        }
        if ((extraData = mage.getExtraData()) != null) {
            ConfigurationSection dataSection = saveFile.createSection("data");
            ConfigurationUtils.addConfigurations(dataSection, extraData);
        }
    }

    @Override
    public void save(Collection<MageData> mages) {
        for (MageData data : mages) {
            this.save(data);
        }
    }

    public MageData load(String id, ConfigurationSection saveFile) {
        ConfigurationSection respawnArmorData;
        ConfigurationSection respawnData;
        MageData data = new MageData(id);
        ConfigurationSection brushConfig = saveFile.getConfigurationSection("brush");
        if (brushConfig != null) {
            BrushData brushData = new BrushData();
            try {
                brushData.setCloneLocation(ConfigurationUtils.getLocation(brushConfig, "clone_location"));
                brushData.setCloneTarget(ConfigurationUtils.getLocation(brushConfig, "clone_target"));
                brushData.setMaterialTarget(ConfigurationUtils.getLocation(brushConfig, "material_target"));
                brushData.setSchematicName(brushConfig.getString("schematic", ""));
                brushData.setMapId((short)brushConfig.getInt("map_id", -1));
                brushData.setMaterial(ConfigurationUtils.getMaterial(brushConfig, "material", Material.AIR));
                brushData.setMaterialData((short)brushConfig.getInt("data", 0));
                brushData.setScale(brushConfig.getDouble("scale", 1.0));
                brushData.setFillWithAir(brushConfig.getBoolean("erase", true));
                data.setBrushData(brushData);
            }
            catch (Exception ex) {
                this.logger.warning("Failed to load brush data: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (saveFile.contains("wands")) {
            HashMap<String, ItemStack> boundWands = new HashMap<String, ItemStack>();
            ConfigurationSection wands = saveFile.getConfigurationSection("wands");
            Set keys = wands.getKeys(false);
            for (String key : keys) {
                ItemStack boundWand = this.controller.deserialize(wands, key);
                boundWands.put(key, boundWand);
            }
            data.setBoundWands(boundWands);
        }
        data.setExtraData(saveFile.getConfigurationSection("data"));
        data.setFallProtectionCount(saveFile.getLong("fall_protection_count", 0L));
        data.setFallProtectionDuration(saveFile.getLong("fall_protection", 0L));
        data.setName(saveFile.getString("name", ""));
        data.setLastDeathLocation(ConfigurationUtils.getLocation(saveFile, "last_death_location"));
        data.setLocation(ConfigurationUtils.getLocation(saveFile, "location"));
        data.setLastCast(saveFile.getLong("last_cast", 0L));
        data.setCooldownExpiration(saveFile.getLong("cooldown_expiration", 0L));
        data.setDestinationWarp(saveFile.getString("destination_warp"));
        UndoData undoData = new UndoData();
        Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(saveFile, "undo");
        if (nodeList != null) {
            for (ConfigurationSection listNode : nodeList) {
                com.elmakers.mine.bukkit.block.UndoList list = new com.elmakers.mine.bukkit.block.UndoList(null);
                list.load(listNode);
                undoData.getBlockList().add(list);
            }
        }
        data.setUndoData(undoData);
        ConfigurationSection spellSection = saveFile.getConfigurationSection("spells");
        if (spellSection != null) {
            Set keys = spellSection.getKeys(false);
            ArrayList<SpellData> spellDataList = new ArrayList<SpellData>();
            for (String key : keys) {
                ConfigurationSection node = spellSection.getConfigurationSection(key);
                SpellData spellData = new SpellData(key);
                spellData.setCastCount(node.getLong("cast_count", 0L));
                spellData.setLastCast(node.getLong("last_cast", 0L));
                spellData.setCooldownExpiration(node.getLong("cooldown_expiration", 0L));
                spellData.setExtraData(node);
                spellDataList.add(spellData);
            }
            data.setSpellData(spellDataList);
        }
        if ((respawnData = saveFile.getConfigurationSection("respawn_inventory")) != null) {
            Set keys = respawnData.getKeys(false);
            HashMap<Integer, ItemStack> respawnInventory = new HashMap<Integer, ItemStack>();
            for (String key : keys) {
                try {
                    int index = Integer.parseInt(key);
                    ItemStack item = this.controller.deserialize(respawnData, key);
                    respawnInventory.put(index, item);
                }
                catch (Exception ex) {}
            }
            data.setRespawnInventory(respawnInventory);
        }
        if ((respawnArmorData = saveFile.getConfigurationSection("respawn_armor")) != null) {
            Set keys = respawnArmorData.getKeys(false);
            HashMap<Integer, ItemStack> respawnArmor = new HashMap<Integer, ItemStack>();
            for (String key : keys) {
                try {
                    int index = Integer.parseInt(key);
                    ItemStack item = this.controller.deserialize(respawnArmorData, key);
                    respawnArmor.put(index, item);
                }
                catch (Exception ex) {}
            }
            data.setRespawnArmor(respawnArmor);
        }
        if (saveFile.contains("brush")) {
            try {
                ConfigurationSection node = saveFile.getConfigurationSection("brush");
                BrushData brushData = new BrushData();
                brushData.setCloneLocation(ConfigurationUtils.getLocation(node, "clone_location"));
                brushData.setCloneTarget(ConfigurationUtils.getLocation(node, "clone_target"));
                brushData.setMaterialTarget(ConfigurationUtils.getLocation(node, "material_target"));
                brushData.setSchematicName(node.getString("schematic"));
                brushData.setMapId((short)node.getInt("map_id"));
                brushData.setMaterial(ConfigurationUtils.getMaterial(node, "material"));
                brushData.setMaterialData((short)node.getInt("data"));
                brushData.setScale(node.getDouble("scale"));
                brushData.setFillWithAir(node.getBoolean("erase"));
                data.setBrushData(brushData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.controller.getLogger().warning("Failed to load brush data: " + ex.getMessage());
            }
        }
        if (saveFile.contains("inventory")) {
            data.setStoredInventory(saveFile.getList("inventory"));
        }
        if (saveFile.contains("soul") && this.controller instanceof MagicController) {
            ConfigurationSection soulNode = saveFile.getConfigurationSection("soul");
            Wand wand = new Wand((MagicController)this.controller, soulNode);
            data.setSoulWand(wand);
        }
        return data;
    }
}

