/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TeleportAction
extends BaseTeleportAction {
    private static int DEFAULT_PASSTHROUGH_RANGE = 4;
    private boolean autoPassthrough = true;
    private int passthroughRange;
    private int ledgeSearchDistance = 2;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        Mage mage = context.getMage();
        this.ledgeSearchDistance = parameters.getInt("ledge_range", 2);
        this.autoPassthrough = parameters.getBoolean("allow_passthrough", true);
        this.passthroughRange = (int)Math.floor(mage.getRangeMultiplier() * (float)parameters.getInt("passthrough_range", DEFAULT_PASSTHROUGH_RANGE));
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location safeLocation;
        Entity entity = context.getEntity();
        if (entity == null) {
            return SpellResult.ENTITY_REQUIRED;
        }
        boolean isPassthrough = false;
        if (this.autoPassthrough) {
            Block firstBlock = context.getInteractBlock();
            if (firstBlock == null) {
                return SpellResult.NO_TARGET;
            }
            if (!context.allowPassThrough(firstBlock.getType())) {
                return SpellResult.NO_TARGET;
            }
            if (firstBlock != null && !context.isPassthrough(firstBlock.getType())) {
                context.retarget(this.passthroughRange, 0.0, this.passthroughRange, 0.0, false, -1, true, 1);
                isPassthrough = true;
            }
        }
        Block target = context.getTargetBlock();
        Block face = context.getPreviousBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (face == null) {
            face = target;
        }
        World world = context.getWorld();
        Block destination = face;
        int verticalSearchDistance = context.getVerticalSearchDistance();
        if (isPassthrough || destination == null) {
            destination = target;
        }
        if (!(entity instanceof Player && ((Player)entity).isFlying() || (safeLocation = context.findPlaceToStand(destination.getLocation(), verticalSearchDistance, false)) == null)) {
            destination = safeLocation.getBlock();
        }
        Block ledge = null;
        if (!(isPassthrough || face.equals(target.getRelative(BlockFace.DOWN)) && !this.autoPassthrough)) {
            int distanceUp;
            ledge = target;
            Block inFront = face;
            Block oneUp = ledge.getRelative(BlockFace.UP);
            Block twoUp = oneUp.getRelative(BlockFace.UP);
            Block faceOneUp = face.getRelative(BlockFace.UP);
            Block faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
            if (!(this.autoPassthrough || context.isTransparent(oneUp.getType()) && context.isTransparent(twoUp.getType()) && context.isTransparent(face.getType()) && context.isTransparent(faceOneUp.getType()) && context.isTransparent(faceTwoUp.getType()))) {
                ledge = null;
            } else {
                for (distanceUp = 0; (this.autoPassthrough || context.isTransparent(face.getType()) && context.isTransparent(faceOneUp.getType()) && context.isTransparent(faceTwoUp.getType())) && distanceUp < this.ledgeSearchDistance && context.isOkToStandIn(inFront.getType()) && (!context.isOkToStandOn(ledge.getType()) || !context.isOkToStandIn(oneUp.getType()) || !context.isOkToStandIn(twoUp.getType())); ++distanceUp) {
                    faceOneUp = faceOneUp.getRelative(BlockFace.UP);
                    faceTwoUp = faceOneUp.getRelative(BlockFace.UP);
                    inFront = inFront.getRelative(BlockFace.UP);
                    ledge = ledge.getRelative(BlockFace.UP);
                }
            }
            if (distanceUp >= this.ledgeSearchDistance) {
                ledge = null;
            }
        } else {
            ledge = null;
        }
        if (ledge != null && context.isOkToStandOn(ledge.getType())) {
            destination = ledge.getRelative(BlockFace.UP);
        }
        Block oneUp = destination.getRelative(BlockFace.UP);
        if (!context.isOkToStandIn(destination.getType()) || !context.isOkToStandIn(oneUp.getType())) {
            return SpellResult.NO_TARGET;
        }
        Location targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, entity.getLocation().getYaw(), entity.getLocation().getPitch());
        context.teleport(entity, targetLocation, verticalSearchDistance);
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

