/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.TriggeredCompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class FireworkAction
extends TriggeredCompoundAction {
    private int power;
    private Integer ticksFlown;
    private Integer expectedLifespan;
    private Color color1 = null;
    private Color color2 = null;
    private FireworkEffect.Type fireworkType = null;
    private Boolean flicker = null;
    private Boolean trail = null;
    private boolean launch = false;
    private int startDistance;
    private double speed;
    private double dyOffset;
    private int checkInterval;
    private boolean setTarget;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        Random rand = context.getRandom();
        this.power = rand.nextInt(2) + 1;
        Mage mage = context.getMage();
        this.power = parameters.getInt("power", this.power);
        if (parameters.contains("color")) {
            this.color1 = this.getColor(parameters.getString("color"));
        } else if (mage.getEffectColor() != null) {
            this.color1 = mage.getEffectColor();
        }
        if (parameters.contains("color2")) {
            this.color2 = this.getColor(parameters.getString("color2"));
        }
        if (parameters.contains("firework")) {
            this.fireworkType = this.getType(parameters.getString("firework"));
        }
        this.flicker = parameters.getBoolean("flicker");
        this.trail = parameters.getBoolean("trail");
        this.launch = parameters.getBoolean("launch", false);
        this.startDistance = parameters.getInt("start", 0);
        this.speed = parameters.getDouble("speed", 0.1);
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        this.checkInterval = parameters.getInt("check_interval", 10);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.ticksFlown = parameters.contains("ticks_flown") ? Integer.valueOf(parameters.getInt("ticks_flown")) : null;
        this.expectedLifespan = parameters.contains("expected_lifespan") ? Integer.valueOf(parameters.getInt("expected_lifespan")) : null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Location location = context.getEyeLocation();
        Vector direction = null;
        if (this.launch) {
            direction = context.getDirection();
            if (this.dyOffset != 0.0) {
                direction.setY(direction.getY() + this.dyOffset);
            }
            direction = direction.normalize();
            if (this.startDistance > 0) {
                location = location.add(direction.clone().multiply(this.startDistance));
            }
            direction = direction.multiply(this.speed);
        } else {
            location = context.getTargetLocation();
        }
        FireworkEffect effect = EffectUtils.getFireworkEffect(context, this.color1, this.color2, this.fireworkType, this.flicker, this.trail);
        Entity firework = EffectUtils.spawnFireworkEffect(context.getPlugin().getServer(), location, effect, this.power, direction, this.expectedLifespan, this.ticksFlown);
        if (firework != null) {
            Collection<EffectPlayer> projectileEffects = context.getEffects("projectile");
            for (EffectPlayer effectPlayer : projectileEffects) {
                effectPlayer.start(firework.getLocation(), firework, null, null);
            }
            ActionHandler.setActions(firework, this.actions, context, this.parameters, "indirect_player_message");
            ActionHandler.setEffects(firework, context, "hit");
            this.scheduleEntityCheck(context, firework, this.checkInterval);
            if (this.setTarget) {
                context.setTargetEntity(firework);
            }
        }
        return SpellResult.CAST;
    }

    protected void scheduleEntityCheck(final CastContext context, final Entity entity, final int interval) {
        if (interval > 0) {
            Bukkit.getScheduler().scheduleSyncDelayedTask(context.getController().getPlugin(), new Runnable(){

                @Override
                public void run() {
                    FireworkAction.this.checkEntity(context, entity, interval);
                }
            }, (long)interval);
        }
    }

    protected void checkEntity(CastContext context, Entity entity, int interval) {
        if (entity.isDead() || !entity.isValid()) {
            ActionHandler.runActions(entity, entity.getLocation(), entity);
            ActionHandler.runEffects(entity);
        } else {
            this.scheduleEntityCheck(context, entity, interval);
        }
    }

    protected Color getColor(String name) {
        try {
            Field colorConstant = Color.class.getField(name.toUpperCase());
            return (Color)colorConstant.get(null);
        }
        catch (Exception exception) {
            return Color.WHITE;
        }
    }

    protected FireworkEffect.Type getType(String name) {
        for (FireworkEffect.Type t : FireworkEffect.Type.values()) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        return FireworkEffect.Type.BALL;
    }
}

