/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.Target;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class CustomProjectileAction
extends CompoundAction {
    private Targeting targeting;
    private int interval;
    private int lifetime;
    private int range;
    private double speed;
    private int startDistance;
    private String projectileEffectKey;
    private String hitEffectKey;
    private String tickEffectKey;
    private double gravity;
    private double drag;
    private double tickSize;
    private boolean reorient;
    private boolean useWandLocation;
    private boolean useEyeLocation;
    private boolean trackEntity;
    private int targetSelfTimeout;
    private boolean breaksBlocks;
    private double targetBreakables;
    private int targetBreakableSize;
    private boolean bypassBackfire;
    private double distanceTravelled;
    private double effectDistanceTravelled;
    private boolean hasTickEffects;
    private boolean hasStepEffects;
    private boolean hasBlockMissEffects;
    private boolean hasPreHitEffects;
    private long lastUpdate;
    private long nextUpdate;
    private long deadline;
    private long targetSelfDeadline;
    private boolean hit = false;
    private Vector velocity = null;
    private DynamicLocation effectLocation = null;
    private Collection<EffectPlay> activeProjectileEffects;

    @Override
    public void initialize(Spell spell, ConfigurationSection baseParameters) {
        super.initialize(spell, baseParameters);
        this.targeting = new Targeting();
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targeting.processParameters(parameters);
        this.interval = parameters.getInt("interval", 30);
        this.lifetime = parameters.getInt("lifetime", 8000);
        this.startDistance = parameters.getInt("start", 0);
        this.range = parameters.getInt("range", 0);
        this.projectileEffectKey = parameters.getString("projectile_effects", "projectile");
        this.hitEffectKey = parameters.getString("hit_effects", "hit");
        this.tickEffectKey = parameters.getString("tick_effects", "tick");
        this.gravity = parameters.getDouble("gravity", 0.0);
        this.drag = parameters.getDouble("drag", 0.0);
        this.tickSize = parameters.getDouble("tick_size", 0.5);
        this.reorient = parameters.getBoolean("reorient", false);
        this.useWandLocation = parameters.getBoolean("use_wand_location", true);
        this.useEyeLocation = parameters.getBoolean("use_eye_location", true);
        this.trackEntity = parameters.getBoolean("track_target", false);
        this.targetSelfTimeout = parameters.getInt("target_self_timeout", 0);
        this.breaksBlocks = parameters.getBoolean("break_blocks", true);
        this.targetBreakables = parameters.getDouble("target_breakables", 1.0);
        this.targetBreakableSize = parameters.getInt("breakable_size", 1);
        this.bypassBackfire = parameters.getBoolean("bypass_backfire", false);
        this.range = (int)((float)this.range * context.getMage().getRangeMultiplier());
        this.speed = parameters.getDouble("speed", 1.0);
        this.speed = parameters.getDouble("velocity", this.speed * 20.0);
        TargetType targetType = this.targeting.getTargetType();
        if (targetType == TargetType.NONE) {
            this.targeting.setTargetType(TargetType.OTHER);
        }
        this.hasTickEffects = context.getEffects(this.tickEffectKey).size() > 0;
        this.hasBlockMissEffects = context.getEffects("blockmiss").size() > 0;
        this.hasStepEffects = context.getEffects("step").size() > 0;
        this.hasPreHitEffects = context.getEffects("prehit").size() > 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.targeting.reset();
        long now = System.currentTimeMillis();
        this.nextUpdate = 0L;
        this.distanceTravelled = 0.0;
        this.lastUpdate = 0L;
        this.deadline = now + (long)this.lifetime;
        this.targetSelfDeadline = this.targetSelfTimeout > 0 ? now + (long)this.targetSelfTimeout : 0L;
        this.hit = false;
        this.effectLocation = null;
        this.velocity = null;
        this.activeProjectileEffects = null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        boolean minHeight;
        Location targetLocation;
        long now = System.currentTimeMillis();
        if (now < this.nextUpdate) {
            return SpellResult.PENDING;
        }
        if (this.hit) {
            return super.perform(this.actionContext);
        }
        if (now > this.deadline) {
            return this.hit();
        }
        if (this.targetSelfDeadline > 0L && now > this.targetSelfDeadline) {
            this.targetSelfDeadline = 0L;
            context.setTargetsCaster(true);
        }
        this.nextUpdate = now + (long)this.interval;
        Location projectileLocation = null;
        if (this.velocity == null) {
            this.createActionContext(context);
            Location targetLocation2 = context.getTargetLocation();
            projectileLocation = this.useWandLocation ? context.getWandLocation().clone() : (this.useEyeLocation ? context.getEyeLocation().clone() : context.getLocation().clone());
            this.velocity = targetLocation2 != null && !this.reorient ? targetLocation2.toVector().subtract(projectileLocation.toVector()).normalize() : context.getDirection().clone().normalize();
            projectileLocation.setDirection(this.velocity);
            this.actionContext.setTargetLocation(projectileLocation);
            this.actionContext.setTargetEntity(null);
            this.actionContext.setDirection(this.velocity);
            if (this.startDistance != 0) {
                projectileLocation.add(this.velocity.clone().multiply(this.startDistance));
            }
            Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> projectileEffects = context.getEffects(this.projectileEffectKey);
            for (com.elmakers.mine.bukkit.api.effect.EffectPlayer apiEffectPlayer : projectileEffects) {
                if (this.effectLocation == null) {
                    this.effectLocation = new DynamicLocation(projectileLocation);
                    this.effectLocation.setDirection(this.velocity);
                }
                if (this.activeProjectileEffects == null) {
                    this.activeProjectileEffects = new ArrayList<EffectPlay>();
                }
                if (!(apiEffectPlayer instanceof EffectPlayer)) continue;
                EffectPlayer effectPlayer = (EffectPlayer)apiEffectPlayer;
                effectPlayer.setEffectPlayList(this.activeProjectileEffects);
                effectPlayer.startEffects(this.effectLocation, null);
            }
        } else {
            projectileLocation = this.actionContext.getTargetLocation();
            if (this.effectLocation != null) {
                this.effectLocation.updateFrom(projectileLocation);
                this.effectLocation.setDirection(this.velocity);
            }
        }
        long delta = this.lastUpdate > 0L ? now - this.lastUpdate : 50L;
        this.lastUpdate = now;
        if (this.trackEntity) {
            Entity targetEntity = context.getTargetEntity();
            if (targetEntity != null && targetEntity.isValid() && context.canTarget(targetEntity)) {
                Location targetLocation3 = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getEyeLocation() : targetEntity.getLocation();
                this.velocity = targetLocation3.toVector().subtract(projectileLocation.toVector()).normalize();
            }
        } else if (this.reorient) {
            this.velocity = context.getDirection().clone().normalize();
        } else {
            if (this.gravity > 0.0) {
                this.velocity.setY(this.velocity.getY() - this.gravity * (double)delta / 50.0).normalize();
            }
            if (this.drag > 0.0) {
                this.speed -= this.drag * (double)delta / 50.0;
                if (this.speed <= 0.0) {
                    return this.hit();
                }
            }
        }
        projectileLocation.setDirection(this.velocity);
        this.targeting.start(projectileLocation);
        double distance = this.speed * (double)delta / 1000.0;
        if (this.range > 0) {
            distance = Math.min(distance, (double)this.range - this.distanceTravelled);
        }
        context.addWork((int)Math.ceil(distance));
        Target target = this.targeting.target(this.actionContext, distance);
        Targeting.TargetingResult targetingResult = this.targeting.getResult();
        if (targetingResult == Targeting.TargetingResult.MISS) {
            if (this.hasBlockMissEffects) {
                this.actionContext.setTargetLocation(target.getLocation());
                this.actionContext.playEffects("blockmiss");
            }
            targetLocation = projectileLocation.clone().add(this.velocity.clone().multiply(distance));
            context.getMage().sendDebugMessage(ChatColor.DARK_BLUE + "Projectile miss: " + ChatColor.DARK_PURPLE + " at " + targetLocation.getBlock().getType() + " : " + targetLocation.toVector() + " from range of " + distance + " over time " + delta, 7);
        } else {
            if (this.hasPreHitEffects) {
                this.actionContext.playEffects("prehit");
            }
            targetLocation = target.getLocation();
            context.getMage().sendDebugMessage(ChatColor.BLUE + "Projectile hit: " + ChatColor.LIGHT_PURPLE + targetingResult.name().toLowerCase() + ChatColor.BLUE + " at " + ChatColor.GOLD + targetLocation.getBlock().getType() + ChatColor.BLUE + " from " + ChatColor.GRAY + projectileLocation.getBlock() + ChatColor.BLUE + " to " + ChatColor.GRAY + targetLocation.toVector() + ChatColor.BLUE + " from range of " + ChatColor.GOLD + distance + ChatColor.BLUE + " over time " + ChatColor.DARK_PURPLE + delta, 4);
            distance = targetLocation.distance(projectileLocation);
        }
        this.distanceTravelled += distance;
        this.effectDistanceTravelled += distance;
        int y = targetLocation.getBlockY();
        boolean maxHeight = y >= targetLocation.getWorld().getMaxHeight();
        boolean bl = minHeight = y <= 0;
        if (maxHeight) {
            targetLocation.setY((double)targetLocation.getWorld().getMaxHeight());
        } else if (minHeight) {
            targetLocation.setY(0.0);
        }
        if (this.hasTickEffects && this.effectDistanceTravelled > this.tickSize) {
            Vector speedVector = this.velocity.clone().multiply(this.tickSize);
            for (int i = 0; i < 256; ++i) {
                this.actionContext.setTargetLocation(projectileLocation);
                this.actionContext.playEffects(this.tickEffectKey);
                projectileLocation.add(speedVector);
                this.effectDistanceTravelled -= this.tickSize;
                if (this.effectDistanceTravelled < this.tickSize) break;
            }
        }
        this.actionContext.setTargetLocation(targetLocation);
        this.actionContext.setTargetEntity(target.getEntity());
        if (this.hasStepEffects) {
            this.actionContext.playEffects("step");
        }
        if (maxHeight || minHeight) {
            return this.hit();
        }
        if (this.range > 0 && this.distanceTravelled >= (double)this.range) {
            return this.hit();
        }
        Block block = targetLocation.getBlock();
        if (targetingResult != Targeting.TargetingResult.MISS) {
            return this.hitBlock(block);
        }
        if (!block.getChunk().isLoaded()) {
            return this.hit();
        }
        return SpellResult.PENDING;
    }

    protected SpellResult hitBlock(Block block) {
        boolean continueProjectile = false;
        if (!this.bypassBackfire && this.actionContext.isReflective(block)) {
            double reflective = this.actionContext.getReflective(block);
            if (this.actionContext.getRandom().nextDouble() < reflective) {
                this.trackEntity = false;
                this.reorient = false;
                this.distanceTravelled = 0.0;
                this.actionContext.setTargetsCaster(true);
                Location targetLocation = this.actionContext.getTargetLocation();
                Vector normal = CompatibilityUtils.getNormal(block, targetLocation);
                this.velocity.multiply(-1);
                this.velocity = this.velocity.subtract(normal.multiply(2.0 * this.velocity.dot(normal))).normalize();
                this.velocity.multiply(-1);
                this.actionContext.setTargetLocation(targetLocation.add(this.velocity.clone().multiply(0.05)));
                this.actionContext.getMage().sendDebugMessage(ChatColor.AQUA + "Projectile reflected: " + ChatColor.LIGHT_PURPLE + " at " + ChatColor.GRAY + block + ChatColor.AQUA + " with normal vector of " + ChatColor.LIGHT_PURPLE + normal, 4);
                this.actionContext.playEffects("reflect");
                continueProjectile = true;
            }
        }
        if (this.targetBreakables > 0.0 && this.breaksBlocks && this.actionContext.isBreakable(block)) {
            this.targetBreakables -= (double)this.targeting.breakBlock(this.actionContext, block, Math.min((double)this.targetBreakableSize, this.targetBreakables));
            if (this.targetBreakables > 0.0) {
                continueProjectile = true;
            }
        }
        return continueProjectile ? SpellResult.PENDING : this.hit();
    }

    protected SpellResult hit() {
        this.hit = true;
        if (this.activeProjectileEffects != null) {
            for (EffectPlay play : this.activeProjectileEffects) {
                play.cancel();
            }
        }
        if (this.actionContext == null) {
            return SpellResult.NO_ACTION;
        }
        this.actionContext.playEffects(this.hitEffectKey);
        return super.perform(this.actionContext);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("interval");
        parameters.add("lifetime");
        parameters.add("speed");
        parameters.add("start");
        parameters.add("gravity");
        parameters.add("drag");
        parameters.add("target_entities");
        parameters.add("track_target");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("speed") || parameterKey.equals("lifetime") || parameterKey.equals("interval") || parameterKey.equals("start") || parameterKey.equals("size") || parameterKey.equals("gravity") || parameterKey.equals("drag") || parameterKey.equals("tick_size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_entities") || parameterKey.equals("track_target")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }
}

