/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundEntityAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.utility.Targeting;
import java.lang.ref.WeakReference;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ConeOfEffectAction
extends CompoundEntityAction {
    private int targetCount;
    private double range;
    private Targeting targeting;

    @Override
    public void initialize(Spell spell, ConfigurationSection baseParameters) {
        super.initialize(spell, baseParameters);
        this.targeting = new Targeting();
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.createActionContext(context);
        this.targeting.start(context.getEyeLocation());
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.targetCount = parameters.getInt("target_count", -1);
        this.range = parameters.getDouble("range", 16.0);
        this.range *= (double)context.getMage().getRangeMultiplier();
        this.targeting.processParameters(parameters);
        TargetType targetType = this.targeting.getTargetType();
        if (targetType == TargetType.NONE || targetType == TargetType.BLOCK) {
            this.targeting.setTargetType(TargetType.OTHER);
        } else if (targetType == TargetType.SELF) {
            this.targeting.setTargetType(TargetType.ANY);
        }
        this.targeting.setUseHitbox(false);
    }

    @Override
    public void addEntities(CastContext context, List<WeakReference<Entity>> entities) {
        this.targeting.getTargetEntities(context, this.range, this.targetCount, entities);
    }
}

