/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.MageController;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class TeleportTask
implements Runnable {
    protected static final int TELEPORT_RETRY_COUNT = 8;
    protected static final int TELEPORT_RETRY_INTERVAL = 10;
    private final CastContext context;
    private final Entity entity;
    private final Location location;
    private final int verticalSearchDistance;
    private final int retryCount;
    private final MageController controller;

    private TeleportTask(MageController controller, Entity entity, Location location, int verticalSearchDistance, CastContext context, int retryCount) {
        this.context = context;
        this.entity = entity;
        this.location = location;
        this.verticalSearchDistance = verticalSearchDistance;
        this.controller = controller;
        this.retryCount = retryCount;
    }

    public TeleportTask(MageController controller, Entity entity, Location location, int verticalSearchDistance, CastContext context) {
        this(controller, entity, location, verticalSearchDistance, context, 8);
    }

    @Override
    public void run() {
        Chunk chunk = this.location.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < 8) {
                Plugin plugin = this.controller.getPlugin();
                TeleportTask retry = new TeleportTask(this.controller, this.entity, this.location, this.verticalSearchDistance, this.context, this.retryCount - 1);
                Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)retry, 10L);
            }
            return;
        }
        Location targetLocation = this.location;
        if (this.context != null) {
            this.context.registerMoved(this.entity);
            targetLocation = this.context.findPlaceToStand(this.location, this.verticalSearchDistance);
        }
        if (targetLocation != null) {
            boolean isWorldChange = !targetLocation.getWorld().equals(this.entity.getWorld());
            this.entity.teleport(targetLocation);
            if (isWorldChange) {
                this.entity.teleport(targetLocation);
            }
            if (this.context != null) {
                this.context.setTargetedLocation(targetLocation);
                this.context.sendMessageKey("teleport");
                this.context.playEffects("teleport");
            }
        } else if (this.context != null) {
            this.context.sendMessageKey("teleport_failed");
            this.context.playEffects("teleport_failed");
        }
    }
}

