/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.ActionHandlerContext;
import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.action.EffectContext;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.batch.ActionBatch;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class ActionHandler
implements Cloneable {
    private static final String ACTION_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.action.builtin";
    private static Map<String, Class<?>> actionClasses = new HashMap();
    private List<ActionContext> actions = new ArrayList<ActionContext>();
    private boolean undoable = false;
    private boolean usesBrush = false;
    private boolean requiresBuildPermission = false;
    private boolean requiresBreakPermission = false;
    private boolean isConditionalOnSuccess = false;
    private boolean isConditionalOnFailure = false;
    private Integer currentAction = null;
    private boolean started = false;
    private static String debugIndent = "";

    public ActionHandler() {
    }

    public ActionHandler(ActionHandler copy) {
        this.started = copy.started;
        this.undoable = copy.undoable;
        this.usesBrush = copy.usesBrush;
        this.requiresBuildPermission = copy.requiresBuildPermission;
        this.requiresBreakPermission = copy.requiresBreakPermission;
        this.isConditionalOnSuccess = copy.isConditionalOnSuccess;
        this.isConditionalOnFailure = copy.isConditionalOnFailure;
        this.currentAction = copy.currentAction;
        for (ActionContext context : copy.actions) {
            this.actions.add((ActionContext)context.clone());
        }
    }

    public void load(ConfigurationSection root, String key) {
        this.undoable = false;
        this.usesBrush = false;
        this.requiresBuildPermission = false;
        this.requiresBreakPermission = false;
        String conditionalTest = root.getString("conditional");
        if (conditionalTest != null && !conditionalTest.isEmpty()) {
            if (conditionalTest.equalsIgnoreCase("success")) {
                this.isConditionalOnSuccess = true;
            } else {
                this.isConditionalOnFailure = true;
            }
        } else {
            this.isConditionalOnSuccess = false;
            this.isConditionalOnFailure = false;
        }
        Collection<ConfigurationSection> actionNodes = ConfigurationUtils.getNodeList(root, key);
        if (actionNodes != null) {
            for (ConfigurationSection actionConfiguration : actionNodes) {
                if (!actionConfiguration.contains("class")) continue;
                String actionClassName = actionConfiguration.getString("class");
                try {
                    Class<?> genericClass;
                    if (!actionClassName.contains(".")) {
                        actionClassName = "com.elmakers.mine.bukkit.action.builtin." + actionClassName;
                    }
                    if ((genericClass = actionClasses.get(actionClassName)) == null) {
                        try {
                            genericClass = Class.forName(actionClassName + "Action");
                        }
                        catch (Exception ex) {
                            genericClass = Class.forName(actionClassName);
                        }
                        if (!BaseSpellAction.class.isAssignableFrom(genericClass)) {
                            throw new Exception("Must extend SpellAction");
                        }
                        actionClasses.put(actionClassName, genericClass);
                    }
                    Class<?> actionClass = genericClass;
                    BaseSpellAction action = (BaseSpellAction)actionClass.newInstance();
                    actionConfiguration.set("class", null);
                    if (actionConfiguration.getKeys(false).size() == 0) {
                        actionConfiguration = null;
                    }
                    this.loadAction(action, actionConfiguration);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Error loading class " + actionClassName + ": " + ex.getMessage());
                }
            }
        }
    }

    public void initialize(Spell spell, ConfigurationSection baseParameters) {
        MaterialBrush brush = spell.getBrush();
        for (ActionContext action : this.actions) {
            action.initialize(spell, baseParameters);
            this.usesBrush = this.usesBrush || action.getAction().usesBrush();
            this.undoable = this.undoable || action.getAction().isUndoable();
            boolean actionRequiresBreakPermission = action.getAction().requiresBreakPermission();
            boolean actionRequiresBuildPermission = action.getAction().requiresBuildPermission();
            if (this.usesBrush && brush != null && brush.isErase() && actionRequiresBuildPermission && !actionRequiresBreakPermission) {
                actionRequiresBreakPermission = true;
                actionRequiresBuildPermission = false;
            }
            this.requiresBuildPermission = this.requiresBuildPermission || actionRequiresBuildPermission;
            this.requiresBreakPermission = this.requiresBreakPermission || actionRequiresBreakPermission;
        }
    }

    public void loadAction(SpellAction action) {
        this.loadAction(action, null);
    }

    public void loadAction(SpellAction action, ConfigurationSection actionParameters) {
        ActionContext actionContext = new ActionContext(action, actionParameters);
        this.actions.add(actionContext);
    }

    public void loadData(Mage mage, ConfigurationSection data) {
        for (ActionContext action : this.actions) {
            action.getAction().load(mage, data);
        }
    }

    public void saveData(Mage mage, ConfigurationSection data) {
        for (ActionContext action : this.actions) {
            action.getAction().save(mage, data);
        }
    }

    public void prepare(CastContext context, ConfigurationSection parameters) {
        for (ActionContext action : this.actions) {
            action.prepare(context, parameters);
        }
    }

    public void reset(CastContext context) {
        this.started = false;
        this.currentAction = this.actions.size() > 0 ? Integer.valueOf(0) : null;
    }

    public SpellResult start(CastContext context, ConfigurationSection parameters) {
        this.prepare(context, parameters);
        this.reset(context);
        SpellResult handlerResult = this.perform(context);
        if (handlerResult == SpellResult.PENDING) {
            ActionBatch batch = new ActionBatch(context, this);
            if (!context.getMage().addBatch(batch)) {
                handlerResult = SpellResult.FAIL;
            }
        } else {
            this.finish(context);
            context.finish();
        }
        return handlerResult;
    }

    public SpellResult perform(CastContext context) {
        boolean showDebug;
        Location targetLocation = context.getTargetLocation();
        Entity targetEntity = context.getTargetEntity();
        SpellResult result = SpellResult.NO_ACTION;
        if (this.actions == null || this.actions.size() == 0) {
            return result;
        }
        Mage mage = context.getMage();
        boolean bl = showDebug = mage.getDebugLevel() > 2;
        if (showDebug) {
            debugIndent = debugIndent + "  ";
        }
        while (this.currentAction != null) {
            ActionContext action = this.actions.get(this.currentAction);
            if (!this.started) {
                this.started = true;
                action.getAction().reset(context);
            }
            if (action.getAction().requiresTargetEntity() && targetEntity == null) {
                if (showDebug) {
                    mage.sendDebugMessage(ChatColor.GRAY + debugIndent + "Action " + ChatColor.GOLD + action.getAction().getClass().getSimpleName() + ChatColor.WHITE + ": " + ChatColor.GRAY + "Skipped, requires entity target");
                }
                result = result.min(SpellResult.NO_TARGET);
                this.advance(context);
                continue;
            }
            if (action.getAction().requiresTarget() && targetLocation == null) {
                if (showDebug) {
                    mage.sendDebugMessage(ChatColor.GRAY + debugIndent + "Action " + ChatColor.GOLD + action.getAction().getClass().getSimpleName() + ChatColor.WHITE + ": " + ChatColor.GRAY + "Skipped, requires target");
                }
                result = result.min(SpellResult.NO_TARGET);
                this.advance(context);
                continue;
            }
            SpellResult actionResult = action.perform(context);
            context.addWork(1);
            result = result.min(actionResult);
            if (actionResult == SpellResult.STOP) {
                if (showDebug) {
                    mage.sendDebugMessage(ChatColor.RED + debugIndent + "Action " + ChatColor.GOLD + action.getAction().getClass().getSimpleName() + ChatColor.WHITE + ": " + ChatColor.AQUA + actionResult.name().toLowerCase());
                }
                this.cancel(context);
            }
            if (actionResult.isStop()) break;
            if (showDebug) {
                mage.sendDebugMessage(ChatColor.WHITE + debugIndent + "Action " + ChatColor.GOLD + action.getAction().getClass().getSimpleName() + ChatColor.WHITE + ": " + ChatColor.AQUA + actionResult.name().toLowerCase());
            }
            if (this.isConditionalOnSuccess && actionResult.isSuccess()) {
                this.cancel(context);
                break;
            }
            if (this.isConditionalOnFailure && !actionResult.isSuccess()) {
                this.cancel(context);
                break;
            }
            this.advance(context);
            if (context.getWorkAllowed() > 0) continue;
            result = SpellResult.PENDING;
            break;
        }
        if (showDebug) {
            debugIndent = debugIndent.substring(0, debugIndent.length() - 2);
        }
        SpellResult currentResult = context.getResult();
        context.addResult(result);
        SpellResult newResult = context.getResult();
        if (showDebug && newResult != currentResult) {
            mage.sendDebugMessage(ChatColor.AQUA + debugIndent + "Result changed from " + ChatColor.DARK_AQUA + currentResult.name().toLowerCase() + ChatColor.WHITE + " to " + ChatColor.AQUA + newResult.name().toLowerCase());
        }
        return result;
    }

    protected void advance(CastContext context) {
        context.performedActions(1);
        if (this.currentAction != null) {
            Integer n = this.currentAction;
            Integer n2 = this.currentAction = Integer.valueOf(this.currentAction + 1);
            if (this.currentAction >= this.actions.size()) {
                this.currentAction = null;
            } else {
                this.actions.get(this.currentAction).getAction().reset(context);
            }
        }
    }

    public void cancel(CastContext context) {
        if (this.currentAction != null && this.currentAction < this.actions.size()) {
            context.performedActions(this.actions.size() - this.currentAction);
        }
        this.currentAction = null;
    }

    public void finish(CastContext context) {
        for (ActionContext action : this.actions) {
            action.finish(context);
        }
    }

    public boolean isUndoable() {
        return this.undoable;
    }

    public boolean usesBrush() {
        return this.usesBrush;
    }

    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    public boolean requiresBreakPermission() {
        return this.requiresBreakPermission;
    }

    public void getParameterNames(Spell spell, Collection<String> parameters) {
        for (ActionContext context : this.actions) {
            context.getAction().getParameterNames(spell, parameters);
        }
    }

    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        for (ActionContext context : this.actions) {
            context.getAction().getParameterOptions(spell, parameterKey, examples);
        }
    }

    public String transformMessage(String message) {
        for (ActionContext context : this.actions) {
            message = context.getAction().transformMessage(message);
        }
        return message;
    }

    public static void setActions(Entity entity, ActionHandler actions, CastContext context, ConfigurationSection parameters, String messageKey) {
        if (context == null || entity == null) {
            return;
        }
        if (actions != null) {
            ActionHandlerContext handler = new ActionHandlerContext(actions, context, parameters, messageKey);
            entity.setMetadata("actions", (MetadataValue)new FixedMetadataValue(context.getController().getPlugin(), (Object)handler));
        }
    }

    public static boolean hasActions(Entity entity) {
        return entity != null && entity.hasMetadata("actions");
    }

    public static void runActions(Entity entity, Location targetLocation, Entity targetEntity) {
        if (!ActionHandler.hasActions(entity)) {
            return;
        }
        ActionHandlerContext actions = null;
        for (MetadataValue metadata : entity.getMetadata("actions")) {
            Object meta = metadata.value();
            if (!(meta instanceof ActionHandlerContext)) continue;
            actions = (ActionHandlerContext)meta;
            break;
        }
        if (actions == null) {
            return;
        }
        actions.perform(entity, entity.getLocation(), targetEntity, targetLocation);
        entity.removeMetadata("actions", actions.getContext().getController().getPlugin());
    }

    public static boolean hasEffects(Entity entity) {
        return entity != null && entity.hasMetadata("effects");
    }

    public static void runEffects(Entity entity) {
        if (!ActionHandler.hasEffects(entity)) {
            return;
        }
        EffectContext effects = null;
        for (MetadataValue metadata : entity.getMetadata("effects")) {
            Object value = metadata.value();
            if (!(value instanceof EffectContext)) continue;
            effects = (EffectContext)value;
            break;
        }
        if (effects == null) {
            return;
        }
        effects.perform();
        entity.removeMetadata("effects", effects.getContext().getController().getPlugin());
    }

    public static void targetEffects(Entity entity, Entity targetEntity) {
        if (!ActionHandler.hasEffects(entity)) {
            return;
        }
        EffectContext effects = null;
        for (MetadataValue metadata : entity.getMetadata("effects")) {
            Object value = metadata.value();
            if (!(value instanceof EffectContext)) continue;
            effects = (EffectContext)value;
            break;
        }
        if (effects == null) {
            return;
        }
        effects.getContext().setTargetEntity(targetEntity);
        entity.setMetadata("effects", (MetadataValue)new FixedMetadataValue(effects.getContext().getController().getPlugin(), (Object)effects));
    }

    public static void setEffects(Entity entity, CastContext context, String key) {
        if (key != null && context != null && entity != null) {
            EffectContext effects = new EffectContext(key, context, entity);
            entity.setMetadata("effects", (MetadataValue)new FixedMetadataValue(context.getController().getPlugin(), (Object)effects));
        }
    }

    public String toString() {
        return "ActionHandler [" + this.actions.size() + "]";
    }

    public int getActionCount() {
        int count = 0;
        for (ActionContext context : this.actions) {
            count += context.getAction().getActionCount();
        }
        return count;
    }

    public Object clone() {
        return new ActionHandler(this);
    }

    public boolean isFinished() {
        return this.currentAction == null;
    }

    public int size() {
        return this.actions.size();
    }

    public List<ActionContext> getActions() {
        return this.actions;
    }
}

