/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.slikey.effectlib.util;

import java.lang.ref.WeakReference;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class DynamicLocation {
    private final Location location;
    private final WeakReference<Entity> entity;
    private Vector offset;
    private Vector entityOffset;
    private boolean appliedOffset = false;
    private boolean updateLocation = true;
    private boolean updateDirection = true;

    public DynamicLocation(Location location) {
        this.location = location != null ? location.clone() : null;
        this.entity = null;
    }

    public DynamicLocation(Entity entity) {
        if (entity != null) {
            this.entity = new WeakReference<Entity>(entity);
            this.location = this.getEntityLocation(entity);
        } else {
            this.entity = null;
            this.location = null;
        }
    }

    public DynamicLocation(Location location, Entity entity) {
        this.location = location != null ? location.clone() : (entity != null ? this.getEntityLocation(entity) : null);
        this.entity = entity != null ? new WeakReference<Entity>(entity) : null;
    }

    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    public void addOffset(Vector offset) {
        if (this.offset == null) {
            this.offset = offset.clone();
        } else {
            this.offset.add(offset);
        }
    }

    public Entity getEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    public Location getLocation() {
        return this.location;
    }

    protected Location getEntityLocation(Entity entity) {
        if (entity instanceof LivingEntity) {
            return ((LivingEntity)entity).getEyeLocation();
        }
        return entity.getLocation();
    }

    public void setDirection(Vector direction) {
        this.location.setDirection(direction);
    }

    public void updateFrom(Location newLocation) {
        this.location.setX(newLocation.getX());
        this.location.setY(newLocation.getY());
        this.location.setZ(newLocation.getZ());
        if (this.offset != null) {
            this.location.add(this.offset);
        }
    }

    public void setUpdateLocation(boolean update) {
        this.updateLocation = update;
    }

    public void update() {
        Entity entityReference;
        if (this.location == null || !this.updateLocation && !this.updateDirection) {
            return;
        }
        Entity entity = entityReference = this.entity == null ? null : (Entity)this.entity.get();
        if (entityReference != null) {
            Location currentLocation = this.getEntityLocation(entityReference);
            if (this.updateDirection) {
                this.location.setDirection(currentLocation.getDirection());
            }
            if (this.updateLocation) {
                if (this.entityOffset != null) {
                    currentLocation.add(this.entityOffset);
                } else {
                    this.entityOffset = this.location.toVector().subtract(currentLocation.toVector());
                    currentLocation = this.location;
                }
                if (this.offset != null && !this.appliedOffset) {
                    currentLocation.add(this.offset);
                    this.entityOffset.add(this.offset);
                    this.appliedOffset = true;
                }
                this.location.setX(currentLocation.getX());
                this.location.setY(currentLocation.getY());
                this.location.setZ(currentLocation.getZ());
            }
        } else if (!this.appliedOffset && this.offset != null) {
            this.location.add(this.offset);
            this.appliedOffset = true;
        }
    }

    public void setUpdateDirection(boolean updateDirection) {
        this.updateDirection = updateDirection;
    }
}

