/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.magic.MagicController;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;

public class ExplosionController
implements Listener {
    private final MagicController controller;
    private int maxTNTPerChunk = 0;

    public ExplosionController(MagicController controller) {
        this.controller = controller;
    }

    public void setMaxTNTPerChunk(int max) {
        this.maxTNTPerChunk = max;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        UndoList blockList = this.controller.getEntityUndo(explodingEntity);
        boolean cancel = event.isCancelled();
        boolean bl = cancel = cancel || explodingEntity.hasMetadata("cancel_explosion");
        if (blockList != null) {
            CastContext context = blockList.getContext();
            if (!cancel && context != null && !context.hasBreakPermission(explodingEntity.getLocation().getBlock())) {
                cancel = true;
            }
        }
        if (cancel) {
            event.setCancelled(true);
        } else if (this.maxTNTPerChunk > 0 && explodingEntity.getType() == EntityType.PRIMED_TNT) {
            Entity[] entities;
            Chunk chunk = explodingEntity.getLocation().getChunk();
            if (chunk == null || !chunk.isLoaded()) {
                return;
            }
            int tntCount = 0;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity == null || entity.getType() != EntityType.PRIMED_TNT) continue;
                ++tntCount;
            }
            if (tntCount > this.maxTNTPerChunk) {
                event.setCancelled(true);
            } else if (blockList != null) {
                blockList.explode(explodingEntity, event.blockList());
            }
        } else if (blockList != null) {
            blockList.explode(explodingEntity, event.blockList());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityFinalizeExplode(EntityExplodeEvent event) {
        Entity explodingEntity = event.getEntity();
        if (explodingEntity == null) {
            return;
        }
        UndoList blockList = this.controller.getEntityUndo(explodingEntity);
        if (blockList == null) {
            return;
        }
        if (event.isCancelled()) {
            blockList.cancelExplosion(explodingEntity);
        } else {
            blockList.finalizeExplosion(explodingEntity, event.blockList());
        }
    }
}

