/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.entity.EntityExtraData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.ItemStack;

public class EntityHorseData
extends EntityExtraData {
    public Horse.Color color;
    public Horse.Variant variant;
    public Horse.Style style;
    public ItemStack saddle;
    public ItemStack armor;
    public int domestication;
    public int maxDomestication;
    public double jumpStrength;

    public EntityHorseData() {
    }

    public EntityHorseData(Horse horse) {
        this.color = horse.getColor();
        this.variant = horse.getVariant();
        this.style = horse.getStyle();
        this.saddle = horse.getInventory().getSaddle();
        this.armor = horse.getInventory().getArmor();
        this.domestication = horse.getDomestication();
        this.maxDomestication = horse.getMaxDomestication();
        this.jumpStrength = horse.getJumpStrength();
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Horse)) {
            return;
        }
        Horse horse = (Horse)entity;
        horse.setColor(this.color);
        horse.setVariant(this.variant);
        horse.setStyle(this.style);
        horse.getInventory().setSaddle(this.saddle);
        horse.getInventory().setArmor(this.armor);
        horse.setDomestication(this.domestication);
        horse.setMaxDomestication(this.maxDomestication);
        horse.setJumpStrength(this.jumpStrength);
    }

    @Override
    public EntityExtraData clone() {
        EntityHorseData copy = new EntityHorseData();
        copy.saddle = this.saddle == null ? null : this.saddle.clone();
        copy.armor = this.armor == null ? null : this.armor.clone();
        copy.color = this.color;
        copy.variant = this.variant;
        copy.domestication = this.domestication;
        copy.style = this.style;
        copy.maxDomestication = this.maxDomestication;
        copy.jumpStrength = this.jumpStrength;
        return copy;
    }

    @Override
    public void removed(Entity entity) {
    }
}

