/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.data.ConfigurationMageDataStore;
import com.elmakers.mine.bukkit.utilities.YamlDataFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.multiverse.io.FilenameUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class YamlMageDataStore
extends ConfigurationMageDataStore {
    private File playerDataFolder;
    private File migratedDataFolder;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        super.initialize(controller, configuration);
        Plugin plugin = controller.getPlugin();
        String playerFolder = configuration.getString("folder", "players");
        String migrateFolder = configuration.getString("migration_folder", "migrated");
        this.playerDataFolder = new File(plugin.getDataFolder(), playerFolder);
        this.playerDataFolder.mkdirs();
        this.migratedDataFolder = new File(plugin.getDataFolder(), migrateFolder);
    }

    @Override
    public void save(MageData mage) {
        File playerData = new File(this.playerDataFolder, mage.getId() + ".dat");
        YamlDataFile saveFile = new YamlDataFile(this.controller.getLogger(), playerData);
        this.save(mage, (ConfigurationSection)saveFile);
        saveFile.save();
    }

    @Override
    public MageData load(String id) {
        File playerFile = new File(this.playerDataFolder, id + ".dat");
        if (!playerFile.exists()) {
            return null;
        }
        YamlConfiguration saveFile = YamlConfiguration.loadConfiguration((File)playerFile);
        return this.load(id, (ConfigurationSection)saveFile);
    }

    @Override
    public void delete(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            playerData.delete();
        }
    }

    @Override
    public Collection<String> getAllIds() {
        File[] files;
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : files = this.playerDataFolder.listFiles()) {
            ids.add(FilenameUtils.removeExtension((String)file.getName()));
        }
        return ids;
    }

    @Override
    public void migrate(String id) {
        File playerData = new File(this.playerDataFolder, id + ".dat");
        if (playerData.exists()) {
            this.migratedDataFolder.mkdir();
            File migratedData = new File(this.migratedDataFolder, id + ".dat.migrated");
            playerData.renameTo(migratedData);
        }
    }
}

