/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.BlockComparator;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.entity.EntityData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    public static Set<Material> attachables;
    public static Set<Material> attachablesWall;
    public static Set<Material> attachablesDouble;
    protected static Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> modified;
    protected static Map<Long, Double> reflective;
    protected static Map<Long, Double> breakable;
    protected static BlockComparator blockComparator;
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> attached;
    private boolean loading = false;
    protected List<WeakReference<Entity>> entities;
    protected List<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected WeakReference<CastContext> context;
    protected Mage owner;
    protected Plugin plugin;
    protected boolean undone = false;
    protected int timeToLive = 0;
    protected boolean applyPhysics = false;
    protected boolean bypass = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected double speed = 0.0;
    protected Spell spell;
    protected Batch batch;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean undoEntityEffects = true;
    private Set<EntityType> undoEntityTypes = null;
    protected boolean undoBreakable = false;
    protected boolean undoReflective = false;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(Mage mage) {
        this.setMage(mage);
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public void setMage(Mage mage) {
        this.owner = mage;
        if (mage != null) {
            this.plugin = mage.getController().getPlugin();
        }
    }

    @Override
    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    @Override
    public void setSpell(Spell spell) {
        this.spell = spell;
        this.context = spell == null ? null : new WeakReference<CastContext>(spell.getCurrentCast());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    public boolean isComplete() {
        return this.undone;
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.updateScheduledUndo();
    }

    @Override
    public void updateScheduledUndo() {
        if (this.timeToLive > 0) {
            this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
        }
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean contains(Block block) {
        if (this.blockIdMap == null) {
            return false;
        }
        Long blockId = BlockData.getBlockId(block);
        if (this.attached != null && this.attached.containsKey(blockId)) {
            return false;
        }
        return this.blockIdMap.contains(blockId);
    }

    @Override
    public boolean contains(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.blockIdMap == null || blockData == null) {
            return false;
        }
        Long blockId = blockData.getId();
        if (this.attached != null && this.attached.containsKey(blockId)) {
            return false;
        }
        return this.blockIdMap.contains(blockData.getId());
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        if (this.bypass) {
            return true;
        }
        if (!super.add(blockData)) {
            return false;
        }
        this.modifiedTime = System.currentTimeMillis();
        UndoList.register(blockData);
        blockData.setUndoList(this);
        if (this.loading) {
            return true;
        }
        if (this.attached != null) {
            this.attached.remove(blockData.getId());
        }
        this.addAttachable(blockData, BlockFace.NORTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.SOUTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.EAST, attachablesWall);
        this.addAttachable(blockData, BlockFace.WEST, attachablesWall);
        this.addAttachable(blockData, BlockFace.UP, attachables);
        this.addAttachable(blockData, BlockFace.DOWN, attachables);
        return true;
    }

    protected boolean addAttachable(com.elmakers.mine.bukkit.api.block.BlockData block, BlockFace direction, Set<Material> materials) {
        BlockData newBlock;
        Block testBlock = block.getBlock().getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (this.blockIdMap != null && this.blockIdMap.contains(blockId)) {
            return false;
        }
        if (this.attached != null && this.attached.containsKey(blockId)) {
            return false;
        }
        Material material = testBlock.getType();
        if ((material.isBurnable() || materials != null && materials.contains(material)) && super.add(newBlock = new BlockData(testBlock))) {
            UndoList.register(newBlock);
            newBlock.setUndoList(this);
            if (this.attached == null) {
                this.attached = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
            }
            this.attached.put(blockId, newBlock);
            if (attachablesDouble != null && attachablesDouble.contains(material)) {
                if (direction != BlockFace.UP) {
                    this.addAttachable(newBlock, BlockFace.DOWN, materials);
                } else if (direction != BlockFace.DOWN) {
                    this.addAttachable(newBlock, BlockFace.UP, materials);
                }
            }
            return true;
        }
        return false;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData register(Block block) {
        BlockData blockData = new BlockData(block);
        UndoList.register(blockData);
        return blockData;
    }

    public static void register(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = modified.get(blockData.getId());
        if (priorState != null) {
            priorState.setNextState(blockData);
            blockData.setPriorState(priorState);
        }
        modified.put(blockData.getId(), blockData);
    }

    @Override
    public void commit() {
        this.unlink();
        if (this.blockList == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockList) {
            UndoList.commit(block);
        }
    }

    public static void commitAll() {
        Collection<com.elmakers.mine.bukkit.api.block.BlockData> blocks = modified.values();
        modified.clear();
        for (com.elmakers.mine.bukkit.api.block.BlockData block : blocks) {
            block.commit();
        }
    }

    public static void commit(com.elmakers.mine.bukkit.api.block.BlockData block) {
        modified.remove(block.getId());
        com.elmakers.mine.bukkit.api.block.BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            modified.remove(block.getId());
        }
        block.commit();
        reflective.remove(block.getId());
        breakable.remove(block.getId());
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)o;
            UndoList.removeFromModified(block, block.getPriorState());
        }
        return super.remove(o);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        com.elmakers.mine.bukkit.api.block.BlockData currentState = modified.get(block.getId());
        if (currentState == block) {
            if (priorState == null) {
                modified.remove(block.getId());
            } else {
                modified.put(block.getId(), priorState);
            }
        }
    }

    public com.elmakers.mine.bukkit.api.block.BlockData undoNext(boolean applyPhysics) {
        if (this.blockList.size() == 0) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.BlockData blockData = (com.elmakers.mine.bukkit.api.block.BlockData)this.blockList.getFirst();
        if (this.undo(blockData, applyPhysics)) {
            this.blockList.removeFirst();
            return blockData;
        }
        return null;
    }

    public boolean undo(com.elmakers.mine.bukkit.api.block.BlockData undoBlock, boolean applyPhysics) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = undoBlock.getPriorState();
        if (this.undoBreakable) {
            breakable.remove(undoBlock.getId());
        }
        if (this.undoReflective) {
            reflective.remove(undoBlock.getId());
        }
        if (undoBlock.undo(applyPhysics)) {
            UndoList.removeFromModified(undoBlock, priorState);
            return true;
        }
        return false;
    }

    public void undoEntityEffects() {
        if (this.entities != null || this.modifiedEntities != null) {
            if (this.entities != null) {
                for (WeakReference<Entity> entityReference : this.entities) {
                    Entity entity = (Entity)entityReference.get();
                    if (entity == null || !entity.isValid()) continue;
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (EntityData data : this.modifiedEntities.values()) {
                    if (!this.undoEntityEffects && this.undoEntityTypes != null && !this.undoEntityTypes.contains(data.getType())) continue;
                    data.undo();
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        if (this.spell != null) {
            this.spell.cancel();
        }
        if (this.batch != null && !this.batch.isFinished()) {
            this.batch.finish();
        }
        this.undo(blocking, true);
        if (this.isScheduled()) {
            this.owner.getController().cancelScheduledUndo(this);
        }
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
    }

    @Override
    public void undoScheduled() {
        this.undoScheduled(false);
    }

    public void unregisterAttached() {
        if (this.attached != null) {
            for (com.elmakers.mine.bukkit.api.block.BlockData block : this.attached.values()) {
                UndoList.removeFromModified(block, block.getPriorState());
                block.unlink();
            }
            this.attached = null;
        }
    }

    public void undo(boolean blocking, boolean undoEntities) {
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        if (this.isComplete()) {
            return;
        }
        this.undone = true;
        CastContext context = this.getContext();
        if (context != null) {
            context.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            this.undoEntityEffects();
            return;
        }
        UndoBatch batch = new UndoBatch(this);
        if (blocking) {
            while (!batch.isFinished()) {
                batch.process(1000);
            }
        } else {
            this.owner.addUndoBatch(batch);
        }
    }

    @Override
    public void load(ConfigurationSection node) {
        this.loading = true;
        super.load(node);
        this.loading = false;
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        this.applyPhysics = node.getBoolean("apply_physics", this.applyPhysics);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        node.set("apply_physics", (Object)this.applyPhysics);
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this));
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities == null) {
            this.entities = new ArrayList<WeakReference<Entity>>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(new WeakReference<Entity>(entity));
        if (this.isScheduled()) {
            entity.setMetadata("temporary", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new LinkedList<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null || entity.hasMetadata("notarget")) {
            return entityData;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return entityData;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        UUID entityId = entity.getUniqueId();
        if (this.entities != null && this.entities.contains(entityId) && !entity.isValid()) {
            this.entities.remove(entityId);
        } else {
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entityId)) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entityId, entityData);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    @Override
    public EntityData damage(Entity entity, double damage) {
        EntityData data = this.modify(entity);
        if (this.undoEntityTypes != null && this.undoEntityTypes.contains(entity.getType())) {
            data.removed(entity);
            entity.remove();
        }
        return data;
    }

    @Override
    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    @Override
    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    @Override
    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void remove(Entity entity) {
        UUID entityId = entity.getUniqueId();
        if (this.entities != null && this.entities.contains(entityId)) {
            this.entities.remove(entityId);
        }
        if (this.modifiedEntities != null && this.modifiedEntities.containsKey(entityId)) {
            this.entities.remove(entityId);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        if (this.entities != null) {
            this.entities.remove(fallingBlock);
        }
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void finalizeExplosion(Entity explodingEntity, List<Block> blocks) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
        }
        if (this.isScheduled()) {
            for (Block block : blocks) {
                BlockState state = block.getState();
                if (state instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)state;
                    holder.getInventory().clear();
                    state.update();
                }
                block.setType(Material.AIR);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        if (this.entities != null) {
            this.entities.remove(explodingEntity);
            this.modifiedTime = System.currentTimeMillis();
        }
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        ArrayList current = new ArrayList(this.blockList);
        this.blockList = null;
        this.blockIdMap = null;
        for (com.elmakers.mine.bukkit.api.block.BlockData block : current) {
            if (block.isDifferent()) {
                super.add(block);
                continue;
            }
            UndoList.removeFromModified(block, block.getPriorState());
            block.unlink();
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }

    @Override
    public CastContext getContext() {
        return this.context == null ? null : (CastContext)this.context.get();
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return (int)(this.scheduledTime - o.getScheduledTime());
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    @Override
    public void setEntityUndoTypes(Set<EntityType> undoTypes) {
        this.undoEntityTypes = undoTypes;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    @Override
    public void setApplyPhysics(boolean applyPhysics) {
        this.applyPhysics = applyPhysics;
    }

    @Override
    public boolean getApplyPhysics() {
        return this.applyPhysics;
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Entity entity) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity != null && entity.hasMetadata("MagicBlockList")) {
            List values = entity.getMetadata("MagicBlockList");
            for (MetadataValue metadataValue : values) {
                Object value = metadataValue.value();
                if (!(value instanceof com.elmakers.mine.bukkit.api.block.UndoList)) continue;
                blockList = (com.elmakers.mine.bukkit.api.block.UndoList)value;
            }
        }
        return blockList;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        return modified.get(BlockData.getBlockId(location.getBlock()));
    }

    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Location location) {
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        com.elmakers.mine.bukkit.api.block.BlockData modifiedBlock = modified.get(BlockData.getBlockId(location.getBlock()));
        if (modifiedBlock != null) {
            blockList = modifiedBlock.getUndoList();
        }
        return blockList;
    }

    public static Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> getModified() {
        return modified;
    }

    public static Map<Long, Double> getReflective() {
        return reflective;
    }

    public static Map<Long, Double> getBreakable() {
        return breakable;
    }

    @Override
    public void setUndoBreakable(boolean breakable) {
        this.undoBreakable = breakable;
    }

    @Override
    public void setUndoReflective(boolean reflective) {
        this.undoReflective = reflective;
    }

    @Override
    public Collection<Entity> getAllEntities() {
        Entity entity;
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.entities != null) {
            for (WeakReference<Entity> entityReference : this.entities) {
                entity = (Entity)entityReference.get();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        if (this.modifiedEntities != null) {
            for (EntityData entityData : this.modifiedEntities.values()) {
                entity = entityData.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public void sort(Set<Material> attachables) {
        if (this.blockList == null) {
            return;
        }
        Collections.reverse(this.blockList);
        if (attachables == null) {
            return;
        }
        blockComparator.setAttachables(attachables);
        Collections.sort(this.blockList, blockComparator);
    }

    public static boolean isReflective(Block block) {
        return block != null && reflective.containsKey(BlockData.getBlockId(block));
    }

    public static boolean isBreakable(Block block) {
        return block != null && breakable.containsKey(BlockData.getBlockId(block));
    }

    public static Double getReflective(Block block) {
        return block == null ? null : reflective.get(BlockData.getBlockId(block));
    }

    public static Double getBreakable(Block block) {
        return block == null ? null : breakable.get(BlockData.getBlockId(block));
    }

    public static void registerReflective(Block block, double amount) {
        if (block == null) {
            return;
        }
        reflective.put(BlockData.getBlockId(block), amount);
    }

    public static void registerBreakable(Block block, double amount) {
        if (block == null) {
            return;
        }
        breakable.put(BlockData.getBlockId(block), amount);
    }

    public static void unregisterBreakable(Block block) {
        if (block == null) {
            return;
        }
        breakable.remove(BlockData.getBlockId(block));
    }

    public static void unregisterReflective(Block block) {
        if (block == null) {
            return;
        }
        reflective.remove(BlockData.getBlockId(block));
    }

    public double getUndoSpeed() {
        return this.speed;
    }

    public void setUndoSpeed(double speed) {
        this.speed = speed;
    }

    static {
        modified = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
        reflective = new HashMap<Long, Double>();
        breakable = new HashMap<Long, Double>();
        blockComparator = new BlockComparator();
    }
}

