/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileAction
extends BaseProjectileAction {
    private int defaultSize = 1;
    private int count;
    private int size;
    private double damage;
    private float speed;
    private float spread;
    private boolean useFire;
    private boolean breakBlocks;
    private int tickIncrease;
    private String projectileTypeName;
    private int startDistance;
    private boolean useWandLocation;
    private boolean useEyeLocation;
    private boolean useTargetLocation;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.breakBlocks = parameters.getBoolean("break_blocks", false);
        this.useFire = parameters.getBoolean("fire", false);
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.useFire;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.breakBlocks;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.track = true;
        super.prepare(context, parameters);
        this.count = parameters.getInt("count", 1);
        this.size = parameters.getInt("size", this.defaultSize);
        this.damage = parameters.getDouble("damage", 0.0);
        this.speed = (float)parameters.getDouble("speed", (double)0.6f);
        this.spread = (float)parameters.getDouble("spread", 12.0);
        this.useFire = parameters.getBoolean("fire", false);
        this.tickIncrease = parameters.getInt("tick_increase", 1180);
        this.projectileTypeName = parameters.getString("projectile", "Arrow");
        this.breakBlocks = parameters.getBoolean("break_blocks", false);
        this.startDistance = parameters.getInt("start", 0);
        this.useWandLocation = parameters.getBoolean("use_wand_location", true);
        this.useEyeLocation = parameters.getBoolean("use_eye_location", true);
        this.useTargetLocation = parameters.getBoolean("use_target_location", true);
    }

    @Override
    public SpellResult start(CastContext context) {
        MageController controller = context.getController();
        Mage mage = context.getMage();
        int size = (int)(mage.getRadiusMultiplier() * (float)this.size);
        float damageMultiplier = mage.getDamageMultiplier();
        double damage = (double)damageMultiplier * this.damage;
        float spread = this.spread / damageMultiplier;
        Random random = context.getRandom();
        Class<?> projectileType = NMSUtils.getBukkitClass("net.minecraft.server.Entity" + this.projectileTypeName);
        if (!CompatibilityUtils.isValidProjectileClass(projectileType)) {
            controller.getLogger().warning("Bad projectile class: " + this.projectileTypeName);
            return SpellResult.FAIL;
        }
        Location location = this.useWandLocation ? context.getWandLocation() : (this.useEyeLocation ? context.getEyeLocation() : context.getLocation());
        Location targetLocation = context.getTargetLocation();
        Vector direction = targetLocation != null && this.useTargetLocation ? targetLocation.toVector().subtract(location.toVector()).normalize() : context.getDirection().clone().normalize();
        if (this.startDistance > 0) {
            location = location.clone().add(direction.clone().multiply(this.startDistance));
        }
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        LivingEntity shootingEntity = context.getLivingEntity();
        LivingEntity source = null;
        if (shootingEntity != null && shootingEntity instanceof ProjectileSource) {
            source = shootingEntity;
        }
        for (int i = 0; i < this.count; ++i) {
            try {
                Bukkit.getLogger().info("Spawning projectile " + i + " of " + this.count);
                Projectile projectile = CompatibilityUtils.spawnProjectile(projectileType, location, direction, (ProjectileSource)source, this.speed, spread, i > 0 ? spread : 0.0f, random);
                if (projectile == null) {
                    return SpellResult.FAIL;
                }
                if (shootingEntity != null) {
                    projectile.setShooter((ProjectileSource)shootingEntity);
                }
                projectiles.add(projectile);
                if (projectile instanceof Fireball) {
                    Fireball fireball = (Fireball)projectile;
                    fireball.setIsIncendiary(this.useFire);
                    fireball.setYield((float)size);
                }
                if (projectile instanceof Arrow) {
                    Arrow arrow = (Arrow)projectile;
                    if (this.useFire) {
                        arrow.setFireTicks(300);
                    }
                    CompatibilityUtils.makeInfinite(projectile);
                    if (damage > 0.0) {
                        CompatibilityUtils.setDamage(projectile, damage);
                    }
                    if (this.tickIncrease > 0) {
                        CompatibilityUtils.decreaseLifespan(projectile, this.tickIncrease);
                    }
                }
                if (!this.breakBlocks) {
                    projectile.setMetadata("cancel_explosion", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
                }
                this.track(context, (Entity)projectile);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.checkTracking(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("count");
        parameters.add("size");
        parameters.add("damage");
        parameters.add("speed");
        parameters.add("spread");
        parameters.add("start");
        parameters.add("projectile");
        parameters.add("fire");
        parameters.add("tick_increase");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("undo_interval")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("count") || parameterKey.equals("size") || parameterKey.equals("speed") || parameterKey.equals("spread") || parameterKey.equals("tick_increase") || parameterKey.equals("damage") || parameterKey.equals("start")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("fire")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("projectile")) {
            examples.add("LargeFireball");
            examples.add("SmallFireball");
            examples.add("WitherSkull");
            examples.add("Arrow");
            examples.add("Snowball");
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

