/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ModifyBlockAction
extends BaseSpellAction {
    private boolean spawnFallingBlocks;
    private double fallingBlockSpeed;
    private Vector fallingBlockDirection;
    private float fallingBlockFallDamage;
    private int fallingBlockMaxDamage;
    private double fallingProbability;
    private double breakable = 0.0;
    private double backfireChance = 0.0;
    private boolean applyPhysics = false;
    private boolean commit = false;
    private boolean usePhysicsBlocks = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.spawnFallingBlocks = parameters.getBoolean("falling", false);
        this.applyPhysics = parameters.getBoolean("physics", false);
        this.commit = parameters.getBoolean("commit", false);
        this.usePhysicsBlocks = parameters.getBoolean("physics_blocks", false);
        this.breakable = parameters.getDouble("breakable", 0.0);
        this.backfireChance = parameters.getDouble("reflect_chance", 0.0);
        this.fallingBlockSpeed = parameters.getDouble("speed", 0.0);
        this.fallingProbability = parameters.getDouble("falling_probability", 1.0);
        this.fallingBlockDirection = null;
        if (this.spawnFallingBlocks && parameters.contains("direction")) {
            if (this.fallingBlockSpeed == 0.0) {
                this.fallingBlockSpeed = 1.0;
            }
            this.fallingBlockDirection = ConfigurationUtils.getVector(parameters, "direction");
        }
        int damage = parameters.getInt("damage", 0);
        this.fallingBlockFallDamage = (float)parameters.getDouble("fall_damage", (double)damage);
        this.fallingBlockMaxDamage = parameters.getInt("max_damage", damage);
    }

    @Override
    public SpellResult perform(CastContext context) {
        boolean spawnFalling;
        MaterialBrush brush = context.getBrush();
        if (brush == null) {
            return SpellResult.FAIL;
        }
        Block block = context.getTargetBlock();
        if (brush.isErase() ? !context.hasBreakPermission(block) : !context.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.commit ? !context.areAnyDestructible(block) : !context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        Material previousMaterial = block.getType();
        byte previousData = block.getData();
        Mage mage = context.getMage();
        brush.update(mage, context.getTargetSourceLocation());
        if (!brush.isDifferent(block)) {
            return SpellResult.NO_TARGET;
        }
        if (!this.commit) {
            context.registerForUndo(block);
        }
        if (!brush.isReady()) {
            brush.prepare();
            return SpellResult.PENDING;
        }
        brush.modify(block, this.applyPhysics);
        boolean bl = spawnFalling = this.spawnFallingBlocks && previousMaterial != Material.AIR;
        if (spawnFalling && this.fallingProbability < 1.0) {
            boolean bl2 = spawnFalling = context.getRandom().nextDouble() < this.fallingProbability;
        }
        if (spawnFalling) {
            Location blockLocation = block.getLocation();
            Location blockCenter = new Location(blockLocation.getWorld(), blockLocation.getX() + 0.5, blockLocation.getY() + 0.5, blockLocation.getZ() + 0.5);
            Vector fallingBlockVelocity = null;
            if (this.fallingBlockSpeed > 0.0) {
                Location source = context.getTargetCenterLocation();
                fallingBlockVelocity = blockCenter.clone().subtract(source).toVector();
                fallingBlockVelocity.normalize();
                if (this.fallingBlockDirection != null) {
                    fallingBlockVelocity.add(this.fallingBlockDirection).normalize();
                }
                fallingBlockVelocity.multiply(this.fallingBlockSpeed);
            }
            if (fallingBlockVelocity != null && (Double.isNaN(fallingBlockVelocity.getX()) || Double.isNaN(fallingBlockVelocity.getY()) || Double.isNaN(fallingBlockVelocity.getZ()) || Double.isInfinite(fallingBlockVelocity.getX()) || Double.isInfinite(fallingBlockVelocity.getY()) || Double.isInfinite(fallingBlockVelocity.getZ()))) {
                fallingBlockVelocity = null;
            }
            boolean spawned = false;
            if (this.usePhysicsBlocks) {
                spawned = context.getController().spawnPhysicsBlock(blockCenter, previousMaterial, previousData, fallingBlockVelocity);
            }
            if (!spawned) {
                FallingBlock falling = block.getWorld().spawnFallingBlock(blockLocation, previousMaterial, previousData);
                falling.setDropItem(false);
                if (fallingBlockVelocity != null) {
                    falling.setVelocity(fallingBlockVelocity);
                }
                if (this.fallingBlockMaxDamage > 0 && this.fallingBlockFallDamage > 0.0f) {
                    CompatibilityUtils.setFallingBlockDamage(falling, this.fallingBlockFallDamage, this.fallingBlockMaxDamage);
                }
                context.registerForUndo((Entity)falling);
            }
        }
        if (this.breakable > 0.0) {
            context.registerBreakable(block, this.breakable);
        }
        if (this.backfireChance > 0.0) {
            context.registerReflective(block, this.backfireChance);
        }
        if (this.commit) {
            BlockData blockData = UndoList.register(block);
            blockData.commit();
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("falling");
        parameters.add("speed");
        parameters.add("direction");
        parameters.add("reflect_chance");
        parameters.add("breakable");
        parameters.add("physics");
        parameters.add("commit");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("falling") || parameterKey.equals("physics") || parameterKey.equals("commit")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("speed") || parameterKey.equals("breakable")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("direction")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("reflect_chance")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean usesBrush() {
        return true;
    }
}

