/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class CommandAction
extends BaseSpellAction {
    public static final String[] PARAMETERS = new String[]{"command", "console", "op"};
    private List<String> commands = new ArrayList<String>();
    private boolean asConsole;
    private boolean opPlayer;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.asConsole = parameters.getBoolean("console", false);
        this.opPlayer = parameters.getBoolean("op", false);
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.commands.clear();
        if (parameters.contains("command")) {
            String command = parameters.getString("command");
            if (command != null && command.length() > 0) {
                this.commands.add(command);
            }
        } else {
            this.commands.addAll(parameters.getStringList("commands"));
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        ConsoleCommandSender sender;
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Object object = sender = this.asConsole ? Bukkit.getConsoleSender() : mage.getCommandSender();
        if (sender == null) {
            return SpellResult.FAIL;
        }
        boolean isOp = sender.isOp();
        if (this.opPlayer && !isOp) {
            sender.setOp(true);
        }
        for (String command : this.commands) {
            try {
                String converted = context.parameterize(command);
                controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, converted);
            }
            catch (Exception ex) {
                controller.getLogger().log(Level.WARNING, "Error running command: " + command, ex);
            }
        }
        if (this.opPlayer && !isOp) {
            sender.setOp(false);
        }
        return SpellResult.CAST;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.addAll(Arrays.asList(PARAMETERS));
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("command")) {
            examples.add("spawn");
            examples.add("clear");
        } else if (parameterKey.equals("op") || parameterKey.equals("console")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

