/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class ChangeWorldAction
extends BaseTeleportAction {
    private String targetWorldMessage = "";
    private Location targetLocation = null;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        World world = context.getWorld();
        Location playerLocation = context.getLocation();
        this.targetLocation = null;
        if (world == null) {
            return;
        }
        String worldName = world.getName();
        if (parameters.contains("target_world")) {
            World targetWorld = this.getWorld(context, parameters.getString("target_world"), parameters.getBoolean("load", true), null);
            if (targetWorld == null) {
                return;
            }
            if (targetWorld.getEnvironment() == World.Environment.THE_END) {
                this.targetLocation = targetWorld.getSpawnLocation();
            } else {
                double scale = parameters.getDouble("scale", 1.0);
                this.targetLocation = new Location(targetWorld, playerLocation.getX() * scale, playerLocation.getY(), playerLocation.getZ() * scale);
            }
        } else if (parameters.contains("worlds")) {
            ConfigurationSection worldMap = parameters.getConfigurationSection("worlds");
            if (worldMap == null || !worldMap.contains(worldName)) {
                return;
            }
            ConfigurationSection worldNode = worldMap.getConfigurationSection(worldName);
            World targetWorld = this.getWorld(context, worldNode.getString("target"), worldNode.getBoolean("load", true), (World)(worldNode.getBoolean("copy", false) ? world : null));
            if (targetWorld != null) {
                double scale = worldNode.getDouble("scale", 1.0);
                this.targetLocation = new Location(targetWorld, playerLocation.getX() * scale, playerLocation.getY(), playerLocation.getZ() * scale);
            }
        } else if (worldName.contains("_the_end")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_the_end", "")));
            if (targetWorld != null) {
                this.targetLocation = targetWorld.getSpawnLocation();
            }
        } else if (worldName.contains("_nether")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_nether", "")));
            if (targetWorld != null) {
                this.targetLocation = new Location(targetWorld, playerLocation.getX() * 8.0, playerLocation.getY(), playerLocation.getZ() * 8.0);
            }
        } else {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName + "_nether"));
            if (targetWorld != null) {
                this.targetLocation = new Location(targetWorld, playerLocation.getX() / 8.0, Math.min(125.0, playerLocation.getY()), playerLocation.getZ() / 8.0);
            }
        }
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public SpellResult perform(CastContext context) {
        LivingEntity entity;
        Entity e = context.getTargetEntity();
        LivingEntity livingEntity = entity = e != null && e instanceof LivingEntity ? (LivingEntity)e : null;
        if (entity == null) {
            return SpellResult.NO_TARGET;
        }
        Location playerLocation = entity.getLocation();
        if (this.targetLocation == null) {
            return SpellResult.NO_TARGET;
        }
        this.targetLocation.setX(Math.min(this.targetLocation.getX(), 3.0E7));
        this.targetLocation.setZ(Math.min(this.targetLocation.getZ(), 3.0E7));
        this.targetLocation.setYaw(playerLocation.getYaw());
        this.targetLocation.setPitch(playerLocation.getPitch());
        this.setTargetWorldName(context, this.targetLocation.getWorld().getName());
        context.teleport((Entity)entity, this.targetLocation, this.verticalSearchDistance);
        return SpellResult.CAST;
    }

    protected World getWorld(CastContext context, String worldName, boolean loadWorld, World copyFrom) {
        World world = Bukkit.getWorld((String)worldName);
        if (world == null && loadWorld) {
            if (copyFrom != null) {
                context.getLogger().info("Creating world: " + worldName + " as copy of " + copyFrom.getName());
                world = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName).copy(copyFrom));
            } else {
                context.getLogger().info("Loading world: " + worldName);
                world = Bukkit.createWorld((WorldCreator)new WorldCreator(worldName));
            }
        }
        if (world == null) {
            Bukkit.getLogger().warning("Could not load world: " + worldName);
        }
        return world;
    }

    protected void setTargetWorldName(CastContext context, String worldName) {
        Messages messages = context.getController().getMessages();
        this.targetWorldMessage = messages.get("worlds." + worldName + ".name", worldName);
    }

    @Override
    public String transformMessage(String message) {
        return message.replace("$world_name", this.targetWorldMessage);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("target_world");
        parameters.add("load");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("target_world")) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        } else if (parameterKey.equals("load")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

