/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.action.SpellAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public abstract class CompoundAction
extends BaseSpellAction {
    private boolean usesBrush = false;
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    private boolean requiresBreakPermission = false;
    protected ConfigurationSection actionConfiguration;
    protected com.elmakers.mine.bukkit.api.action.CastContext actionContext;
    protected Map<String, ActionHandler> handlers = new HashMap<String, ActionHandler>();
    protected String currentHandler = null;
    protected State state = State.NOT_STARTED;

    public SpellResult step(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return SpellResult.NO_ACTION;
    }

    public SpellResult start(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return SpellResult.NO_ACTION;
    }

    public boolean next(com.elmakers.mine.bukkit.api.action.CastContext context) {
        return false;
    }

    protected SpellResult startActions() {
        return this.startActions("actions");
    }

    protected SpellResult startActions(String handlerKey) {
        this.currentHandler = handlerKey;
        ActionHandler handler = this.handlers.get(this.currentHandler);
        if (handler != null) {
            handler.reset(this.actionContext);
        } else {
            this.currentHandler = null;
        }
        return SpellResult.NO_ACTION;
    }

    public boolean hasActions() {
        return this.hasActions("actions");
    }

    public boolean hasActions(String key) {
        ActionHandler handler = this.handlers.get(key);
        return handler != null && handler.size() > 0;
    }

    @Override
    public SpellResult perform(com.elmakers.mine.bukkit.api.action.CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        while (!result.isStop()) {
            ActionHandler handler;
            if (this.state == State.NOT_STARTED) {
                if ((result = result.min(this.start(context))).isStop() || result.isFailure()) break;
                this.state = State.STARTED;
            }
            if (this.state == State.STARTED) {
                if ((result = result.min(this.step(context))).isStop()) break;
                this.state = State.STEPPING;
            }
            ActionHandler actionHandler = handler = this.currentHandler == null ? null : this.handlers.get(this.currentHandler);
            if (handler != null && (result = result.min(handler.perform(this.actionContext))).isStop()) break;
            this.currentHandler = null;
            if (!this.next(context)) {
                if (handler == null) break;
                handler.finish(this.actionContext);
                break;
            }
            result = result.min(this.step(context));
        }
        return result;
    }

    @Override
    public void reset(com.elmakers.mine.bukkit.api.action.CastContext context) {
        super.reset(context);
        if (context != null) {
            this.actionContext = new CastContext(context);
        }
        this.state = State.NOT_STARTED;
        this.currentHandler = null;
    }

    @Override
    public void prepare(com.elmakers.mine.bukkit.api.action.CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        for (ActionHandler handler : this.handlers.values()) {
            handler.prepare(context, parameters);
        }
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.actionConfiguration = parameters;
        this.usesBrush = false;
        this.undoable = false;
        this.requiresBuildPermission = false;
        this.requiresBreakPermission = false;
        this.addHandlers(spell, parameters);
        for (ActionHandler handler : this.handlers.values()) {
            handler.initialize(spell, this.actionConfiguration);
            this.updateFlags(handler);
        }
    }

    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        this.addHandler("actions");
    }

    protected ActionHandler addHandler(String handlerKey) {
        ActionHandler handler = this.handlers.get(handlerKey);
        if (handler != null) {
            return handler;
        }
        handler = new ActionHandler();
        this.handlers.put(handlerKey, handler);
        if (this.actionConfiguration != null && this.actionConfiguration.contains(handlerKey)) {
            handler.load(this.actionConfiguration, handlerKey);
        }
        return handler;
    }

    protected void updateFlags(ActionHandler handler) {
        this.usesBrush = this.usesBrush || handler.usesBrush();
        this.undoable = this.undoable || handler.isUndoable();
        this.requiresBuildPermission = this.requiresBuildPermission || handler.requiresBuildPermission();
        this.requiresBreakPermission = this.requiresBreakPermission || handler.requiresBreakPermission();
    }

    public void addAction(SpellAction action) {
        this.addAction(action, null);
    }

    public void addAction(SpellAction action, ConfigurationSection parameters) {
        ActionHandler actions = this.addHandler("actions");
        if (actions == null) {
            actions = new ActionHandler();
        }
        actions.loadAction(action, parameters);
    }

    @Override
    public void load(Mage mage, ConfigurationSection data) {
        for (ActionHandler handler : this.handlers.values()) {
            handler.loadData(mage, data);
        }
    }

    @Override
    public void save(Mage mage, ConfigurationSection data) {
        for (ActionHandler handler : this.handlers.values()) {
            handler.saveData(mage, data);
        }
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.requiresBreakPermission;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        for (ActionHandler handler : this.handlers.values()) {
            handler.getParameterNames(spell, parameters);
        }
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        for (ActionHandler handler : this.handlers.values()) {
            handler.getParameterOptions(spell, parameterKey, examples);
        }
    }

    @Override
    public String transformMessage(String message) {
        for (ActionHandler handler : this.handlers.values()) {
            message = handler.transformMessage(message);
        }
        return message;
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation) {
        this.actionContext = new CastContext(context, sourceEntity, sourceLocation);
    }

    public void createActionContext(com.elmakers.mine.bukkit.api.action.CastContext context, Entity sourceEntity, Location sourceLocation, Entity targetEntity, Location targetLocation) {
        this.actionContext = new CastContext(context, sourceEntity, sourceLocation);
        this.actionContext.setTargetEntity(targetEntity);
        this.actionContext.setTargetLocation(targetLocation);
    }

    @Override
    public int getActionCount() {
        int actionCount = 0;
        for (ActionHandler handler : this.handlers.values()) {
            actionCount += handler.getActionCount();
        }
        return actionCount;
    }

    protected void skippedActions(com.elmakers.mine.bukkit.api.action.CastContext context) {
        this.skippedActions("actions", context);
    }

    protected void skippedActions(String key, com.elmakers.mine.bukkit.api.action.CastContext context) {
        ActionHandler actions = this.handlers.get(key);
        if (actions == null) {
            return;
        }
        int actionCount = actions.getActionCount();
        context.performedActions(actionCount);
        context.addWork(actionCount);
    }

    @Override
    public Object clone() {
        CompoundAction action = (CompoundAction)super.clone();
        if (action != null) {
            action.handlers = new HashMap<String, ActionHandler>();
            for (Map.Entry<String, ActionHandler> entry : this.handlers.entrySet()) {
                action.handlers.put(entry.getKey(), (ActionHandler)entry.getValue().clone());
            }
        }
        return action;
    }

    protected static enum State {
        NOT_STARTED,
        STARTED,
        STEPPING;

    }
}

