/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.io.File;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDataFile
extends YamlConfiguration {
    protected final File file;
    protected final Logger logger;

    public YamlDataFile(Logger logger, File file) {
        this.file = file;
        this.logger = logger;
    }

    public YamlDataFile(Logger logger, String filename) {
        this.file = new File(filename);
        this.logger = logger;
    }

    public void load() {
        try {
            this.load(this.file);
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
            this.logger.warning("Error loading data file " + this.file.getName());
        }
    }

    public void save() {
        try {
            File targetFile;
            File tempFile = new File(this.file.getAbsolutePath() + ".tmp");
            if (tempFile.exists()) {
                this.logger.warning("Temp file for " + this.file.getName() + "exists, deleting");
                tempFile.delete();
            }
            File backupFile = new File(this.file.getAbsolutePath() + ".bak");
            this.save(tempFile);
            if (backupFile.exists()) {
                backupFile.delete();
            }
            if ((targetFile = new File(this.file.getAbsolutePath())).exists()) {
                targetFile.renameTo(backupFile);
            }
            tempFile.renameTo(this.file);
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
            this.logger.warning("Error saving data file " + this.file.getName());
        }
    }

    public File getFile() {
        return this.file;
    }
}

