/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;

public class ActionSpell
extends BrushSpell {
    private Map<String, ActionHandler> actions = new HashMap<String, ActionHandler>();
    private boolean undoable = false;
    private boolean requiresBuildPermission = false;
    private boolean requiresBreakPermission = false;
    private ConfigurationSection upParameters = null;
    private ConfigurationSection downParameters = null;
    private ConfigurationSection sneakParameters = null;
    private ActionHandler currentHandler = null;
    private int workThreshold = 500;

    @Override
    protected void processResult(SpellResult result, ConfigurationSection castParameters) {
        ActionHandler handler;
        if (!result.isSuccess() && (handler = this.actions.get(result.name().toLowerCase())) != null) {
            handler.start(this.currentCast, castParameters);
        }
        super.processResult(result, castParameters);
    }

    @Override
    protected boolean isLegacy() {
        return false;
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        this.currentCast.setWorkAllowed(this.workThreshold);
        SpellResult result = SpellResult.CAST;
        this.currentHandler = this.actions.get("cast");
        ConfigurationSection altParameters = null;
        ActionHandler downHandler = this.actions.get("alternate_down");
        ActionHandler upHandler = this.actions.get("alternate_up");
        ActionHandler sneakHandler = this.actions.get("alternate_sneak");
        this.workThreshold = parameters.getInt("work_threshold", 500);
        if ((downHandler != null || this.downParameters != null) && this.isLookingDown()) {
            result = SpellResult.ALTERNATE_DOWN;
            if (downHandler != null) {
                this.currentHandler = downHandler;
            }
            altParameters = this.downParameters;
        } else if ((upHandler != null || this.upParameters != null) && this.isLookingUp()) {
            result = SpellResult.ALTERNATE_UP;
            if (upHandler != null) {
                this.currentHandler = upHandler;
            }
            altParameters = this.upParameters;
        } else if ((sneakHandler != null || this.sneakParameters != null) && this.mage.isSneaking()) {
            result = SpellResult.ALTERNATE_SNEAK;
            if (sneakHandler != null) {
                this.currentHandler = sneakHandler;
            }
            altParameters = this.sneakParameters;
        }
        if (this.isUndoable()) {
            this.getMage().prepareForUndo(this.getUndoList());
        }
        this.target();
        if (this.currentHandler != null) {
            this.currentHandler = (ActionHandler)this.currentHandler.clone();
            if (altParameters != null) {
                parameters = parameters == null ? altParameters : ConfigurationUtils.addConfigurations(parameters, altParameters);
            }
            try {
                result = result.max(this.currentHandler.start(this.currentCast, parameters));
                this.currentCast.setInitialResult(result);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Spell cast failed for " + this.getKey(), ex);
                result = SpellResult.FAIL;
                try {
                    this.currentHandler.finish(this.currentCast);
                }
                catch (Exception finishException) {
                    this.controller.getLogger().log(Level.WARNING, "Failed to clean up failed spell " + this.getKey(), finishException);
                }
            }
        }
        return result;
    }

    @Override
    public void onLoad(ConfigurationSection data) {
        super.onLoad(data);
        for (ActionHandler handler : this.actions.values()) {
            handler.loadData(this.getMage(), data);
        }
    }

    @Override
    public void onSave(ConfigurationSection data) {
        super.onSave(data);
        for (ActionHandler handler : this.actions.values()) {
            handler.saveData(this.getMage(), data);
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        this.castOnNoTarget = true;
        super.loadTemplate(template);
        this.usesBrush = false;
        this.undoable = false;
        this.requiresBuildPermission = false;
        this.requiresBreakPermission = false;
        this.upParameters = template.getConfigurationSection("alternate_up_parameters");
        this.downParameters = template.getConfigurationSection("alternate_down_parameters");
        this.sneakParameters = template.getConfigurationSection("alternate_sneak_parameters");
        if (template.contains("actions")) {
            ConfigurationSection parameters = template.getConfigurationSection("parameters");
            ConfigurationSection actionsNode = template.getConfigurationSection("actions");
            if (actionsNode != null) {
                Set actionKeys = actionsNode.getKeys(false);
                for (String actionKey : actionKeys) {
                    ActionHandler handler = new ActionHandler();
                    handler.load(actionsNode, actionKey);
                    handler.initialize(this, parameters);
                    this.usesBrush = this.usesBrush || handler.usesBrush();
                    this.undoable = this.undoable || handler.isUndoable();
                    this.requiresBuildPermission = this.requiresBuildPermission || handler.requiresBuildPermission();
                    this.requiresBreakPermission = this.requiresBreakPermission || handler.requiresBreakPermission();
                    this.actions.put(actionKey, handler);
                }
            }
        }
        this.undoable = template.getBoolean("undoable", this.undoable);
    }

    @Override
    public boolean isUndoable() {
        return this.undoable;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterNames(this, parameters);
        }
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        for (ActionHandler handler : this.actions.values()) {
            handler.getParameterOptions(this, parameterKey, examples);
        }
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        if (this.currentHandler != null) {
            message = this.currentHandler.transformMessage(message);
        }
        return message;
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.requiresBuildPermission;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.requiresBreakPermission;
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        if (!this.usesBrush) {
            return null;
        }
        return super.getEffectMaterial();
    }
}

