/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.Targeting;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class EntityController
implements Listener {
    private final MagicController controller;
    private boolean preventMeleeDamage = false;
    private boolean keepWandsOnDeath = true;
    private boolean disableItemSpawn = false;
    private boolean preventWandMeleeDamage = true;
    private int ageDroppedItems = 0;

    public EntityController(MagicController controller) {
        this.controller = controller;
    }

    public void setPreventMeleeDamage(boolean prevent) {
        this.preventMeleeDamage = prevent;
    }

    public void setKeepWandsOnDeath(boolean keep) {
        this.keepWandsOnDeath = keep;
    }

    public void setPreventWandMeleeDamage(boolean prevent) {
        this.preventWandMeleeDamage = prevent;
    }

    public void setDisableItemSpawn(boolean disable) {
        this.disableItemSpawn = disable;
    }

    public void setAgeDroppedItems(int age) {
        this.ageDroppedItems = age;
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        Targeting.checkTracking((Plugin)this.controller.getPlugin(), (Entity)projectile, null);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        UndoList undoList;
        Entity entity = event.getEntity();
        com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage(entity);
        if (apiMage != null && apiMage instanceof Mage) {
            Mage mage = (Mage)apiMage;
            mage.onPlayerCombust(event);
        }
        if (!event.isCancelled() && (undoList = this.controller.getPendingUndo(entity.getLocation())) != null) {
            undoList.modify(entity);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        Entity damager = event.getDamager();
        UndoList undoList = this.controller.getEntityUndo(damager);
        if (undoList != null) {
            if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK || undoList.isScheduled()) {
                undoList.damage(entity, event.getDamage());
                if (!entity.isValid()) {
                    event.setCancelled(true);
                }
            } else {
                undoList.modify(entity);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPreDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        com.elmakers.mine.bukkit.api.magic.Mage entityMage = this.controller.getRegisteredMage(entity);
        if (entityMage != null) {
            com.elmakers.mine.bukkit.api.wand.Wand damagedWand;
            Player damaged;
            if (entity instanceof Player && (damaged = (Player)entity).isBlocking() && (damagedWand = entityMage.getActiveWand()) != null) {
                damagedWand.playEffects("hit_blocked");
            }
            if (entityMage.isSuperProtected()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((damager = event.getDamager()) instanceof Player) {
            boolean isMelee;
            com.elmakers.mine.bukkit.api.magic.Mage damagerMage = this.controller.getRegisteredMage(damager);
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
            boolean bl = isMelee = event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && !CompatibilityUtils.isDamaging;
            if (isMelee && damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
                activeWand.playEffects("hit_entity");
                activeWand.damageDealt(event.getDamage(), entity);
            }
            if (this.preventWandMeleeDamage) {
                boolean hasWand = activeWand != null;
                Player player = (Player)damager;
                ItemStack itemInHand = player.getItemInHand();
                boolean isMeleeWeapon = this.controller.isMeleeWeapon(itemInHand);
                if (isMelee && hasWand && !isMeleeWeapon) {
                    event.setCancelled(true);
                    CompatibilityUtils.isDamaging = true;
                    activeWand.cast();
                    CompatibilityUtils.isDamaging = false;
                } else if (!hasWand && this.preventMeleeDamage && isMelee && !isMeleeWeapon) {
                    event.setCancelled(true);
                }
            }
        } else {
            Targeting.checkTracking((Plugin)this.controller.getPlugin(), damager, entity);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent event) {
        com.elmakers.mine.bukkit.api.magic.Mage apiMage;
        LivingEntity entity = event.getEntity();
        if (entity.hasMetadata("nodrops")) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
        if ((apiMage = this.controller.getRegisteredMage((Entity)entity)) == null) {
            return;
        }
        if (!(apiMage instanceof Mage)) {
            return;
        }
        Mage mage = (Mage)apiMage;
        mage.onPlayerDeath(event);
        mage.deactivateAllSpells();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        String rule = entity.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] stored;
                drops.removeAll(Arrays.asList(player.getInventory().getContents()));
                wand.deactivate();
                for (ItemStack stack : stored = player.getInventory().getContents()) {
                    if (stack == null) continue;
                    drops.add(stack);
                }
            } else {
                wand.deactivate();
            }
        }
        ArrayList<ItemStack> removeDrops = new ArrayList<ItemStack>();
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack itemStack = contents[index];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (NMSUtils.isTemporary(itemStack) || Wand.isSkill(itemStack)) {
                removeDrops.add(itemStack);
                continue;
            }
            boolean keepItem = false;
            if (Wand.isWand(itemStack) && !(keepItem = this.keepWandsOnDeath)) {
                Wand testWand = new Wand(this.controller, itemStack);
                keepItem = testWand.keepOnDeath();
            }
            if (!keepItem) continue;
            mage.addToRespawnInventory(index, itemStack);
            removeDrops.add(itemStack);
        }
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int index = 0; index < armor.length; ++index) {
            ItemStack itemStack = armor[index];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (NMSUtils.isTemporary(itemStack) || Wand.isSkill(itemStack)) {
                removeDrops.add(itemStack);
                continue;
            }
            boolean keepItem = false;
            if (Wand.isWand(itemStack) && !(keepItem = this.keepWandsOnDeath)) {
                Wand testWand = new Wand(this.controller, itemStack);
                keepItem = testWand.keepOnDeath();
            }
            if (!keepItem) continue;
            mage.addToRespawnArmor(index, itemStack);
            removeDrops.add(itemStack);
        }
        drops.removeAll(removeDrops);
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item entity = event.getEntity();
        if (Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand = new Wand(this.controller, entity.getItemStack());
            if (wand.isIndestructible()) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else {
                this.controller.removeLostWand(wand.getId());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (this.disableItemSpawn) {
            event.setCancelled(true);
            return;
        }
        Item itemEntity = event.getEntity();
        ItemStack spawnedItem = itemEntity.getItemStack();
        Block block = itemEntity.getLocation().getBlock();
        BlockData undoData = com.elmakers.mine.bukkit.block.UndoList.getBlockData(block.getLocation());
        if (undoData != null && undoData.getMaterial() != Material.AIR && block.getType() != Material.AIR) {
            undoData.getUndoList().add(block);
            event.setCancelled(true);
            return;
        }
        if (Wand.isSkill(spawnedItem)) {
            event.setCancelled(true);
            return;
        }
        if (Wand.isWand(spawnedItem)) {
            Wand wand = new Wand(this.controller, event.getEntity().getItemStack());
            if (wand.isIndestructible()) {
                CompatibilityUtils.setInvulnerable((Entity)event.getEntity());
                this.controller.addLostWand(wand, event.getEntity().getLocation());
                Location dropLocation = event.getLocation();
                this.controller.info("Wand " + wand.getName() + ", id " + wand.getId() + " spawned at " + dropLocation.getBlockX() + " " + dropLocation.getBlockY() + " " + dropLocation.getBlockZ());
            }
        } else if (this.ageDroppedItems > 0) {
            int ticks = this.ageDroppedItems * 20 / 1000;
            Item item = event.getEntity();
            CompatibilityUtils.ageItem(item, ticks);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        try {
            Item item;
            ItemStack itemStack;
            Entity entity = event.getEntity();
            com.elmakers.mine.bukkit.api.magic.Mage apiMage = this.controller.getRegisteredMage(event.getEntity());
            if (apiMage != null) {
                if (!(apiMage instanceof Mage)) {
                    return;
                }
                Mage mage = (Mage)apiMage;
                mage.onPlayerDamage(event);
            } else {
                Entity passenger = entity.getPassenger();
                com.elmakers.mine.bukkit.api.magic.Mage apiMountMage = this.controller.getRegisteredMage(passenger);
                if (apiMountMage != null) {
                    if (!(apiMountMage instanceof Mage)) {
                        return;
                    }
                    Mage mage = (Mage)apiMountMage;
                    mage.onPlayerDamage(event);
                }
            }
            if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                Wand wand = new Wand(this.controller, item.getItemStack());
                if (wand.isIndestructible()) {
                    event.setCancelled(true);
                } else if (event.getDamage() >= (double)itemStack.getDurability() && this.controller.removeLostWand(wand.getId())) {
                    this.controller.info("Wand " + wand.getName() + ", id " + wand.getId() + " destroyed");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

