/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.entity.EntityArmorStandData;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class EntityData
implements com.elmakers.mine.bukkit.api.entity.EntityData,
Cloneable {
    protected static Map<UUID, WeakReference<Entity>> respawned = new HashMap<UUID, WeakReference<Entity>>();
    protected WeakReference<Entity> entity = null;
    protected UUID uuid = null;
    protected EntityExtraData extraData;
    protected Location location;
    protected Vector relativeLocation;
    protected boolean hasMoved = false;
    protected boolean isTemporary = false;
    protected String name = null;
    protected EntityType type;
    protected Art art;
    protected BlockFace facing;
    protected Rotation rotation;
    protected ItemStack item;
    protected double health = 1.0;
    protected boolean isBaby;
    protected int fireTicks;
    protected int airLevel;
    protected DyeColor dyeColor;
    protected Horse.Color horseColor;
    protected Horse.Variant horseVariant;
    protected Horse.Style horseStyle;
    protected Skeleton.SkeletonType skeletonType;
    protected Ocelot.Type ocelotType;
    protected Villager.Profession villagerProfession;
    protected Collection<PotionEffect> potionEffects = null;
    protected boolean hasPotionEffects = false;
    protected Vector velocity = null;
    protected boolean hasVelocity = false;
    protected boolean isHanging = false;
    protected boolean isLiving = false;
    protected boolean isProjectile = false;

    public EntityData(Entity entity) {
        this(entity.getLocation(), entity);
    }

    public EntityData(Location location, Entity entity) {
        this.setEntity(entity);
        this.isTemporary = entity.hasMetadata("temporary");
        this.isLiving = entity instanceof LivingEntity;
        this.isHanging = entity instanceof Hanging;
        this.isProjectile = entity instanceof Projectile;
        this.type = entity.getType();
        this.location = location;
        this.fireTicks = entity.getFireTicks();
        try {
            this.velocity = entity.getVelocity();
        }
        catch (Exception ex) {
            this.velocity = null;
        }
        if (entity instanceof Hanging) {
            Hanging hanging = (Hanging)entity;
            try {
                this.facing = hanging.getFacing();
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.WARNING, "Error reading HangingEntity " + entity + " of type " + (entity == null ? "null" : entity.getType()), ex);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            this.name = li.getCustomName();
            this.health = li.getHealth();
            this.potionEffects = li.getActivePotionEffects();
            this.airLevel = li.getRemainingAir();
        }
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            boolean bl = this.isBaby = !ageable.isAdult();
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            this.dyeColor = colorable.getColor();
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            this.art = painting.getArt();
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            this.item = itemFrame.getItem();
            this.rotation = ((ItemFrame)entity).getRotation();
        } else if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            this.item = droppedItem.getItemStack();
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.horseVariant = horse.getVariant();
            this.horseColor = horse.getColor();
            this.horseStyle = horse.getStyle();
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            this.skeletonType = skeleton.getSkeletonType();
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            this.villagerProfession = villager.getProfession();
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            this.dyeColor = wolf.getCollarColor();
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            this.ocelotType = ocelot.getCatType();
        }
        if (entity instanceof ArmorStand) {
            this.extraData = new EntityArmorStandData((ArmorStand)entity);
        }
    }

    private EntityData(EntityType type) {
        this.type = type;
    }

    public static EntityData loadPainting(Vector location, Art art, BlockFace direction) {
        EntityData data = new EntityData(EntityType.PAINTING);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.art = art;
        return data;
    }

    public static EntityData loadItemFrame(Vector location, ItemStack item, BlockFace direction, Rotation rotation) {
        EntityData data = new EntityData(EntityType.ITEM_FRAME);
        data.facing = direction;
        data.relativeLocation = location.clone();
        data.rotation = rotation;
        data.item = item;
        return data;
    }

    public void setEntity(Entity entity) {
        this.entity = entity == null ? null : new WeakReference<Entity>(entity);
        this.uuid = entity == null ? null : entity.getUniqueId();
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public EntityType getType() {
        return this.type;
    }

    @Override
    public Art getArt() {
        return this.art;
    }

    @Override
    public BlockFace getFacing() {
        return this.facing;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    protected Entity trySpawn() {
        Painting spawned = null;
        try {
            switch (this.type) {
                case PLAYER: {
                    break;
                }
                case PAINTING: {
                    spawned = CompatibilityUtils.spawnPainting(this.location, this.facing, this.art);
                    break;
                }
                case ITEM_FRAME: {
                    spawned = CompatibilityUtils.spawnItemFrame(this.location, this.facing, this.rotation, this.item);
                    break;
                }
                case DROPPED_ITEM: {
                    spawned = this.location.getWorld().dropItem(this.location, this.item);
                    break;
                }
                default: {
                    spawned = this.location.getWorld().spawnEntity(this.location, this.type);
                    break;
                }
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.WARNING, "Error restoring entity type " + this.getType() + " at " + this.getLocation(), ex);
        }
        return spawned;
    }

    @Override
    public EntityData getRelativeTo(Location center) {
        EntityData copy = this.clone();
        if (copy != null) {
            if (this.relativeLocation != null) {
                copy.location = center.clone().add(this.relativeLocation);
            } else if (this.location != null) {
                copy.location = this.location.clone();
            }
        }
        return copy;
    }

    @Override
    public Entity spawn() {
        if (this.location == null) {
            return null;
        }
        Entity spawned = this.trySpawn();
        if (spawned != null) {
            this.modify(spawned);
        }
        return spawned;
    }

    @Override
    public Entity undo() {
        Entity entity = this.getEntity();
        if (!(this.isTemporary || this.uuid == null || entity != null && entity.isValid() && !entity.isDead() || entity instanceof Player)) {
            WeakReference<Entity> respawnedEntity = respawned.get(this.uuid);
            if (respawnedEntity != null) {
                entity = (Entity)respawnedEntity.get();
            } else {
                entity = this.trySpawn();
                if (entity != null) {
                    respawned.put(this.uuid, new WeakReference<Entity>(entity));
                }
            }
            this.setEntity(entity);
        }
        this.modify(entity);
        return entity;
    }

    @Override
    public boolean modify(Entity entity) {
        if (entity == null || entity.getType() != this.type) {
            return false;
        }
        if (this.extraData != null) {
            this.extraData.apply(entity);
        }
        entity.setFireTicks(this.fireTicks);
        if (entity instanceof Ageable) {
            Ageable ageable = (Ageable)entity;
            if (this.isBaby) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (entity instanceof Colorable) {
            Colorable colorable = (Colorable)entity;
            colorable.setColor(this.dyeColor);
        }
        if (entity instanceof Painting) {
            Painting painting = (Painting)entity;
            painting.setArt(this.art, true);
            painting.setFacingDirection(this.facing, true);
        } else if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            itemFrame.setItem(this.item);
            itemFrame.setFacingDirection(this.facing, true);
        } else if (entity instanceof Item) {
            Item droppedItem = (Item)entity;
            droppedItem.setItemStack(this.item);
        } else if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            horse.setVariant(this.horseVariant);
            horse.setStyle(this.horseStyle);
            horse.setColor(this.horseColor);
        } else if (entity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)entity;
            skeleton.setSkeletonType(this.skeletonType);
        } else if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            villager.setProfession(this.villagerProfession);
        } else if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setCollarColor(this.dyeColor);
        } else if (entity instanceof Ocelot) {
            Ocelot ocelot = (Ocelot)entity;
            ocelot.setCatType(this.ocelotType);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)entity;
            if (this.hasPotionEffects) {
                Collection currentEffects = li.getActivePotionEffects();
                for (PotionEffect effect : currentEffects) {
                    li.removePotionEffect(effect.getType());
                }
                if (this.potionEffects != null) {
                    for (PotionEffect effect : this.potionEffects) {
                        li.addPotionEffect(effect);
                    }
                }
            }
            if (this.name != null && this.name.length() > 0) {
                li.setCustomName(this.name);
            }
            try {
                li.setHealth(Math.min(this.health, li.getMaxHealth()));
                li.setRemainingAir(Math.min(this.airLevel, li.getRemainingAir()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.hasMoved && this.location != null) {
            entity.teleport(this.location);
        }
        if (this.hasVelocity && this.velocity != null) {
            entity.setVelocity(this.velocity);
        }
        return true;
    }

    @Override
    public void setHasMoved(boolean moved) {
        this.hasMoved = moved;
    }

    public void setHasPotionEffects(boolean changed) {
        this.hasPotionEffects = changed;
    }

    public void setHasVelocity(boolean hasVelocity) {
        this.hasVelocity = hasVelocity;
    }

    public boolean isHanging() {
        return this.isHanging;
    }

    public boolean isLiving() {
        return this.isLiving;
    }

    public boolean isProjectile() {
        return this.isProjectile;
    }

    public Entity getEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    public EntityData clone() {
        try {
            return (EntityData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removed(Entity entity) {
        if (this.extraData != null) {
            this.extraData.removed(entity);
        }
    }
}

