/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class VolumeAction
extends CompoundAction {
    public static final float DEGTORAD = (float)Math.PI / 180;
    private static final int DEFAULT_RADIUS = 2;
    protected boolean autoOrient;
    protected int radius;
    protected int radiusSquared;
    protected int currentRadius;
    protected float centerProbability;
    protected float outerProbability;
    protected int xSize;
    protected int ySize;
    protected int zSize;
    protected int thickness;
    protected int yStart;
    protected int yEnd;
    private int xOffset;
    private int zOffset;
    private int dy;
    private int dx;
    private int dz;
    private int xDirection;
    private int zDirection;
    private int startRadius;
    private Vector min;
    private Vector max;
    private VolumeType volumeType;
    private boolean useBrushSize;
    private boolean centerY;
    private boolean centerX;
    private boolean centerZ;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getInt("radius", 2);
        this.xSize = parameters.getInt("x_size", this.radius);
        this.ySize = parameters.getInt("y_size", this.radius);
        this.zSize = parameters.getInt("z_size", this.radius);
        this.centerY = parameters.getBoolean("center_y", true);
        this.centerX = parameters.getBoolean("center_x", true);
        this.centerZ = parameters.getBoolean("center_z", true);
        this.thickness = parameters.getInt("thickness", 0);
        this.autoOrient = parameters.getBoolean("orient", false);
        this.centerProbability = (float)parameters.getDouble("probability", 1.0);
        this.outerProbability = (float)parameters.getDouble("probability", 1.0);
        this.centerProbability = (float)parameters.getDouble("center_probability", (double)this.centerProbability);
        this.outerProbability = (float)parameters.getDouble("outer_probability", (double)this.outerProbability);
        this.useBrushSize = parameters.getBoolean("use_brush_size", false);
        String typeString = parameters.getString("volume_type");
        if (typeString != null) {
            try {
                this.volumeType = VolumeType.valueOf(typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.volumeType = VolumeType.SPIRAL;
            }
        } else {
            this.volumeType = VolumeType.SPIRAL;
        }
    }

    protected boolean calculateSize(CastContext context) {
        if (this.useBrushSize) {
            MaterialBrush brush = context.getBrush();
            if (!brush.isReady()) {
                return false;
            }
            Vector bounds = brush.getSize();
            this.xSize = (int)Math.ceil(bounds.getX() / 2.0) + 1;
            this.ySize = (int)Math.ceil(bounds.getY() / 2.0) + 1;
            this.zSize = (int)Math.ceil(bounds.getZ() / 2.0) + 1;
            if (this.volumeType == VolumeType.SPIRAL) {
                this.xSize = Math.max(this.xSize, this.zSize);
                this.zSize = Math.max(this.xSize, this.zSize);
            }
            this.centerY = false;
            context.getMage().sendDebugMessage(ChatColor.GREEN + "Brush Size: " + ChatColor.GRAY + this.xSize + "," + this.ySize + "," + this.zSize, 2);
        } else {
            this.xSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.xSize);
            this.ySize = (int)(context.getMage().getRadiusMultiplier() * (float)this.ySize);
            this.zSize = (int)(context.getMage().getRadiusMultiplier() * (float)this.zSize);
        }
        if (this.volumeType == VolumeType.SPIRAL && this.xSize != this.zSize) {
            this.volumeType = VolumeType.YZX;
        }
        if (this.centerY) {
            this.yStart = -this.ySize;
            this.yEnd = this.ySize;
        } else {
            this.yStart = 0;
            this.yEnd = this.ySize * 2;
        }
        this.xOffset = !this.centerX ? this.xSize : 0;
        this.zOffset = !this.centerZ ? this.zSize : 0;
        if (this.volumeType != VolumeType.SPIRAL) {
            this.min = new Vector(-this.xSize, this.yStart, -this.zSize);
            this.max = new Vector(this.xSize, this.yEnd, this.zSize);
        }
        this.radius = Math.max(this.xSize, this.zSize);
        this.radiusSquared = this.radius * this.radius;
        this.startRadius = this.getStartRadius();
        return true;
    }

    protected int getStartRadius() {
        return 0;
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        MaterialBrush brush = context.getBrush();
        brush.setTarget(context.getTargetLocation());
    }

    protected void resetCounters() {
        if (this.volumeType == VolumeType.SPIRAL) {
            this.currentRadius = this.startRadius;
            this.dx = -Math.min(this.startRadius, this.xSize);
            this.dy = this.yStart;
            this.dz = -Math.min(this.startRadius, this.zSize);
            this.xDirection = 1;
            this.zDirection = 0;
        } else {
            this.dx = this.min.getBlockX();
            this.dy = this.min.getBlockY();
            this.dz = this.min.getBlockZ();
        }
    }

    public static Vector rotate(float yaw, float pitch, double x, double y, double z) {
        float angle = -yaw * ((float)Math.PI / 180);
        double sinYaw = Math.sin(angle);
        double cosYaw = Math.cos(angle);
        angle = pitch * ((float)Math.PI / 180);
        double sinPitch = Math.sin(angle);
        double cosPitch = Math.cos(angle);
        double pitchedZ = y * sinPitch + z * cosPitch;
        double finalX = x * cosYaw + pitchedZ * sinYaw + 0.5;
        double finalY = y * cosPitch - z * sinPitch + 0.5;
        double finalZ = -x * sinYaw + pitchedZ * cosYaw + 0.5;
        return new Vector(finalX, finalY, finalZ);
    }

    protected boolean nextYZX(CastContext context) {
        ++this.dy;
        if (this.dy > this.max.getBlockY()) {
            this.dy = this.min.getBlockY();
            ++this.dz;
            if (this.dz > this.max.getBlockZ()) {
                this.dz = this.min.getBlockZ();
                ++this.dx;
            }
        }
        return this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ();
    }

    protected boolean nextYXZ(CastContext context) {
        ++this.dy;
        if (this.dy > this.max.getBlockY()) {
            this.dy = this.min.getBlockY();
            ++this.dx;
            if (this.dx > this.max.getBlockX()) {
                this.dx = this.min.getBlockX();
                ++this.dz;
            }
        }
        return this.dx <= this.max.getBlockX() && this.dy <= this.max.getBlockY() && this.dz <= this.max.getBlockZ();
    }

    protected boolean nextSpiral(CastContext context) {
        ++this.dy;
        if (this.dy > this.yEnd) {
            this.dy = this.yStart;
            int nextX = this.dx + this.xDirection;
            int nextZ = this.dz + this.zDirection;
            int endX = Math.min(this.currentRadius, this.xSize);
            int endZ = Math.min(this.currentRadius, this.zSize);
            if (this.xDirection == 0 && this.zDirection == -1 && nextX <= -endX && nextZ <= -endZ || this.currentRadius == 0) {
                ++this.currentRadius;
                this.dx = -this.currentRadius;
                this.dz = -this.currentRadius;
                this.xDirection = 1;
                this.zDirection = 0;
            } else if (nextX > this.currentRadius || nextZ > endZ || nextX < -endX || nextZ < -endZ) {
                if (this.xDirection == 1 && this.zDirection == 0) {
                    this.xDirection = 0;
                    this.zDirection = 1;
                    this.dz += this.zDirection;
                } else if (this.xDirection == 0 && this.zDirection == 1) {
                    this.xDirection = -1;
                    this.zDirection = 0;
                    this.dx += this.xDirection;
                } else {
                    this.xDirection = 0;
                    this.zDirection = -1;
                    this.dz += this.zDirection;
                }
            } else {
                this.dx = nextX;
                this.dz = nextZ;
            }
        }
        return this.currentRadius <= this.radius;
    }

    @Override
    public SpellResult start(CastContext context) {
        if (!this.calculateSize(context)) {
            return SpellResult.PENDING;
        }
        this.resetCounters();
        return SpellResult.NO_ACTION;
    }

    @Override
    public boolean next(CastContext context) {
        if (this.radius < 1 && this.ySize < 1) {
            return false;
        }
        boolean result = false;
        switch (this.volumeType) {
            case SPIRAL: {
                result = this.nextSpiral(context);
                break;
            }
            case YZX: {
                result = this.nextYZX(context);
                break;
            }
            case YXZ: {
                result = this.nextYXZ(context);
            }
        }
        return result;
    }

    @Override
    public SpellResult step(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        boolean singleBlock = this.radius < 1 && this.ySize < 1;
        boolean validBlock = singleBlock ? true : this.containsPoint(this.dx, this.dy, this.dz);
        float probability = this.centerProbability;
        if (!singleBlock && this.centerProbability != this.outerProbability) {
            float weight = Math.abs((float)this.dx + (float)this.dz) / ((float)this.radius * 2.0f);
            probability = RandomUtils.lerp(Float.valueOf(this.centerProbability), Float.valueOf(this.outerProbability), weight).floatValue();
        }
        boolean bl = validBlock = validBlock && (probability >= 1.0f || context.getRandom().nextDouble() <= (double)probability);
        if (validBlock) {
            Block block = context.getTargetBlock();
            Vector offset = new Vector();
            if (this.autoOrient) {
                Location location = this.actionContext.getLocation();
                offset.setX(this.dx + this.xOffset);
                offset.setY(this.dy);
                offset.setZ(this.dz + this.zOffset);
                Block originalBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
                this.actionContext.setTargetSourceLocation(originalBlock.getRelative(-this.xOffset, 0, -this.zOffset).getLocation());
                offset = VolumeAction.rotate(location.getYaw(), location.getPitch(), offset.getX(), offset.getY(), offset.getZ());
            } else {
                offset.setX(this.dx);
                offset.setY(this.dy);
                offset.setZ(this.dz);
            }
            Block targetBlock = block.getRelative(offset.getBlockX(), offset.getBlockY(), offset.getBlockZ());
            this.actionContext.setTargetLocation(targetBlock.getLocation());
            result = this.startActions();
        } else {
            this.skippedActions(context);
        }
        return result;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    protected boolean containsPoint(int x, int y, int z) {
        return this.thickness == 0 || x > this.radius - this.thickness || y > this.radius - this.thickness || z > this.radius - this.thickness;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("radius");
        parameters.add("probability");
        parameters.add("center_probability");
        parameters.add("outer_probability");
        parameters.add("use_brush_size");
        parameters.add("thickness");
        parameters.add("orient");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("radius") || parameterKey.equals("thickness")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("probability") || parameterKey.equals("center_probability") || parameterKey.equals("outer_probability")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_PERCENTAGES));
        } else if (parameterKey.equals("orient") || parameterKey.equals("use_brush_size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public int getActionCount() {
        int volume = (1 + this.xSize * 2) * (1 + this.ySize * 2) * (1 + this.zSize * 2);
        return volume * super.getActionCount();
    }

    private static enum VolumeType {
        SPIRAL,
        YZX,
        YXZ;

    }
}

