/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class SkipAction
extends CompoundAction {
    private int skipCount;
    private int skipCounter;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.skipCount = parameters.getInt("skip", 1);
        this.skipCounter = 0;
    }

    @Override
    public SpellResult step(CastContext context) {
        if (this.skipCounter++ <= this.skipCount) {
            return SpellResult.NO_ACTION;
        }
        this.skipCounter = 0;
        return this.startActions();
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("skip");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("skip")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        }
    }
}

