/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.integration.VaultController;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CastingCost
implements com.elmakers.mine.bukkit.api.spell.CastingCost {
    protected MaterialAndData item;
    protected int amount;
    protected int xp;
    protected int mana;
    protected int currency;

    public CastingCost(String key, int cost) {
        if (key.toLowerCase().equals("xp")) {
            this.xp = cost;
        } else if (key.toLowerCase().equals("mana")) {
            this.mana = cost;
        } else if (key.toLowerCase().equals("currency")) {
            this.currency = cost;
        } else {
            this.item = new MaterialAndData(key);
            this.amount = cost;
        }
    }

    public CastingCost(Material item, int amount) {
        this.item = new MaterialAndData(item, 0);
        this.amount = amount;
    }

    public CastingCost(Material item, byte data, int amount) {
        this.item = new MaterialAndData(item, data);
        this.amount = amount;
    }

    @Override
    public MaterialAndData getMaterial() {
        return this.item;
    }

    public Map<String, Object> export() {
        HashMap<String, Object> cost = new HashMap<String, Object>();
        cost.put("material", this.item.getName());
        cost.put("amount", this.amount);
        cost.put("xp", this.xp);
        cost.put("mana", this.mana);
        cost.put("currency", this.currency);
        return cost;
    }

    public boolean has(Spell spell) {
        boolean hasCurrency;
        if (!(spell instanceof MageSpell)) {
            return false;
        }
        Mage mage = ((MageSpell)spell).getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        boolean hasItem = this.item == null || amount <= 0 || inventory.containsAtLeast(this.item.getItemStack(amount), amount);
        boolean hasXp = this.xp <= 0 || mage.getExperience() >= this.getXP(spell);
        boolean hasMana = this.mana <= 0 || mage.getMana() >= this.getMana(spell);
        boolean bl = hasCurrency = this.currency <= 0;
        if (!hasCurrency) {
            VaultController vault = VaultController.getInstance();
            hasCurrency = vault.has(mage.getPlayer(), this.getCurrency(spell));
        }
        return hasItem && hasXp && hasMana && hasCurrency;
    }

    public void use(Spell spell) {
        double currency;
        float mana;
        int xp;
        if (!(spell instanceof MageSpell)) {
            return;
        }
        Mage mage = ((MageSpell)spell).getMage();
        Inventory inventory = mage.getInventory();
        int amount = this.getAmount(spell);
        if (this.item != null && amount > 0) {
            ItemStack itemStack = this.getItemStack(spell);
            inventory.removeItem(new ItemStack[]{itemStack});
        }
        if ((xp = this.getXP(spell)) > 0) {
            mage.removeExperience(xp);
        }
        if ((mana = this.getMana(spell)) > 0.0f) {
            mage.removeMana(mana);
        }
        if ((currency = this.getCurrency(spell)) > 0.0) {
            VaultController vault = VaultController.getInstance();
            vault.withdrawPlayer(mage.getPlayer(), currency);
        }
    }

    protected ItemStack getItemStack() {
        return this.item.getItemStack(this.getAmount());
    }

    protected ItemStack getItemStack(CostReducer reducer) {
        return this.item.getItemStack(this.getAmount(reducer));
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public int getXP() {
        return this.xp;
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    public int getCurrency() {
        return this.currency;
    }

    @Override
    public int getAmount(CostReducer reducer) {
        return this.getRoundedCost(this.amount, reducer);
    }

    @Override
    public int getXP(CostReducer reducer) {
        return this.getRoundedCost(this.xp, reducer);
    }

    public double getCurrency(CostReducer reducer) {
        return this.getReducedCost(this.currency, reducer);
    }

    @Override
    public float getMana(CostReducer reducer) {
        return this.getReducedCost(this.mana, reducer);
    }

    protected int getRoundedCost(int cost, CostReducer reducer) {
        return (int)Math.ceil(this.getReducedCost(cost, reducer));
    }

    protected float getReducedCost(int cost, CostReducer reducer) {
        float reduction;
        float reducedAmount = cost;
        float f = reduction = reducer == null ? 0.0f : reducer.getCostReduction();
        if (reduction >= 1.0f) {
            return 0.0f;
        }
        if (reduction > 0.0f) {
            reducedAmount = (1.0f - reduction) * reducedAmount;
        }
        if (reducer != null) {
            reducedAmount *= reducer.getCostScale();
        }
        return reducedAmount;
    }

    @Override
    public boolean hasCosts(CostReducer reducer) {
        return this.item != null && this.getAmount(reducer) > 0 || this.getXP(reducer) > 0 || this.getMana(reducer) > 0.0f || this.getCurrency(reducer) > 0.0;
    }

    @Override
    public String getDescription(Messages messages, CostReducer reducer) {
        if (this.item != null && this.getAmount() != 0) {
            return this.item.getName();
        }
        if (this.xp > 0) {
            return messages.get("costs.xp");
        }
        if (this.mana > 0) {
            return messages.get("costs.mana");
        }
        if (this.currency > 0) {
            return messages.get("costs.currency");
        }
        return "";
    }

    @Override
    public String getFullDescription(Messages messages, CostReducer reducer) {
        if (this.item != null) {
            return this.getAmount(reducer) + " " + this.item.getName();
        }
        if (this.xp > 0) {
            return messages.get("costs.xp_amount").replace("$amount", Integer.valueOf(this.getXP(reducer)).toString());
        }
        if (this.mana > 0) {
            return messages.get("costs.mana_amount").replace("$amount", Integer.valueOf((int)Math.ceil(this.getMana(reducer))).toString());
        }
        if (this.currency > 0) {
            return messages.get("costs.currency_amount").replace("$amount", Integer.valueOf((int)Math.ceil(this.getCurrency(reducer))).toString());
        }
        return "";
    }
}

