/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public abstract class BrushSpell
extends BlockSpell {
    protected com.elmakers.mine.bukkit.block.MaterialBrush brush;
    protected boolean hasBrush = false;
    protected boolean usesBrush = true;
    public static final String[] BRUSH_PARAMETERS = new String[]{"brushmod", "brush", "obx", "oby", "obz", "obworld", "btarget", "brushcolor", "preserve_data"};

    @Override
    public void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        String materialKey = parameters.getString("brush", null);
        if (materialKey != null && !materialKey.isEmpty()) {
            Color color;
            this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush(this.mage, this.getLocation(), materialKey);
            if (parameters.getBoolean("preserve_data", false)) {
                this.brush.setData(null);
            }
            if (parameters.contains("brushmod")) {
                this.brush.update(parameters.getString("brushmod"));
                this.brush.update(materialKey);
            }
            Double dmxValue = ConfigurationUtils.getDouble(parameters, "obx", null);
            Double dmyValue = ConfigurationUtils.getDouble(parameters, "oby", null);
            Double dmzValue = ConfigurationUtils.getDouble(parameters, "obz", null);
            String targetWorldName = parameters.getString("obworld", null);
            if (dmxValue != null || dmyValue != null || dmzValue != null || targetWorldName != null) {
                Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
                this.brush.clearCloneTarget();
                this.brush.setTargetOffset(offset, targetWorldName);
            }
            if (parameters.getBoolean("brushtarget", false)) {
                this.brush.clearCloneLocation();
            }
            if (parameters.getBoolean("brushcolor", false) && (color = this.mage.getEffectColor()) != null) {
                DyeColor bestDyeColor = null;
                Double bestDistance = null;
                for (DyeColor testDyeColor : DyeColor.values()) {
                    Color testColor = testDyeColor.getColor();
                    double testDistance = ColorHD.getDistance(testColor, color);
                    if (bestDistance != null && !(testDistance < bestDistance)) continue;
                    bestDistance = testDistance;
                    bestDyeColor = testDyeColor;
                    if (testDistance == 0.0) break;
                }
                if (bestDyeColor != null) {
                    this.brush.setData(Short.valueOf(bestDyeColor.getData()));
                }
            }
        } else {
            this.brush = null;
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        this.usesBrush = node.getBoolean("uses_brush", this.usesBrush);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            String materialKey = parameters.getString("brush", null);
            boolean bl = this.hasBrush = materialKey != null && !materialKey.isEmpty();
            if (materialKey != null && !materialKey.isEmpty()) {
                this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush(materialKey);
            }
        }
    }

    public boolean brushIsErase() {
        MaterialBrush brush = this.getBrush();
        return brush != null && brush.isErase();
    }

    @Override
    public boolean requiresBuildPermission() {
        return !this.brushIsErase();
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.brushIsErase();
    }

    @Override
    public MaterialBrush getBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return super.getBrush();
    }

    @Override
    public MaterialAndData getEffectMaterial() {
        return this.brush != null ? this.brush : this.mage.getBrush();
    }

    @Override
    public boolean hasBrushOverride() {
        return this.brush != null || this.hasBrush;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush && !this.hasBrushOverride();
    }

    @Override
    protected String getDisplayMaterialName() {
        MaterialBrush useBrush;
        if (this.usesBrush && (useBrush = this.getBrush()) != null) {
            return useBrush.getName();
        }
        return super.getDisplayMaterialName();
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BRUSH_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("bmod") || parameterKey.equals("brush")) {
            examples.addAll(this.controller.getBrushKeys());
        } else if (parameterKey.equals("btarget")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("obx") || parameterKey.equals("oby") || parameterKey.equals("obz")) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("obworld")) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        }
    }
}

