/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionContext;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.List;

public class ParallelAction
extends CompoundAction {
    private List<ActionContext> remaining = null;

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.remaining = new ArrayList<ActionContext>(this.actions.getActions());
        for (ActionContext action : this.remaining) {
            action.getAction().reset(context);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        SpellResult result = SpellResult.NO_ACTION;
        int startingWork = context.getWorkAllowed();
        ArrayList<ActionContext> subActions = new ArrayList<ActionContext>(this.remaining);
        this.remaining.clear();
        context.setWorkAllowed(0);
        int splitWork = Math.max(1, startingWork / subActions.size());
        for (ActionContext action : subActions) {
            context.setWorkAllowed(context.getWorkAllowed() + splitWork);
            SpellResult actionResult = action.perform(context);
            if (actionResult.isStop()) {
                this.remaining.add(action);
            }
            result = result.min(actionResult);
        }
        return result;
    }
}

