/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class CustomProjectileAction
extends CompoundAction {
    private int interval;
    private int lifetime;
    private double speed;
    private int startDistance;
    private String projectileEffectKey;
    private String hitEffectKey;
    private String tickEffectKey;
    private boolean targetEntities;
    private double radius;
    private double gravity;
    private double drag;
    private double tickSize;
    private boolean reorient;
    private boolean useWandLocation;
    private boolean useEyeLocation;
    private boolean hasTickEffects;
    private long lastUpdate;
    private long nextUpdate;
    private long deadline;
    private boolean hit = false;
    private Vector velocity = null;
    private DynamicLocation effectLocation = null;
    private Collection<EffectPlay> activeProjectileEffects;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.interval = parameters.getInt("interval", 1);
        this.lifetime = parameters.getInt("lifetime", 5000);
        this.speed = parameters.getDouble("speed", 0.1);
        this.startDistance = parameters.getInt("start", 0);
        this.projectileEffectKey = parameters.getString("projectile_effects", "projectile");
        this.hitEffectKey = parameters.getString("hit_effects", "hit");
        this.tickEffectKey = parameters.getString("tick_effects", "tick");
        this.targetEntities = parameters.getBoolean("target_entities", true);
        this.radius = parameters.getDouble("size", 1.0) / 2.0;
        this.gravity = parameters.getDouble("gravity", 0.0);
        this.drag = parameters.getDouble("drag", 0.0);
        this.tickSize = parameters.getDouble("tick_size", 0.5);
        this.hasTickEffects = context.getEffects(this.tickEffectKey).size() > 0;
        this.reorient = parameters.getBoolean("reorient", false);
        this.useWandLocation = parameters.getBoolean("use_wand_location", true);
        this.useEyeLocation = parameters.getBoolean("use_eye_location", true);
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        long now = System.currentTimeMillis();
        this.nextUpdate = 0L;
        this.lastUpdate = now;
        this.deadline = now + (long)this.lifetime;
        this.hit = false;
        this.effectLocation = null;
        this.velocity = null;
        this.activeProjectileEffects = null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        long now = System.currentTimeMillis();
        if (now < this.nextUpdate) {
            return SpellResult.PENDING;
        }
        if (this.hit) {
            return super.perform(context);
        }
        if (now > this.deadline) {
            return this.hit(context);
        }
        this.nextUpdate = now + (long)this.interval;
        Location targetLocation = context.getTargetLocation();
        if (targetLocation == null) {
            targetLocation = this.useWandLocation ? context.getWandLocation().clone() : (this.useEyeLocation ? context.getEyeLocation().clone() : context.getLocation().clone());
            context.setTargetLocation(targetLocation);
        }
        if (this.velocity == null) {
            this.velocity = context.getDirection().clone().normalize();
            if (this.startDistance != 0) {
                targetLocation.add(this.velocity.clone().multiply(this.startDistance));
            }
            Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> projectileEffects = context.getEffects(this.projectileEffectKey);
            for (com.elmakers.mine.bukkit.api.effect.EffectPlayer apiEffectPlayer : projectileEffects) {
                if (this.effectLocation == null) {
                    this.effectLocation = new DynamicLocation(targetLocation);
                    this.effectLocation.setDirection(this.velocity);
                }
                if (this.activeProjectileEffects == null) {
                    this.activeProjectileEffects = new ArrayList<EffectPlay>();
                }
                if (!(apiEffectPlayer instanceof EffectPlayer)) continue;
                EffectPlayer effectPlayer = (EffectPlayer)apiEffectPlayer;
                effectPlayer.setEffectPlayList(this.activeProjectileEffects);
                effectPlayer.startEffects(this.effectLocation, null);
            }
        } else if (this.effectLocation != null) {
            this.effectLocation.updateFrom(targetLocation);
            this.effectLocation.setDirection(this.velocity);
        }
        long delta = now - this.lastUpdate;
        this.lastUpdate = now;
        if (this.reorient) {
            this.velocity = context.getDirection().clone().normalize();
        } else {
            if (this.gravity > 0.0) {
                this.velocity.setY(this.velocity.getY() - this.gravity * (double)delta / 50.0);
            }
            if (this.drag > 0.0) {
                double size = this.velocity.length();
                if ((size -= this.drag * (double)delta / 50.0) <= 0.0) {
                    return this.hit(context);
                }
                this.velocity.normalize().multiply(size);
            }
        }
        double remainingSpeed = this.speed * (double)delta / 50.0;
        ArrayList<CandidateEntity> candidates = null;
        if (this.radius >= 0.0 && this.targetEntities) {
            Entity sourceEntity = context.getEntity();
            candidates = new ArrayList<CandidateEntity>();
            double boundSize = Math.ceil(remainingSpeed) * this.radius + 2.0;
            List<Entity> nearbyEntities = CompatibilityUtils.getNearbyEntities(targetLocation, boundSize, boundSize, boundSize);
            for (Entity entity : nearbyEntities) {
                if (!context.getTargetsCaster() && entity == sourceEntity || !context.canTarget(entity)) continue;
                candidates.add(new CandidateEntity(entity));
            }
            if (candidates.isEmpty()) {
                candidates = null;
            }
        }
        for (int i = 0; i < 256; ++i) {
            int y;
            if (this.hasTickEffects) {
                context.setTargetLocation(targetLocation);
                context.playEffects(this.tickEffectKey);
            }
            Vector targetVector = targetLocation.toVector();
            if (candidates != null) {
                for (CandidateEntity candidate : candidates) {
                    if (!candidate.bounds.contains(targetVector)) continue;
                    context.setTargetEntity(candidate.entity);
                    return this.hit(context);
                }
            }
            if ((y = targetLocation.getBlockY()) >= targetLocation.getWorld().getMaxHeight() || y <= 0) {
                return this.hit(context);
            }
            Block block = targetLocation.getBlock();
            if (!block.getChunk().isLoaded()) {
                return this.hit(context);
            }
            if (!context.isTransparent(block.getType())) {
                return this.hit(context);
            }
            double partialSpeed = Math.min(this.tickSize, remainingSpeed);
            Vector speedVector = this.velocity.clone().multiply(partialSpeed);
            remainingSpeed -= this.tickSize;
            Vector newLocation = targetLocation.toVector().add(speedVector);
            if (newLocation.getBlockX() == targetLocation.getBlockX() && newLocation.getBlockY() == targetLocation.getBlockY() && newLocation.getBlockZ() == targetLocation.getBlockZ()) {
                remainingSpeed -= this.tickSize;
                newLocation = newLocation.add(speedVector);
                targetLocation.setX(newLocation.getX());
                targetLocation.setY(newLocation.getY());
                targetLocation.setZ(newLocation.getZ());
                if (this.hasTickEffects) {
                    context.setTargetLocation(targetLocation);
                    context.playEffects(this.tickEffectKey);
                }
            } else {
                targetLocation.setX(newLocation.getX());
                targetLocation.setY(newLocation.getY());
                targetLocation.setZ(newLocation.getZ());
            }
            if (remainingSpeed <= 0.0) break;
        }
        return SpellResult.PENDING;
    }

    protected SpellResult hit(CastContext context) {
        this.hit = true;
        if (this.activeProjectileEffects != null) {
            for (EffectPlay play : this.activeProjectileEffects) {
                play.cancel();
            }
        }
        context.playEffects(this.hitEffectKey);
        return super.perform(context);
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("interval");
        parameters.add("lifetime");
        parameters.add("speed");
        parameters.add("start");
        parameters.add("gravity");
        parameters.add("drag");
        parameters.add("target_entities");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        super.getParameterOptions(spell, parameterKey, examples);
        if (parameterKey.equals("speed") || parameterKey.equals("lifetime") || parameterKey.equals("interval") || parameterKey.equals("start") || parameterKey.equals("size") || parameterKey.equals("gravity") || parameterKey.equals("drag") || parameterKey.equals("tick_size")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("target_entities")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        }
    }

    private class CandidateEntity {
        public final Entity entity;
        public final BoundingBox bounds;

        public CandidateEntity(Entity entity) {
            this.entity = entity;
            this.bounds = CompatibilityUtils.getHitbox(entity).expand(CustomProjectileAction.this.radius);
        }
    }
}

