/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ApplyCooldownAction
extends BaseSpellAction {
    private int cooldownAmount;
    private String[] spells;
    private boolean clear;
    private boolean bypassReduction;
    private boolean targetCaster;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.cooldownAmount = parameters.getInt("duration", 0);
        this.clear = parameters.getBoolean("clear", false);
        this.bypassReduction = parameters.getBoolean("bypass_reduction", false);
        this.targetCaster = parameters.getBoolean("target_caster", false);
        String spellCSV = parameters.getString("spells", null);
        this.spells = spellCSV != null ? StringUtils.split((String)spellCSV, (char)',') : null;
    }

    @Override
    public SpellResult perform(CastContext context) {
        Mage targetMage = context.getMage();
        if (!this.targetCaster) {
            Entity entity = context.getTargetEntity();
            MageController controller = context.getController();
            if (entity == null || !controller.isMage(entity)) {
                return SpellResult.NO_TARGET;
            }
            controller.getMage(entity);
        }
        int amount = this.cooldownAmount;
        if (!this.bypassReduction && this.cooldownAmount > 0) {
            double cooldownReduction = targetMage.getCooldownReduction();
            amount = cooldownReduction < 1.0 ? (int)Math.ceil((1.0 - cooldownReduction) * (double)amount) : 0;
        }
        if (this.spells == null) {
            if (this.clear) {
                targetMage.clearCooldown();
            }
            if (amount > 0) {
                targetMage.setRemainingCooldown(amount);
            }
        } else {
            Wand wand = targetMage.getActiveWand();
            for (String spellName : this.spells) {
                Spell spell = null;
                if (wand != null) {
                    spell = wand.getSpell(spellName);
                }
                if (spell == null) {
                    spell = targetMage.getSpell(spellName);
                }
                if (spell == null) continue;
                if (this.clear) {
                    spell.clearCooldown();
                }
                if (amount <= 0) continue;
                spell.setRemainingCooldown(amount);
            }
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return !this.targetCaster;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("air");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("air")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

