/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;

public abstract class CompoundEntityAction
extends CompoundAction {
    private List<WeakReference<Entity>> entities = new ArrayList<WeakReference<Entity>>();
    private int currentEntity = 0;

    public abstract void addEntities(CastContext var1, List<WeakReference<Entity>> var2);

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.currentEntity = 0;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.currentEntity == 0) {
            this.entities.clear();
            this.addEntities(context, this.entities);
        }
        SpellResult result = SpellResult.NO_TARGET;
        while (this.currentEntity < this.entities.size()) {
            Entity entity = (Entity)this.entities.get(this.currentEntity).get();
            if (entity == null) {
                ++this.currentEntity;
                this.skippedActions(context);
                continue;
            }
            this.actionContext.setTargetEntity(entity);
            this.actionContext.setTargetLocation(entity.getLocation());
            SpellResult entityResult = super.perform(this.actionContext);
            result = result.min(entityResult);
            if (entityResult.isStop()) break;
            ++this.currentEntity;
            if (this.currentEntity >= this.entities.size()) continue;
            super.reset(context);
        }
        return result;
    }

    @Override
    public Object clone() {
        CompoundEntityAction action = (CompoundEntityAction)super.clone();
        if (action != null) {
            action.entities = new ArrayList<WeakReference<Entity>>(this.entities);
        }
        return action;
    }
}

