/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.TeleportTask;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CastContext
implements com.elmakers.mine.bukkit.api.action.CastContext {
    protected static Random random;
    private final Location location;
    private final Entity entity;
    private Location targetLocation;
    private Location targetSourceLocation;
    private Entity targetEntity;
    private UndoList undoList;
    private String targetName = null;
    private SpellResult result = SpellResult.NO_ACTION;
    private Collection<Entity> targetedEntities = Collections.newSetFromMap(new WeakHashMap());
    private Set<UUID> targetMessagesSent = new HashSet<UUID>();
    private Collection<EffectPlay> currentEffects = new ArrayList<EffectPlay>();
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private MageSpell mageSpell;
    private BrushSpell brushSpell;
    private TargetingSpell targetingSpell;
    private UndoableSpell undoSpell;
    private MaterialBrush brush;
    private CastContext base;
    private int workAllowed = 500;
    private int actionsPerformed;

    public CastContext() {
        this.location = null;
        this.entity = null;
        this.base = this;
        this.result = SpellResult.NO_ACTION;
        this.targetedEntities = Collections.newSetFromMap(new WeakHashMap());
        this.targetMessagesSent = new HashSet<UUID>();
        this.currentEffects = new ArrayList<EffectPlay>();
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy) {
        this(copy, copy.getEntity(), copy.getLocation());
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity) {
        this(copy, sourceEntity, null);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Location sourceLocation) {
        this(copy, null, sourceLocation);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity, Location sourceLocation) {
        this.location = sourceLocation;
        this.entity = sourceEntity;
        this.setSpell(copy.getSpell());
        this.targetEntity = copy.getTargetEntity();
        this.targetLocation = copy.getTargetLocation();
        this.targetedEntities = copy.getTargetedEntities();
        this.undoList = copy.getUndoList();
        this.targetName = copy.getTargetName();
        this.brush = copy.getBrush();
        this.targetMessagesSent = copy.getTargetMessagesSent();
        this.currentEffects = copy.getCurrentEffects();
        this.base = copy instanceof CastContext ? ((CastContext)copy).base : this;
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof MageSpell) {
            this.mageSpell = (MageSpell)spell;
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
            this.undoList = this.undoSpell.getUndoList();
        }
        if (spell instanceof TargetingSpell) {
            this.targetingSpell = (TargetingSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        if (spell instanceof BrushSpell) {
            this.brushSpell = (BrushSpell)spell;
        }
    }

    @Override
    public Location getWandLocation() {
        Mage mage = this.getMage();
        return mage == null ? this.getEyeLocation() : mage.getWandLocation();
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            if (this.entity instanceof LivingEntity) {
                return ((LivingEntity)this.entity).getEyeLocation();
            }
            return this.entity.getLocation();
        }
        return this.spell.getEyeLocation();
    }

    @Override
    public Entity getEntity() {
        if (this.entity != null) {
            return this.entity;
        }
        return this.spell.getEntity();
    }

    @Override
    public LivingEntity getLivingEntity() {
        Entity entity = this.getEntity();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.entity != null) {
            return this.entity.getLocation();
        }
        return this.spell.getLocation();
    }

    @Override
    public Location getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public Location getTargetSourceLocation() {
        return this.targetSourceLocation == null ? this.targetLocation : this.targetSourceLocation;
    }

    @Override
    public Block getTargetBlock() {
        return this.targetLocation == null ? null : this.targetLocation.getBlock();
    }

    @Override
    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public Vector getDirection() {
        return this.getLocation().getDirection();
    }

    @Override
    public World getWorld() {
        Location location = this.getLocation();
        return location == null ? null : location.getWorld();
    }

    @Override
    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = targetEntity;
        this.addTargetEntity(targetEntity);
    }

    @Override
    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public void setTargetSourceLocation(Location targetLocation) {
        this.targetSourceLocation = targetLocation;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getMage() {
        return this.mageSpell == null ? null : this.mageSpell.getMage();
    }

    @Override
    public Collection<EffectPlayer> getEffects(String key) {
        return this.spell.getEffects(key);
    }

    @Override
    public MageController getController() {
        Mage mage = this.getMage();
        return mage == null ? null : mage.getController();
    }

    @Override
    public void registerForUndo(Runnable runnable) {
        this.addWork(1);
        if (this.undoList != null) {
            this.undoList.add(runnable);
        }
    }

    @Override
    public void registerModified(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modify(entity);
        }
    }

    @Override
    public void registerForUndo(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.add(entity);
        }
    }

    @Override
    public void registerForUndo(Block block) {
        this.addWork(10);
        if (this.undoList != null) {
            this.undoList.add(block);
        }
    }

    @Override
    public void updateBlock(Block block) {
        MageController controller = this.getController();
        if (controller != null) {
            controller.updateBlock(block);
        }
    }

    @Override
    public void registerVelocity(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modifyVelocity(entity);
        }
    }

    @Override
    public void registerMoved(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.move(entity);
        }
    }

    @Override
    public void registerPotionEffects(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addPotionEffects(entity);
        }
    }

    @Override
    public Block getPreviousBlock() {
        return this.targetingSpell != null ? this.targetingSpell.getPreviousBlock() : null;
    }

    @Override
    public boolean isIndestructible(Block block) {
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBuildPermission(block) : false;
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBreakPermission(block) : false;
    }

    @Override
    public void playEffects(String key) {
        this.playEffects(key, 1.0f);
    }

    @Override
    public void playEffects(String effectName, float scale) {
        Collection<EffectPlayer> effects = this.getEffects(effectName);
        if (effects.size() > 0) {
            ConfigurationSection workingParameters;
            Location wand = null;
            Location eyeLocation = this.getEyeLocation();
            Location location = this.getLocation();
            Collection<Entity> targeted = this.getTargetedEntities();
            Entity sourceEntity = this.getEntity();
            Entity targetEntity = this.getTargetEntity();
            Location targetLocation = this.getTargetLocation();
            HashMap<String, String> parameterMap = null;
            ConfigurationSection configurationSection = workingParameters = this.spell != null ? this.spell.getWorkingParameters() : null;
            if (workingParameters != null) {
                Set keys = workingParameters.getKeys(false);
                parameterMap = new HashMap<String, String>();
                for (String key : keys) {
                    parameterMap.put("$" + key, workingParameters.getString(key));
                }
            }
            for (EffectPlayer player : effects) {
                Location source;
                player.setEffectPlayList(this.currentEffects);
                player.setScale(scale);
                player.setMaterial(this.spell.getEffectMaterial());
                player.setColor(this.spell.getEffectColor());
                String overrideParticle = this.spell.getEffectParticle();
                player.setParticleOverride(overrideParticle);
                player.setParameterMap(parameterMap);
                Mage mage = this.getMage();
                boolean useWand = mage != null && mage.getEntity() == sourceEntity && player.shouldUseWandLocation();
                Location location2 = source = player.shouldUseEyeLocation() ? eyeLocation : location;
                if (useWand) {
                    if (wand == null) {
                        wand = mage.getWandLocation();
                    }
                    source = wand;
                }
                Location target = targetLocation;
                if (!player.shouldUseHitLocation() && targetEntity != null) {
                    target = targetEntity instanceof LivingEntity ? ((LivingEntity)targetEntity).getEyeLocation() : targetEntity.getLocation();
                }
                player.start(source, sourceEntity, target, targetEntity, targeted);
            }
        }
    }

    @Override
    public void cancelEffects() {
        for (EffectPlay player : this.currentEffects) {
            player.cancel();
        }
        this.currentEffects.clear();
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(key, "");
    }

    @Override
    public String getMessage(String key, String def) {
        return this.baseSpell != null ? this.baseSpell.getMessage(key, def) : def;
    }

    @Override
    public Location findPlaceToStand(Location target, int verticalSearchDistance, boolean goUp) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(target, goUp, verticalSearchDistance) : this.location;
    }

    @Override
    public Location findPlaceToStand(Location targetLoc, int verticalSearchDistance) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(targetLoc, verticalSearchDistance, verticalSearchDistance) : this.location;
    }

    @Override
    public int getVerticalSearchDistance() {
        return this.baseSpell != null ? this.baseSpell.getVerticalSearchDistance() : 4;
    }

    @Override
    public boolean isOkToStandIn(Material material) {
        return this.baseSpell != null ? this.baseSpell.isOkToStandIn(material) : true;
    }

    @Override
    public boolean isWater(Material mat) {
        return mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    @Override
    public boolean isOkToStandOn(Material material) {
        return material != Material.AIR && material != Material.LAVA && material != Material.STATIONARY_LAVA;
    }

    @Override
    public boolean allowPassThrough(Material material) {
        return this.baseSpell != null ? this.baseSpell.allowPassThrough(material) : true;
    }

    @Override
    public void castMessageKey(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(this.getMessage(key));
        }
    }

    @Override
    public void sendMessageKey(String key) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(this.getMessage(key));
        }
    }

    @Override
    public void castMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(message);
        }
    }

    @Override
    public void setTargetedLocation(Location location) {
        if (this.targetingSpell != null) {
            this.targetingSpell.setTarget(location);
        }
    }

    @Override
    public Block findBlockUnder(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findBlockUnder(block);
        }
        return block;
    }

    @Override
    public Block findSpaceAbove(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findSpaceAbove(block);
        }
        return block;
    }

    @Override
    public boolean isTransparent(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isPassthrough(Material material) {
        if (this.baseSpell != null) {
            return this.baseSpell.isPassthrough(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.isDestructible(block);
        }
        return true;
    }

    @Override
    public boolean areAnyDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.areAnyDestructible(block);
        }
        return true;
    }

    @Override
    public boolean isTargetable(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTargetable(material);
        }
        return true;
    }

    @Override
    public boolean getTargetsCaster() {
        if (this.baseSpell != null) {
            return this.baseSpell.getTargetsCaster();
        }
        return false;
    }

    @Override
    public void setTargetsCaster(boolean target) {
        if (this.baseSpell != null) {
            this.baseSpell.setTargetsCaster(target);
        }
    }

    @Override
    public boolean canTarget(Entity entity) {
        return this.targetingSpell == null ? true : this.targetingSpell.canTarget(entity);
    }

    @Override
    public MaterialBrush getBrush() {
        if (this.brush != null) {
            return this.brush;
        }
        return this.brushSpell == null ? null : this.brushSpell.getBrush();
    }

    @Override
    public void setBrush(MaterialBrush brush) {
        this.brush = brush;
    }

    @Override
    public void addTargetEntity(Entity entity) {
        if (entity != null) {
            this.targetedEntities.add(entity);
        }
    }

    @Override
    public Collection<Entity> getTargetedEntities() {
        return this.targetedEntities;
    }

    @Override
    public void getTargetEntities(int targetCount, Collection<WeakReference<Entity>> entities) {
        if (this.targetingSpell == null) {
            return;
        }
        List<Target> candidates = ((TargetingSpell)this.spell).getAllTargetEntities();
        if (targetCount < 0) {
            targetCount = entities.size();
        }
        for (int i = 0; i < targetCount && i < candidates.size(); ++i) {
            Target target = candidates.get(i);
            entities.add(new WeakReference<Entity>(target.getEntity()));
        }
    }

    @Override
    public void messageTargets(String messageKey) {
        Mage mage = this.getMage();
        MageController controller = this.getController();
        LivingEntity sourceEntity = mage == null ? null : mage.getLivingEntity();
        String playerMessage = this.getMessage(messageKey);
        if (!mage.isStealth() && playerMessage.length() > 0) {
            Collection<Entity> targets = this.getTargetedEntities();
            for (Entity target : targets) {
                UUID targetUUID = target.getUniqueId();
                if (!(target instanceof Player) || target == sourceEntity || this.targetMessagesSent.contains(targetUUID)) continue;
                this.targetMessagesSent.add(targetUUID);
                playerMessage = playerMessage.replace("$spell", this.spell.getName());
                Mage targetMage = controller.getMage(target);
                targetMage.sendMessage(playerMessage);
            }
        }
    }

    @Override
    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock.getType())) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    @Override
    public Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    @Override
    public UndoList getUndoList() {
        return this.undoList;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String name) {
        this.targetName = name;
    }

    @Override
    public Logger getLogger() {
        return this.getController().getLogger();
    }

    @Override
    public int getWorkAllowed() {
        return this.base.workAllowed;
    }

    @Override
    public void setWorkAllowed(int work) {
        this.base.workAllowed = work;
    }

    @Override
    public void addWork(int work) {
        this.base.workAllowed -= work;
    }

    @Override
    public void performedActions(int count) {
        this.base.actionsPerformed += count;
    }

    @Override
    public int getActionsPerformed() {
        return this.base.actionsPerformed;
    }

    @Override
    public void finish() {
        Mage mage = this.getMage();
        if (this.undoSpell != null && this.undoSpell.isUndoable()) {
            if (!this.undoList.isScheduled()) {
                this.getController().update(this.undoList);
            }
            mage.registerForUndo(this.undoList);
        }
        if (this.spell != null) {
            mage.sendDebugMessage(ChatColor.WHITE + " Finish " + ChatColor.GOLD + this.spell.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + (Object)((Object)this.result), 2);
            this.spell.finish(this);
        }
        String resultName = this.result.name().toLowerCase();
        this.castMessageKey(resultName + "_finish");
        this.playEffects(resultName + "_finish");
    }

    @Override
    public void retarget(int range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(range, fov, closeRange, closeFOV, useHitbox);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public void retarget(int range, double fov, double closeRange, double closeFOV, boolean useHitbox, Vector offset, boolean targetSpaceRequired, int targetMinOffset) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(range, fov, closeRange, closeFOV, useHitbox, offset, targetSpaceRequired, targetMinOffset);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.action.CastContext getBaseContext() {
        return this.base;
    }

    @Override
    public Set<UUID> getTargetMessagesSent() {
        return this.targetMessagesSent;
    }

    @Override
    public Collection<EffectPlay> getCurrentEffects() {
        return this.currentEffects;
    }

    @Override
    public void registerBreakable(Block block, int breakable) {
        if (block == null || block.getType() == Material.AIR) {
            return;
        }
        MageController controller = this.getController();
        if (breakable > 0) {
            block.setMetadata("breakable", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)breakable));
        } else {
            block.removeMetadata("breakable", controller.getPlugin());
        }
        this.undoList.setUndoBreakable(true);
    }

    @Override
    public void registerReflective(Block block, double reflectivity) {
        if (block == null || block.getType() == Material.AIR) {
            return;
        }
        MageController controller = this.getController();
        if (reflectivity > 0.0) {
            block.setMetadata("backfire", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)reflectivity));
        } else {
            block.removeMetadata("backfire", controller.getPlugin());
        }
        this.undoList.setUndoReflective(true);
    }

    @Override
    public Plugin getPlugin() {
        MageController controller = this.getController();
        return controller == null ? null : controller.getPlugin();
    }

    @Override
    public void teleport(Entity entity, Location location, int verticalSearchDistance) {
        Plugin plugin = this.getPlugin();
        TeleportTask task = new TeleportTask(this.getController(), entity, location, verticalSearchDistance, this);
        Bukkit.getScheduler().scheduleSyncDelayedTask(plugin, (Runnable)task, 1L);
    }

    @Override
    public void setSpellParameters(ConfigurationSection parameters) {
        if (this.baseSpell != null) {
            this.baseSpell.processParameters(parameters);
        }
    }

    @Override
    public Set<Material> getMaterialSet(String key) {
        return this.getController().getMaterialSet(key);
    }

    @Override
    public SpellResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(SpellResult result) {
        this.result = result;
    }

    @Override
    public void addResult(SpellResult result) {
        if (!result.isStop()) {
            this.result = this.result.min(result);
        }
    }
}

