/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class WandTemplate {
    private final MageController controller;
    private final String key;
    private final ConfigurationSection configuration;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private Collection<EffectPlay> currentEffects = new ArrayList<EffectPlay>();

    public WandTemplate(MageController controller, String key, ConfigurationSection node) {
        this.key = key;
        this.configuration = node;
        this.controller = controller;
        this.effects.clear();
        if (node.contains("effects")) {
            ConfigurationSection effectsNode = node.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            for (String effectKey : effectKeys) {
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, EffectPlayer.loadEffects(controller.getPlugin(), effectsNode, effectKey));
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public ConfigurationSection getConfiguration() {
        return this.configuration;
    }

    public Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> getEffects(String key) {
        Collection<EffectPlayer> effectList = this.effects.get(key);
        if (effectList == null) {
            return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        }
        return new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>(effectList);
    }

    public void playEffects(Mage mage, String key) {
        this.playEffects(mage, key, 1.0f);
    }

    public void playEffects(Mage mage, String effectName, float scale) {
        this.currentEffects.clear();
        Location wandLocation = null;
        Location location = mage.getLocation();
        Location eyeLocation = mage.getEyeLocation();
        Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> effects = this.getEffects(effectName);
        if (effects.size() > 0) {
            Entity sourceEntity = mage.getEntity();
            for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : effects) {
                Location source;
                player.setEffectPlayList(this.currentEffects);
                player.setScale(scale);
                player.setColor(mage.getEffectColor());
                String overrideParticle = mage.getEffectParticleName();
                player.setParticleOverride(overrideParticle);
                Location location2 = source = player.shouldUseEyeLocation() ? eyeLocation : location;
                if (player.shouldUseWandLocation()) {
                    if (wandLocation == null) {
                        wandLocation = mage.getWandLocation();
                    }
                    location = wandLocation;
                }
                player.start(source, sourceEntity, null, null, null);
            }
        }
    }
}

