/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.BoundingBox;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.lang.ref.WeakReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Target
implements Comparable<Target> {
    public static boolean DEBUG_TARGETING = false;
    protected int maxDistanceSquared = 16384;
    protected int minDistanceSquared = 0;
    protected double maxAngle = 0.3;
    protected boolean useHitbox = false;
    protected float distanceWeight = 1.0f;
    protected float fovWeight = 4.0f;
    protected int npcWeight = -1;
    protected int playerWeight = 4;
    protected int livingEntityWeight = 3;
    protected int mageWeight = 5;
    protected double closeDistanceSquared = 1.0;
    protected double closeAngle = 1.5707963267948966;
    private Location source;
    private Location location;
    private MaterialAndData locationMaterial;
    private WeakReference<Entity> _entity;
    private Mage mage;
    private boolean reverseDistance = false;
    private double distanceSquared = 100000.0;
    private double angle = 10000.0;
    private int score = 0;
    private Object extraData = null;

    public Target(Location sourceLocation) {
        this.source = sourceLocation;
    }

    public Target(Location sourceLocation, Block block) {
        this.source = sourceLocation;
        this.locationMaterial = new MaterialAndData(block);
        if (block != null) {
            this.location = block.getLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Block block, int range) {
        this(sourceLocation, block, range, 0.3, false);
    }

    public Target(Location sourceLocation, Block block, int range, double angle) {
        this(sourceLocation, block, range, angle, false);
    }

    public Target(Location sourceLocation, Block block, int range, double angle, boolean reverseDistance) {
        this.maxDistanceSquared = range * range;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        if (block != null) {
            this.location = block.getLocation();
        }
        this.locationMaterial = new MaterialAndData(block);
        this.calculateScore();
    }

    public Target(Location sourceLocation, Block block, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistanceSquared = maxRange * maxRange;
        this.minDistanceSquared = minRange * minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        if (block != null) {
            this.location = block.getLocation();
        }
        this.locationMaterial = new MaterialAndData(block);
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range) {
        this.maxDistanceSquared = range * range;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, boolean hitbox) {
        this.maxDistanceSquared = range * range;
        this.source = sourceLocation;
        this.useHitbox = hitbox;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle) {
        this.maxDistanceSquared = range * range;
        this.maxAngle = angle;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle, double closeRange, double closeAngle, float distanceWeight, float fovWeight, int mageWeight, int npcWeight, int playerWeight, int livingEntityWeight) {
        this.closeDistanceSquared = closeRange * closeRange;
        this.closeAngle = closeAngle;
        this.maxDistanceSquared = range * range;
        this.maxAngle = angle;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        this.distanceWeight = distanceWeight;
        this.fovWeight = fovWeight;
        this.mageWeight = mageWeight;
        this.npcWeight = npcWeight;
        this.playerWeight = playerWeight;
        this.livingEntityWeight = livingEntityWeight;
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle, double closeRange, double closeAngle) {
        this.closeDistanceSquared = closeRange * closeRange;
        this.closeAngle = closeAngle;
        this.maxDistanceSquared = range * range;
        this.maxAngle = angle;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int range, double angle, boolean reverseDistance) {
        this.maxDistanceSquared = range * range;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistanceSquared = maxRange * maxRange;
        this.minDistanceSquared = minRange * minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Mage mage, int minRange, int maxRange, double angle, boolean reverseDistance) {
        this.maxDistanceSquared = maxRange * maxRange;
        this.minDistanceSquared = minRange * minRange;
        this.maxAngle = angle;
        this.reverseDistance = reverseDistance;
        this.source = sourceLocation;
        this.mage = mage;
        if (mage != null) {
            this._entity = new WeakReference<LivingEntity>(mage.getLivingEntity());
        }
        if (mage != null) {
            this.location = mage.getEyeLocation();
        }
        this.calculateScore();
    }

    public Target(Location sourceLocation, Entity entity) {
        this.maxDistanceSquared = 0;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
    }

    public Target(Location sourceLocation, Entity entity, Block block) {
        this.maxDistanceSquared = 0;
        this.source = sourceLocation;
        this._entity = new WeakReference<Entity>(entity);
        if (block != null) {
            this.location = block.getLocation();
        } else if (entity != null) {
            this.location = CompatibilityUtils.getEyeLocation(entity);
        }
    }

    public int getScore() {
        return this.score;
    }

    protected void calculateScore() {
        this.score = 0;
        if (this.source == null) {
            return;
        }
        Vector playerFacing = this.source.getDirection();
        Vector playerLoc = new Vector(this.source.getX(), this.source.getY(), this.source.getZ());
        Location targetLocation = this.getLocation();
        if (targetLocation == null) {
            return;
        }
        Vector targetLoc = new Vector(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
        Vector targetDirection = new Vector(targetLoc.getX() - playerLoc.getX(), targetLoc.getY() - playerLoc.getY(), targetLoc.getZ() - playerLoc.getZ());
        this.distanceSquared = targetDirection.lengthSquared();
        if (this.maxDistanceSquared > 0 && this.distanceSquared > (double)this.maxDistanceSquared) {
            return;
        }
        if (this.distanceSquared < (double)this.minDistanceSquared) {
            return;
        }
        Entity entity = this.getEntity();
        if (this.useHitbox) {
            Vector playerMaxRange = playerLoc.clone().add(playerFacing.multiply(this.maxDistanceSquared));
            BoundingBox hitbox = null;
            if (entity != null) {
                hitbox = CompatibilityUtils.getHitbox(entity);
            }
            if (hitbox == null) {
                hitbox = new BoundingBox(targetLoc, -0.5, 0.5, 0.0, 1.0, -0.5, 0.5);
                if (DEBUG_TARGETING && entity != null) {
                    Bukkit.getLogger().info(" failed to get hitbox for " + entity.getType() + " : " + targetLoc);
                }
            }
            if (DEBUG_TARGETING && entity != null) {
                Bukkit.getLogger().info("CHECKING " + entity.getType() + ": " + hitbox + ", " + playerLoc + " - " + playerMaxRange + ": " + hitbox.intersectsLine(playerLoc, playerMaxRange));
            }
            if (!hitbox.intersectsLine(playerLoc, playerMaxRange)) {
                return;
            }
            Vector hit = hitbox.getIntersection(playerLoc, playerMaxRange);
            if (hit != null) {
                this.location.setX(hit.getX());
                this.location.setY(hit.getY());
                this.location.setZ(hit.getZ());
            }
            if (DEBUG_TARGETING) {
                Bukkit.getLogger().info("HIT: " + hit);
            }
        } else {
            this.angle = targetDirection.angle(playerFacing);
            double checkAngle = this.maxAngle;
            if (this.closeDistanceSquared > 0.0 && (double)this.maxDistanceSquared > this.closeDistanceSquared) {
                if (this.distanceSquared <= this.closeDistanceSquared) {
                    checkAngle = this.closeAngle;
                } else {
                    double ratio = (this.distanceSquared - this.closeDistanceSquared) / ((double)this.maxDistanceSquared - this.closeDistanceSquared);
                    checkAngle = this.closeAngle - ratio * (this.closeAngle - this.maxAngle);
                }
            }
            if (DEBUG_TARGETING && this.hasEntity()) {
                Bukkit.getLogger().info("CHECKING " + this.getEntity().getType() + " (" + this.closeDistanceSquared + ") " + " angle = " + this.angle + " against " + checkAngle + " at distance " + this.distanceSquared + " rangeA = (" + this.closeAngle + " to " + this.maxAngle + "), rangeD = (" + this.closeDistanceSquared + " to " + this.maxDistanceSquared + ")" + " ... from " + playerLoc + " to " + targetLoc);
            }
            if (checkAngle > 0.0 && this.angle > checkAngle) {
                return;
            }
        }
        if (this.reverseDistance) {
            this.distanceSquared = (double)this.maxDistanceSquared - this.distanceSquared;
        }
        this.score = 1;
        if (this.maxDistanceSquared > 0) {
            this.score = (int)((double)this.score + ((double)this.maxDistanceSquared - this.distanceSquared) * (double)this.distanceWeight);
        }
        if (!this.useHitbox && this.angle > 0.0) {
            this.score = (int)((double)this.score + (3.0 - this.angle) * (double)this.fovWeight);
        }
        if (entity != null && this.mage != null && this.mage.getController().isNPC(entity)) {
            this.score += this.npcWeight;
        } else if (this.mage != null) {
            this.score += this.mageWeight;
        } else if (entity instanceof Player) {
            this.score += this.playerWeight;
        } else if (entity instanceof LivingEntity) {
            this.score += this.livingEntityWeight;
        }
        if (DEBUG_TARGETING && entity != null) {
            Bukkit.getLogger().info("TARGETED " + entity.getType() + ": r2=" + this.distanceSquared + " (" + this.distanceWeight + "), a=" + this.angle + " (" + this.fovWeight + "), score: " + this.score);
        }
    }

    @Override
    public int compareTo(Target other) {
        return other.score - this.score;
    }

    public boolean hasEntity() {
        return this.getEntity() != null;
    }

    public boolean isValid() {
        return this.location != null;
    }

    public boolean hasTarget() {
        return this.location != null;
    }

    public Entity getEntity() {
        return this._entity == null ? null : (Entity)this._entity.get();
    }

    public Block getBlock() {
        if (this.location == null) {
            return null;
        }
        return this.location.getBlock();
    }

    public double getDistanceSquared() {
        return this.distanceSquared;
    }

    public Location getLocation() {
        return this.location;
    }

    public void add(Vector offset) {
        if (this.location != null) {
            this.location = this.location.add(offset);
        }
    }

    public void setDirection(Vector direction) {
        if (this.location != null) {
            this.location = this.location.setDirection(direction);
        }
    }

    public void setWorld(World world) {
        if (this.location != null) {
            this.location.setWorld(world);
        }
    }

    public Object getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Object extraData) {
        this.extraData = extraData;
    }

    public void setEntity(Entity entity) {
        this._entity = new WeakReference<Entity>(entity);
        if (entity != null) {
            this.location = entity.getLocation();
        }
        this.calculateScore();
    }

    public MaterialAndData getTargetedMaterial() {
        return this.locationMaterial;
    }
}

