/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import org.bukkit.util.Vector;

public class BoundingBox {
    private final Vector min;
    private final Vector max;

    public BoundingBox(Vector min, Vector max) {
        this.min = min.clone();
        this.max = max.clone();
    }

    public BoundingBox(double dMinX, double dMaxX, double dMinY, double dMaxY, double dMinZ, double dMaxZ) {
        this.min = new Vector(dMinX, dMinY, dMinZ);
        this.max = new Vector(dMaxX, dMaxY, dMaxZ);
    }

    public BoundingBox(Vector center, double dMinX, double dMaxX, double dMinY, double dMaxY, double dMinZ, double dMaxZ) {
        this.min = new Vector(center.getX() + dMinX, center.getY() + dMinY, center.getZ() + dMinZ);
        this.max = new Vector(center.getX() + dMaxX, center.getY() + dMaxY, center.getZ() + dMaxZ);
    }

    public BoundingBox center(Vector center) {
        BoundingBox results = new BoundingBox(this.min, this.max);
        results.min.add(center);
        results.max.add(center);
        return results;
    }

    public Vector center() {
        return this.max.clone().add(this.min).multiply(0.5);
    }

    public BoundingBox scale(double scale) {
        if (scale <= 0.0 || scale == 1.0) {
            return this;
        }
        Vector center = this.center();
        this.min.setX((this.min.getX() - center.getX()) * scale + center.getX());
        this.min.setY((this.min.getY() - center.getY()) * scale + center.getY());
        this.min.setZ((this.min.getZ() - center.getZ()) * scale + center.getZ());
        this.max.setX((this.max.getX() - center.getX()) * scale + center.getX());
        this.max.setY((this.max.getY() - center.getY()) * scale + center.getY());
        this.max.setZ((this.max.getZ() - center.getZ()) * scale + center.getZ());
        return this;
    }

    public BoundingBox scaleFromBase(double scale, double scaleY) {
        if (scale <= 0.0 || scale == 1.0) {
            return this;
        }
        Vector center = this.center();
        this.min.setX((this.min.getX() - center.getX()) * scale + center.getX());
        this.min.setZ((this.min.getZ() - center.getZ()) * scale + center.getZ());
        this.max.setX((this.max.getX() - center.getX()) * scale + center.getX());
        this.max.setY((this.max.getY() - center.getY()) * scaleY + center.getY());
        this.max.setZ((this.max.getZ() - center.getZ()) * scale + center.getZ());
        return this;
    }

    public boolean intersectsLine(Vector p1, Vector p2) {
        double epsilon = 1.0E-4f;
        p1 = p1.clone();
        p2 = p2.clone();
        Vector d = p2.subtract(p1).multiply(0.5);
        Vector e = this.max.clone().subtract(this.min).multiply(0.5);
        Vector c = p1.add(d).subtract(this.min.clone().add(this.max).multiply(0.5));
        Vector ad = new Vector(Math.abs(d.getX()), Math.abs(d.getY()), Math.abs(d.getZ()));
        if (Math.abs(c.getX()) > e.getX() + ad.getX()) {
            return false;
        }
        if (Math.abs(c.getY()) > e.getY() + ad.getY()) {
            return false;
        }
        if (Math.abs(c.getZ()) > e.getZ() + ad.getZ()) {
            return false;
        }
        if (Math.abs(d.getY() * c.getZ() - d.getZ() * c.getY()) > e.getY() * ad.getZ() + e.getZ() * ad.getY() + (double)1.0E-4f) {
            return false;
        }
        if (Math.abs(d.getZ() * c.getX() - d.getX() * c.getZ()) > e.getZ() * ad.getX() + e.getX() * ad.getZ() + (double)1.0E-4f) {
            return false;
        }
        return !(Math.abs(d.getX() * c.getY() - d.getY() * c.getX()) > e.getX() * ad.getY() + e.getY() * ad.getX() + (double)1.0E-4f);
    }

    protected Vector getIntersection(double fDst1, double fDst2, Vector P1, Vector P2) {
        if (fDst1 * fDst2 >= 0.0) {
            return null;
        }
        if (fDst1 == fDst2) {
            return null;
        }
        Vector P2_clone = P2.clone();
        return P1.clone().add(P2_clone.subtract(P1).multiply(-fDst1 / (fDst2 - fDst1)));
    }

    protected boolean inBox(Vector hit, int axis) {
        if (axis == 1 && hit.getZ() > this.min.getZ() && hit.getZ() < this.max.getZ() && hit.getY() > this.min.getY() && hit.getY() < this.max.getY()) {
            return true;
        }
        if (axis == 2 && hit.getZ() > this.min.getZ() && hit.getZ() < this.max.getZ() && hit.getX() > this.min.getX() && hit.getX() < this.max.getX()) {
            return true;
        }
        return axis == 3 && hit.getX() > this.min.getX() && hit.getX() < this.max.getX() && hit.getY() > this.min.getY() && hit.getY() < this.max.getY();
    }

    public Vector getIntersection(Vector p1, Vector p2) {
        Vector hit = this.getIntersection(p1.getX() - this.min.getX(), p2.getX() - this.min.getX(), p1, p2);
        if (hit != null && this.inBox(hit, 1)) {
            return hit;
        }
        hit = this.getIntersection(p1.getY() - this.min.getY(), p2.getY() - this.min.getY(), p1, p2);
        if (hit != null && this.inBox(hit, 2)) {
            return hit;
        }
        hit = this.getIntersection(p1.getZ() - this.min.getZ(), p2.getZ() - this.min.getZ(), p1, p2);
        if (hit != null && this.inBox(hit, 3)) {
            return hit;
        }
        hit = this.getIntersection(p1.getX() - this.max.getX(), p2.getX() - this.max.getX(), p1, p2);
        if (hit != null && this.inBox(hit, 1)) {
            return hit;
        }
        hit = this.getIntersection(p1.getY() - this.max.getY(), p2.getY() - this.max.getY(), p1, p2);
        if (hit != null && this.inBox(hit, 2)) {
            return hit;
        }
        hit = this.getIntersection(p1.getZ() - this.max.getZ(), p2.getZ() - this.max.getZ(), p1, p2);
        if (hit != null && this.inBox(hit, 3)) {
            return hit;
        }
        return null;
    }

    public Vector size() {
        return this.max.clone().subtract(this.min);
    }

    public String toString() {
        return "[" + this.min.toString() + " - " + this.max.toString() + "] (" + (this.max.getX() - this.min.getX()) + "x" + (this.max.getY() - this.min.getY()) + "x" + (this.max.getZ() - this.min.getZ()) + ")";
    }
}

