/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;

public abstract class UndoableSpell
extends TargetingSpell {
    private UndoList modifiedBlocks = null;
    private boolean undoEntityEffects = false;
    private Set<EntityType> undoEntityTypes = null;
    private boolean bypassUndo = false;
    private int autoUndo = 0;

    @Override
    public void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.undoEntityEffects = parameters.getBoolean("entity_undo", false);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
        this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
        this.autoUndo = parameters.getInt("undo", 0);
        this.autoUndo = parameters.getInt("u", this.autoUndo);
        this.bypassUndo = parameters.getBoolean("bypass_undo", false);
        if (parameters.contains("entity_undo_types")) {
            this.undoEntityTypes = new HashSet<EntityType>();
            List<String> typeStrings = ConfigurationUtils.getStringList(parameters, "entity_undo_types");
            for (String typeString : typeStrings) {
                try {
                    this.undoEntityTypes.add(EntityType.valueOf((String)typeString.toUpperCase()));
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Unknown entity type: " + typeString);
                }
            }
        } else {
            this.undoEntityTypes = this.controller.getUndoEntityTypes();
        }
        this.configureUndoList();
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            this.bypassUndo = parameters.getBoolean("bypass_undo", false);
            this.bypassUndo = parameters.getBoolean("bu", this.bypassUndo);
            this.autoUndo = parameters.getInt("undo", 0);
            this.autoUndo = parameters.getInt("u", this.autoUndo);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.modifiedBlocks = null;
    }

    public int getModifiedCount() {
        return this.modifiedBlocks == null ? 0 : this.modifiedBlocks.size();
    }

    public void registerForUndo() {
        UndoList list = this.getUndoList();
        if (!list.isScheduled()) {
            this.controller.update(list);
        }
        this.mage.registerForUndo(list);
    }

    public void registerForUndo(Block block) {
        this.getUndoList().add(block);
    }

    public void registerForUndo(Runnable runnable) {
        this.getUndoList().add(runnable);
    }

    public void registerForUndo(Entity entity) {
        this.getUndoList().add(entity);
    }

    public void registerModified(Entity entity) {
        this.getUndoList().modify(entity);
    }

    public void registerPotionEffects(Entity entity) {
        this.getUndoList().addPotionEffects(entity);
    }

    public void registerMoved(Entity entity) {
        this.getUndoList().move(entity);
    }

    public void registerVelocity(Entity entity) {
        this.getUndoList().modifyVelocity(entity);
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        this.getUndoList().watch(entity);
    }

    public UndoList getUndoList() {
        if (this.modifiedBlocks == null) {
            this.modifiedBlocks = new UndoList(this.mage, this.getName());
            this.modifiedBlocks.setSpell(this);
            this.configureUndoList();
        }
        return this.modifiedBlocks;
    }

    protected void configureUndoList() {
        if (this.modifiedBlocks != null) {
            this.modifiedBlocks.setEntityUndo(this.undoEntityEffects);
            this.modifiedBlocks.setEntityUndoTypes(this.undoEntityTypes);
            this.modifiedBlocks.setBypass(this.bypassUndo);
            this.modifiedBlocks.setScheduleUndo(this.autoUndo);
        }
    }

    public boolean contains(Block block) {
        return this.modifiedBlocks.contains(block);
    }

    public int getScheduledUndo() {
        return this.autoUndo;
    }

    @Override
    public boolean isUndoable() {
        return !this.bypassUndo;
    }

    public void applyPotionEffects(Location location, int radius, Collection<PotionEffect> potionEffects) {
        if (potionEffects == null || radius <= 0 || potionEffects.size() == 0) {
            return;
        }
        int radiusSquared = radius * 2;
        List<Entity> entities = CompatibilityUtils.getNearbyEntities(location, radius, radius, radius);
        for (Entity entity : entities) {
            String playerMessage;
            boolean isSourcePlayer;
            if (!(entity instanceof LivingEntity)) continue;
            Mage targetMage = null;
            if (this.controller.isMage(entity)) {
                targetMage = this.controller.getMage(entity);
            }
            boolean bl = isSourcePlayer = entity == this.mage.getEntity();
            if (isSourcePlayer && this.getTargetType() != TargetType.ANY && this.getTargetType() != TargetType.SELF || targetMage != null && this.isSuperProtected(targetMage) && !isSourcePlayer || !this.canTarget(entity) || !(entity.getLocation().distanceSquared(location) < (double)radiusSquared)) continue;
            this.registerPotionEffects(entity);
            CompatibilityUtils.applyPotionEffects((LivingEntity)entity, potionEffects);
            if (targetMage == null || (playerMessage = this.getMessage("cast_player_message")).length() <= 0) continue;
            playerMessage = playerMessage.replace("$spell", this.getName());
            targetMage.sendMessage(playerMessage);
        }
    }

    @Override
    public long getDuration() {
        if (!this.bypassUndo && this.autoUndo != 0) {
            return this.autoUndo;
        }
        return super.getDuration();
    }
}

